/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;

public class LongColumnVector
extends ColumnVector {
    public long[] vector;
    private final LongWritable writableObj = new LongWritable();
    public static final long NULL_VALUE = 1L;

    public LongColumnVector() {
        this(1024);
    }

    public LongColumnVector(int len) {
        super(len);
        this.vector = new long[len];
    }

    @Override
    public Writable getWritableObject(int index) {
        if (this.isRepeating) {
            index = 0;
        }
        if (!this.noNulls && this.isNull[index]) {
            return NullWritable.get();
        }
        this.writableObj.set(this.vector[index]);
        return this.writableObj;
    }

    public void copySelected(boolean selectedInUse, int[] sel, int size, LongColumnVector output) {
        int i;
        int j;
        output.noNulls = this.noNulls;
        output.isRepeating = false;
        if (this.isRepeating) {
            output.vector[0] = this.vector[0];
            output.isNull[0] = this.isNull[0];
            output.isRepeating = true;
            return;
        }
        if (selectedInUse) {
            for (j = 0; j < size; ++j) {
                i = sel[j];
                output.vector[i] = this.vector[i];
            }
        } else {
            System.arraycopy(this.vector, 0, output.vector, 0, size);
        }
        if (!this.noNulls) {
            if (selectedInUse) {
                for (j = 0; j < size; ++j) {
                    i = sel[j];
                    output.isNull[i] = this.isNull[i];
                }
            } else {
                System.arraycopy(this.isNull, 0, output.isNull, 0, size);
            }
        }
    }

    public void copySelected(boolean selectedInUse, int[] sel, int size, DoubleColumnVector output) {
        int i;
        int j;
        output.noNulls = this.noNulls;
        output.isRepeating = false;
        if (this.isRepeating) {
            output.vector[0] = this.vector[0];
            output.isNull[0] = this.isNull[0];
            output.isRepeating = true;
            return;
        }
        if (selectedInUse) {
            for (j = 0; j < size; ++j) {
                i = sel[j];
                output.vector[i] = this.vector[i];
            }
        } else {
            System.arraycopy(this.vector, 0, output.vector, 0, size);
        }
        if (!this.noNulls) {
            if (selectedInUse) {
                for (j = 0; j < size; ++j) {
                    i = sel[j];
                    output.isNull[i] = this.isNull[i];
                }
            } else {
                System.arraycopy(this.isNull, 0, output.isNull, 0, size);
            }
        }
    }

    public void fill(long value) {
        this.noNulls = true;
        this.isRepeating = true;
        this.vector[0] = value;
    }

    @Override
    public void flatten(boolean selectedInUse, int[] sel, int size) {
        this.flattenPush();
        if (this.isRepeating) {
            this.isRepeating = false;
            long repeatVal = this.vector[0];
            if (selectedInUse) {
                for (int j = 0; j < size; ++j) {
                    int i = sel[j];
                    this.vector[i] = repeatVal;
                }
            } else {
                Arrays.fill(this.vector, 0, size, repeatVal);
            }
            this.flattenRepeatingNulls(selectedInUse, sel, size);
        }
        this.flattenNoNulls(selectedInUse, sel, size);
    }

    @Override
    public void setElement(int outElementNum, int inputElementNum, ColumnVector inputVector) {
        this.vector[outElementNum] = ((LongColumnVector)inputVector).vector[inputElementNum];
    }
}

