/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.expression.TemporalExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;

public class DateGetHour4Method
extends AbstractSQLMethod {
    @Override
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (!(expr instanceof TemporalExpression)) {
            throw new NucleusException(LOCALISER.msg("060001", (Object)"getHour()", (Object)expr));
        }
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        JavaTypeMapping mapping = storeMgr.getMappingManager().getMapping(String.class);
        SQLExpression hh = this.exprFactory.newLiteral(this.stmt, mapping, "hh");
        ((StringLiteral)hh).generateStatementWithoutQuotes();
        ArrayList<SQLExpression> funcArgs = new ArrayList<SQLExpression>();
        funcArgs.add(hh);
        funcArgs.add(expr);
        return new NumericExpression(this.stmt, this.getMappingForClass(Integer.TYPE), "DATEPART", funcArgs);
    }
}

