/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.text.SimpleDateFormat;
import org.apache.spark.internal.Logging;
import org.apache.spark.metrics.source.Source;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.streaming.MetricsReporter$;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.streaming.StateOperatorProgress;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}4A!\u0001\u0002\u0001\u001f\tyQ*\u001a;sS\u000e\u001c(+\u001a9peR,'O\u0003\u0002\u0004\t\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000b\u0019\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001bC\b\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]aR\"\u0001\r\u000b\u0005eQ\u0012AB:pkJ\u001cWM\u0003\u0002\u001c\u0011\u00059Q.\u001a;sS\u000e\u001c\u0018BA\u000f\u0019\u0005\u0019\u0019v.\u001e:dKB\u0011qDI\u0007\u0002A)\u0011\u0011\u0005C\u0001\tS:$XM\u001d8bY&\u00111\u0005\t\u0002\b\u0019><w-\u001b8h\u0011!)\u0003A!A!\u0002\u00131\u0013AB:ue\u0016\fW\u000e\u0005\u0002(Q5\t!!\u0003\u0002*\u0005\ty1\u000b\u001e:fC6,\u00050Z2vi&|g\u000e\u0003\u0005,\u0001\t\u0015\r\u0011\"\u0011-\u0003)\u0019x.\u001e:dK:\u000bW.Z\u000b\u0002[A\u0011a&\r\b\u0003#=J!\u0001\r\n\u0002\rA\u0013X\rZ3g\u0013\t\u00114G\u0001\u0004TiJLgn\u001a\u0006\u0003aIA\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006I!L\u0001\fg>,(oY3OC6,\u0007\u0005C\u00038\u0001\u0011\u0005\u0001(\u0001\u0004=S:LGO\u0010\u000b\u0004siZ\u0004CA\u0014\u0001\u0011\u0015)c\u00071\u0001'\u0011\u0015Yc\u00071\u0001.\u0011\u001di\u0004A1A\u0005By\na\"\\3ue&\u001c'+Z4jgR\u0014\u00180F\u0001@!\t\u0001e)D\u0001B\u0015\tY\"I\u0003\u0002D\t\u0006A1m\u001c3bQ\u0006dWMC\u0001F\u0003\r\u0019w.\\\u0005\u0003\u000f\u0006\u0013a\"T3ue&\u001c'+Z4jgR\u0014\u0018\u0010\u0003\u0004J\u0001\u0001\u0006IaP\u0001\u0010[\u0016$(/[2SK\u001eL7\u000f\u001e:zA!91\n\u0001b\u0001\n\u0013a\u0015a\u0004;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;\u0016\u00035\u0003\"AT*\u000e\u0003=S!\u0001U)\u0002\tQ,\u0007\u0010\u001e\u0006\u0002%\u0006!!.\u0019<b\u0013\t!vJ\u0001\tTS6\u0004H.\u001a#bi\u00164uN]7bi\"1a\u000b\u0001Q\u0001\n5\u000b\u0001\u0003^5nKN$\u0018-\u001c9G_Jl\u0017\r\u001e\u0011\t\u000ba\u0003A\u0011B-\u00023\r|gN^3siN#(/\u001b8h\t\u0006$X\rV8NS2d\u0017n\u001d\u000b\u00035v\u0003\"!E.\n\u0005q\u0013\"\u0001\u0002'p]\u001eDQAX,A\u00025\nQ\"[:p+R\u001cG)\u0019;f'R\u0014\b\"\u00021\u0001\t\u0013\t\u0017!\u0004:fO&\u001cH/\u001a:HCV<W-\u0006\u0002ciR!1M\u001a5~!\t\tB-\u0003\u0002f%\t!QK\\5u\u0011\u00159w\f1\u0001.\u0003\u0011q\u0017-\\3\t\u000b%|\u0006\u0019\u00016\u0002\u0003\u0019\u0004B!E6ne&\u0011AN\u0005\u0002\n\rVt7\r^5p]F\u0002\"A\u001c9\u000e\u0003=T!a\u0001\u0004\n\u0005E|'AF*ue\u0016\fW.\u001b8h#V,'/\u001f)s_\u001e\u0014Xm]:\u0011\u0005M$H\u0002\u0001\u0003\u0006k~\u0013\rA\u001e\u0002\u0002)F\u0011qO\u001f\t\u0003#aL!!\u001f\n\u0003\u000f9{G\u000f[5oOB\u0011\u0011c_\u0005\u0003yJ\u00111!\u00118z\u0011\u0015qx\f1\u0001s\u0003\u001d!WMZ1vYR\u0004")
public class MetricsReporter
implements Source,
Logging {
    public final StreamExecution org$apache$spark$sql$execution$streaming$MetricsReporter$$stream;
    private final String sourceName;
    private final MetricRegistry metricRegistry;
    private final SimpleDateFormat timestampFormat;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public String sourceName() {
        return this.sourceName;
    }

    public MetricRegistry metricRegistry() {
        return this.metricRegistry;
    }

    private SimpleDateFormat timestampFormat() {
        return this.timestampFormat;
    }

    public long org$apache$spark$sql$execution$streaming$MetricsReporter$$convertStringDateToMillis(String isoUtcDateStr) {
        return isoUtcDateStr == null ? 0L : this.timestampFormat().parse(isoUtcDateStr).getTime();
    }

    private <T> void registerGauge(String name2, Function1<StreamingQueryProgress, T> f, T t) {
        MetricsReporter metricsReporter = this;
        synchronized (metricsReporter) {
            this.metricRegistry().register(name2, (Metric)new Gauge<T>(this, f, t){
                private final /* synthetic */ MetricsReporter $outer;
                private final Function1 f$1;
                public final Object default$1;

                public T getValue() {
                    return (T)Option$.MODULE$.apply((Object)this.$outer.org$apache$spark$sql$execution$streaming$MetricsReporter$$stream.lastProgress()).map(this.f$1).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anon$1 $outer;

                        public final T apply() {
                            return (T)this.$outer.default$1;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.f$1 = f$1;
                    this.default$1 = default$1;
                }
            });
            return;
        }
    }

    public MetricsReporter(StreamExecution stream, String sourceName) {
        this.org$apache$spark$sql$execution$streaming$MetricsReporter$$stream = stream;
        this.sourceName = sourceName;
        Logging.class.$init$((Logging)this);
        this.metricRegistry = new MetricRegistry();
        this.registerGauge("inputRate-total", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(StreamingQueryProgress x$1) {
                return x$1.inputRowsPerSecond();
            }
        }, (Object)BoxesRunTime.boxToDouble((double)0.0));
        this.registerGauge("processingRate-total", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(StreamingQueryProgress x$2) {
                return x$2.processedRowsPerSecond();
            }
        }, (Object)BoxesRunTime.boxToDouble((double)0.0));
        this.registerGauge("latency", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(StreamingQueryProgress x$3) {
                return x$3.durationMs().get("triggerExecution");
            }
        }, (Object)BoxesRunTime.boxToLong((long)0L));
        this.timestampFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.timestampFormat().setTimeZone(DateTimeUtils$.MODULE$.getTimeZone("UTC"));
        this.registerGauge("eventTime-watermark", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsReporter $outer;

            public final long apply(StreamingQueryProgress progress) {
                return this.$outer.org$apache$spark$sql$execution$streaming$MetricsReporter$$convertStringDateToMillis(progress.eventTime().get("watermark"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Object)BoxesRunTime.boxToLong((long)0L));
        this.registerGauge("states-rowsTotal", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(StreamingQueryProgress x$4) {
                return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])x$4.stateOperators()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(StateOperatorProgress x$5) {
                        return x$5.numRowsTotal();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            }
        }, (Object)BoxesRunTime.boxToLong((long)0L));
        this.registerGauge("states-usedBytes", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(StreamingQueryProgress x$6) {
                return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])x$6.stateOperators()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(StateOperatorProgress x$7) {
                        return x$7.memoryUsedBytes();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            }
        }, (Object)BoxesRunTime.boxToLong((long)0L));
    }
}

