/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer.spi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.datanucleus.enhancer.spi.SingleFieldPK;

public class ByteFieldPK
extends SingleFieldPK {
    private byte key;

    public ByteFieldPK(Class pcClass, byte key) {
        super(pcClass);
        this.key = key;
        this.hashCode = super.hashClassName() ^ this.key;
    }

    public ByteFieldPK(Class pcClass, Byte key) {
        super(pcClass);
        this.setKeyAsObject(key);
        this.key = key;
        this.hashCode = super.hashClassName() ^ this.key;
    }

    public ByteFieldPK(Class pcClass, String str) {
        super(pcClass);
        this.assertKeyNotNull(str);
        this.key = Byte.parseByte(str);
        this.hashCode = super.hashClassName() ^ this.key;
    }

    public ByteFieldPK() {
    }

    public byte getKey() {
        return this.key;
    }

    public String toString() {
        return Byte.toString(this.key);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ByteFieldPK other = (ByteFieldPK)obj;
        return this.key == other.key;
    }

    public int compareTo(Object o) {
        if (o instanceof ByteFieldPK) {
            ByteFieldPK other = (ByteFieldPK)o;
            return this.key - other.key;
        }
        if (o == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + o.getClass().getName());
    }

    @Override
    protected Object createKeyAsObject() {
        return this.key;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(this.key);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.key = in.readByte();
    }
}

