/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;

public class PartitionKeySampler
implements OutputCollector<HiveKey, Object> {
    private static final Log LOG = LogFactory.getLog(PartitionKeySampler.class);
    public static final Comparator<byte[]> C = new Comparator<byte[]>(){

        @Override
        public final int compare(byte[] o1, byte[] o2) {
            return WritableComparator.compareBytes((byte[])o1, (int)0, (int)o1.length, (byte[])o2, (int)0, (int)o2.length);
        }
    };
    private final List<byte[]> sampled = new ArrayList<byte[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSampleFile(Path inputPath, JobConf job) throws IOException {
        FileSystem fs = inputPath.getFileSystem((Configuration)job);
        FSDataInputStream input = fs.open(inputPath);
        try {
            int count = input.readInt();
            for (int i = 0; i < count; ++i) {
                byte[] key = new byte[input.readInt()];
                input.readFully(key);
                this.sampled.add(key);
            }
        }
        finally {
            IOUtils.closeStream((Closeable)input);
        }
    }

    public void collect(HiveKey key, Object value) throws IOException {
        this.sampled.add(Arrays.copyOfRange(key.getBytes(), 0, key.getLength()));
    }

    private byte[][] getPartitionKeys(int numReduce) {
        if (this.sampled.size() < numReduce - 1) {
            throw new IllegalStateException("not enough number of sample");
        }
        byte[][] sorted = (byte[][])this.sampled.toArray((T[])new byte[this.sampled.size()][]);
        Arrays.sort(sorted, C);
        return PartitionKeySampler.toPartitionKeys(sorted, numReduce);
    }

    static final byte[][] toPartitionKeys(byte[][] sorted, int numPartition) {
        byte[][] partitionKeys = new byte[numPartition - 1][];
        int last = 0;
        int current = 0;
        for (int i = 0; i < numPartition - 1; ++i) {
            current += Math.round((float)(sorted.length - current) / (float)(numPartition - i));
            while (i > 0 && current < sorted.length && C.compare(sorted[last], sorted[current]) == 0) {
                ++current;
            }
            if (current >= sorted.length) {
                return (byte[][])Arrays.copyOfRange(partitionKeys, 0, i);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Partition key " + current + "th :" + new BytesWritable(sorted[current])));
            }
            partitionKeys[i] = sorted[current];
            last = current;
        }
        return partitionKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePartitionKeys(Path path, HiveConf conf, JobConf job) throws IOException {
        byte[][] partitionKeys = this.getPartitionKeys(job.getNumReduceTasks());
        int numPartition = partitionKeys.length + 1;
        if (numPartition != job.getNumReduceTasks()) {
            job.setNumReduceTasks(numPartition);
        }
        FileSystem fs = path.getFileSystem((Configuration)job);
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)job, (Path)path, BytesWritable.class, NullWritable.class);
        try {
            for (byte[] pkey : partitionKeys) {
                BytesWritable wrapper = new BytesWritable(pkey);
                writer.append((Writable)wrapper, (Writable)NullWritable.get());
            }
        }
        finally {
            IOUtils.closeStream((Closeable)writer);
        }
    }

    public static FetchOperator createSampler(FetchWork work, HiveConf conf, JobConf job, Operator<?> operator) throws HiveException {
        int sampleNum = conf.getIntVar(HiveConf.ConfVars.HIVESAMPLINGNUMBERFORORDERBY);
        float samplePercent = conf.getFloatVar(HiveConf.ConfVars.HIVESAMPLINGPERCENTFORORDERBY);
        if ((double)samplePercent < 0.0 || (double)samplePercent > 1.0) {
            throw new IllegalArgumentException("Percentile value must be within the range of 0 to 1.");
        }
        RandomSampler sampler = new RandomSampler(work, job, operator);
        sampler.setSampleNum(sampleNum);
        sampler.setSamplePercent(samplePercent);
        return sampler;
    }

    private static class RandomSampler
    extends FetchOperator {
        private int sampleNum = 1000;
        private float samplePercent = 0.1f;
        private final Random random = new Random();
        private int sampled;

        public RandomSampler(FetchWork work, JobConf job, Operator<?> operator) throws HiveException {
            super(work, job, operator, null);
        }

        public void setSampleNum(int numSample) {
            this.sampleNum = numSample;
        }

        public void setSamplePercent(float samplePercent) {
            this.samplePercent = samplePercent;
        }

        @Override
        public boolean pushRow() throws IOException, HiveException {
            if (!super.pushRow()) {
                return false;
            }
            if (this.sampled < this.sampleNum) {
                return true;
            }
            this.flushRow();
            return false;
        }

        @Override
        protected void pushRow(InspectableObject row) throws HiveException {
            if (this.random.nextFloat() < this.samplePercent) {
                ++this.sampled;
                super.pushRow(row);
            }
        }
    }
}

