/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.ToUnixTimestamp$;
import org.apache.spark.sql.catalyst.expressions.UnixTime;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timeExp[, format]) - Returns the UNIX timestamp of the given time.", arguments="\n    Arguments:\n      * timeExp - A date/timestamp or string which is returned as a UNIX timestamp.\n      * format - Date/time format pattern to follow. Ignored if `timeExp` is not a string.\n                 Default value is \"yyyy-MM-dd HH:mm:ss\". See `java.text.SimpleDateFormat`\n                 for valid date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-04-08', 'yyyy-MM-dd');\n       1460041200\n  ", since="1.6.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u0001\u0003\u0001>\u0011q\u0002V8V]&DH+[7fgR\fW\u000e\u001d\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\u000b\u001b!\t\t\"#D\u0001\u0003\u0013\t\u0019\"A\u0001\u0005V]&DH+[7f!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u001d\u0001&o\u001c3vGR\u0004\"!F\u000e\n\u0005q1\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\u0010\u0001\u0005+\u0007I\u0011A\u0010\u0002\u000fQLW.Z#yaV\t\u0001\u0005\u0005\u0002\u0012C%\u0011!E\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002\u0003\u0013\u0001\u0005#\u0005\u000b\u0011\u0002\u0011\u0002\u0011QLW.Z#ya\u0002B\u0001B\n\u0001\u0003\u0016\u0004%\taH\u0001\u0007M>\u0014X.\u0019;\t\u0011!\u0002!\u0011#Q\u0001\n\u0001\nqAZ8s[\u0006$\b\u0005\u0003\u0005+\u0001\tU\r\u0011\"\u0001,\u0003)!\u0018.\\3[_:,\u0017\nZ\u000b\u0002YA\u0019Q#L\u0018\n\u000592\"AB(qi&|g\u000e\u0005\u00021g9\u0011Q#M\u0005\u0003eY\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001b6\u0005\u0019\u0019FO]5oO*\u0011!G\u0006\u0005\to\u0001\u0011\t\u0012)A\u0005Y\u0005YA/[7f5>tW-\u00133!\u0011\u0015I\u0004\u0001\"\u0001;\u0003\u0019a\u0014N\\5u}Q!1\bP\u001f?!\t\t\u0002\u0001C\u0003\u001fq\u0001\u0007\u0001\u0005C\u0003'q\u0001\u0007\u0001\u0005C\u0004+qA\u0005\t\u0019\u0001\u0017\t\u000be\u0002A\u0011\u0001!\u0015\u0007m\n%\tC\u0003\u001f\u007f\u0001\u0007\u0001\u0005C\u0003'\u007f\u0001\u0007\u0001\u0005C\u0003E\u0001\u0011\u0005s$\u0001\u0003mK\u001a$\b\"\u0002$\u0001\t\u0003z\u0012!\u0002:jO\"$\b\"\u0002%\u0001\t\u0003J\u0015\u0001D<ji\"$\u0016.\\3[_:,GC\u0001&N!\t\t2*\u0003\u0002M\u0005\t9B+[7f5>tW-Q<be\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006U\u001d\u0003\ra\f\u0005\u0006s\u0001!\ta\u0014\u000b\u0003wACQ!\u0015(A\u0002\u0001\nA\u0001^5nK\")1\u000b\u0001C!)\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003=BqA\u0016\u0001\u0002\u0002\u0013\u0005q+\u0001\u0003d_BLH\u0003B\u001eY3jCqAH+\u0011\u0002\u0003\u0007\u0001\u0005C\u0004'+B\u0005\t\u0019\u0001\u0011\t\u000f)*\u0006\u0013!a\u0001Y!9A\fAI\u0001\n\u0003i\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0002=*\u0012\u0001eX\u0016\u0002AB\u0011\u0011MZ\u0007\u0002E*\u00111\rZ\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u001a\f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002hE\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000f%\u0004\u0011\u0013!C\u0001;\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004bB6\u0001#\u0003%\t\u0001\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\u0005i'F\u0001\u0017`\u0011\u001dy\u0007!!A\u0005BA\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#A9\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018\u0001\u00027b]\u001eT\u0011A^\u0001\u0005U\u00064\u0018-\u0003\u00025g\"9\u0011\u0010AA\u0001\n\u0003Q\u0018\u0001\u00049s_\u0012,8\r^!sSRLX#A>\u0011\u0005Ua\u0018BA?\u0017\u0005\rIe\u000e\u001e\u0005\t\u007f\u0002\t\t\u0011\"\u0001\u0002\u0002\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0002\u0003\u0013\u00012!FA\u0003\u0013\r\t9A\u0006\u0002\u0004\u0003:L\b\u0002CA\u0006}\u0006\u0005\t\u0019A>\u0002\u0007a$\u0013\u0007C\u0005\u0002\u0010\u0001\t\t\u0011\"\u0011\u0002\u0012\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0014A1\u0011QCA\u000e\u0003\u0007i!!a\u0006\u000b\u0007\u0005ea#\u0001\u0006d_2dWm\u0019;j_:LA!!\b\u0002\u0018\tA\u0011\n^3sCR|'\u000fC\u0005\u0002\"\u0001\t\t\u0011\"\u0001\u0002$\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002&\u0005-\u0002cA\u000b\u0002(%\u0019\u0011\u0011\u0006\f\u0003\u000f\t{w\u000e\\3b]\"Q\u00111BA\u0010\u0003\u0003\u0005\r!a\u0001\t\u0013\u0005=\u0002!!A\u0005B\u0005E\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002&\u0005M\u0002BCA\u0006\u0003[\t\t\u00111\u0001\u0002\u0004!\u001a\u0002!a\u000e\u0002>\u0005}\u00121IA#\u0003\u0013\nY%a\u0014\u0002RA\u0019\u0011#!\u000f\n\u0007\u0005m\"AA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\u0005\u0013!S0G+:\u001bu\f\u000b;j[\u0016,\u0005\u0010].-A\u0019|'/\\1u;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004SKT%YAQLW.Z:uC6\u0004\be\u001c4!i\",\u0007eZ5wK:\u0004C/[7f]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003\u000f\n!1\u0016\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AQLW.Z#ya\u0002j\u0003%\u0011\u0011eCR,w\u0006^5nKN$\u0018-\u001c9!_J\u00043\u000f\u001e:j]\u001e\u0004s\u000f[5dQ\u0002J7\u000f\t:fiV\u0014h.\u001a3!CN\u0004\u0013\rI+O\u0013b\u0003C/[7fgR\fW\u000e\u001d\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0019|'/\\1uA5\u0002C)\u0019;f_QLW.\u001a\u0011g_Jl\u0017\r\u001e\u0011qCR$XM\u001d8!i>\u0004cm\u001c7m_^t\u0003%S4o_J,G\rI5gA\u0001$\u0018.\\3FqB\u0004\u0007%[:!]>$\b%\u0019\u0011tiJLgn\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C)\u001a4bk2$\bE^1mk\u0016\u0004\u0013n\u001d\u0011#sfL\u00180L'N[\u0011$\u0007\u0005\u0013%;[6T4o\u001d\u0012/AM+W\r\t1kCZ\fg\u0006^3yi:\u001a\u0016.\u001c9mK\u0012\u000bG/\u001a$pe6\fG\u000f\u0019\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u00012wN\u001d\u0011wC2LG\r\t3bi\u0016\u0004\u0013M\u001c3!i&lW\r\t4pe6\fG\u000f\t9biR,'O\\:/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u00055\u0013A\u0016\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OI\u0002\u0014GN\u00171i5\u0002\u0004h\n\u0017!OeL\u00180_\u0017N\u001b6\"GmJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE\"d\u0007\r\u00195cI\u0002\u0004G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t\u0019&A\u00032]Yr\u0003gB\u0005\u0002X\t\t\t\u0011#\u0001\u0002Z\u0005yAk\\+oSb$\u0016.\\3ti\u0006l\u0007\u000fE\u0002\u0012\u000372\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011QL\n\u0006\u00037\nyF\u0007\t\t\u0003C\n9\u0007\t\u0011-w5\u0011\u00111\r\u0006\u0004\u0003K2\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003S\n\u0019GA\tBEN$(/Y2u\rVt7\r^5p]NBq!OA.\t\u0003\ti\u0007\u0006\u0002\u0002Z!Q\u0011\u0011OA.\u0003\u0003%)%a\u001d\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u001d\u0005\u000b\u0003o\nY&!A\u0005\u0002\u0006e\u0014!B1qa2LHcB\u001e\u0002|\u0005u\u0014q\u0010\u0005\u0007=\u0005U\u0004\u0019\u0001\u0011\t\r\u0019\n)\b1\u0001!\u0011!Q\u0013Q\u000fI\u0001\u0002\u0004a\u0003BCAB\u00037\n\t\u0011\"!\u0002\u0006\u00069QO\\1qa2LH\u0003BAD\u0003\u001f\u0003B!F\u0017\u0002\nB1Q#a#!A1J1!!$\u0017\u0005\u0019!V\u000f\u001d7fg!I\u0011\u0011SAA\u0003\u0003\u0005\raO\u0001\u0004q\u0012\u0002\u0004\"CAK\u00037\n\n\u0011\"\u0001m\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g!I\u0011\u0011TA.#\u0003%\t\u0001\\\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g!Q\u0011QTA.\u0003\u0003%I!a(\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003C\u00032A]AR\u0013\r\t)k\u001d\u0002\u0007\u001f\nTWm\u0019;")
public class ToUnixTimestamp
extends UnixTime
implements Serializable {
    private final Expression timeExp;
    private final Expression format;
    private final Option<String> timeZoneId;

    public static Option<String> apply$default$3() {
        return ToUnixTimestamp$.MODULE$.apply$default$3();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return ToUnixTimestamp$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(ToUnixTimestamp toUnixTimestamp) {
        return ToUnixTimestamp$.MODULE$.unapply(toUnixTimestamp);
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, ToUnixTimestamp> tupled() {
        return ToUnixTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, ToUnixTimestamp>>> curried() {
        return ToUnixTimestamp$.MODULE$.curried();
    }

    public Expression timeExp() {
        return this.timeExp;
    }

    public Expression format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.timeExp();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$14 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$15 = this.copy$default$1();
        Expression x$16 = this.copy$default$2();
        return this.copy(x$15, x$16, (Option<String>)x$14);
    }

    @Override
    public String prettyName() {
        return "to_unix_timestamp";
    }

    public ToUnixTimestamp copy(Expression timeExp, Expression format2, Option<String> timeZoneId) {
        return new ToUnixTimestamp(timeExp, format2, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.timeExp();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "ToUnixTimestamp";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 0: {
                object = this.timeExp();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ToUnixTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ToUnixTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        ToUnixTimestamp toUnixTimestamp = (ToUnixTimestamp)x$1;
        Expression expression = this.timeExp();
        Expression expression2 = toUnixTimestamp.timeExp();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = toUnixTimestamp.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = toUnixTimestamp.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!toUnixTimestamp.canEqual(this)) return false;
        return true;
    }

    public ToUnixTimestamp(Expression timeExp, Expression format2, Option<String> timeZoneId) {
        this.timeExp = timeExp;
        this.format = format2;
        this.timeZoneId = timeZoneId;
    }

    public ToUnixTimestamp(Expression timeExp, Expression format2) {
        this(timeExp, format2, (Option<String>)None$.MODULE$);
    }

    public ToUnixTimestamp(Expression time) {
        this(time, Literal$.MODULE$.apply("yyyy-MM-dd HH:mm:ss"));
    }
}

