/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pyro;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import net.razorvine.pickle.PickleException;
import net.razorvine.pyro.PyroException;
import net.razorvine.pyro.PyroProxy;

public class FlameRemoteConsole {
    private PyroProxy remoteconsole;

    public void __setstate__(HashMap<?, ?> args) throws IOException {
        this.remoteconsole = (PyroProxy)args.get("remoteconsole");
    }

    public void interact() throws PickleException, PyroException, IOException {
        String banner = (String)this.remoteconsole.call("get_banner", new Object[0]);
        System.out.println(banner);
        String ps1 = ">>> ";
        String ps2 = "... ";
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        boolean more = false;
        while (true) {
            if (more) {
                System.out.print(ps2);
            } else {
                System.out.print(ps1);
            }
            System.out.flush();
            String line = br.readLine();
            if (line == null) {
                System.out.println("");
                break;
            }
            try {
                Object[] result = (Object[])this.remoteconsole.call("push_and_get_output", line);
                if (result[0] != null) {
                    System.out.print(result[0]);
                }
                more = (Boolean)result[1];
            }
            catch (IOException x) {
                break;
            }
        }
        System.out.println("(Remote session ended)");
    }

    public void close() throws PickleException, PyroException, IOException {
        if (this.remoteconsole != null) {
            this.remoteconsole.call("terminate", new Object[0]);
            this.remoteconsole.close();
        }
    }

    public void setHmacKey(byte[] hmac) {
        this.remoteconsole.pyroHmacKey = hmac;
    }
}

