/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;

public final class DataSourceUtils$ {
    public static final DataSourceUtils$ MODULE$;
    private final String PARTITIONING_COLUMNS_KEY;
    private final Formats formats;

    static {
        new DataSourceUtils$();
    }

    public void verifyWriteSchema(FileFormat format, StructType schema2) {
        this.verifySchema(format, schema2, false);
    }

    public void verifyReadSchema(FileFormat format, StructType schema2) {
        this.verifySchema(format, schema2, true);
    }

    public String PARTITIONING_COLUMNS_KEY() {
        return this.PARTITIONING_COLUMNS_KEY;
    }

    private Formats formats() {
        return this.formats;
    }

    public String encodePartitioningColumns(Seq<String> columns2) {
        return Serialization$.MODULE$.write(columns2, this.formats());
    }

    public Seq<String> decodePartitioningColumns(String str2) {
        return (Seq)Serialization$.MODULE$.read(str2, this.formats(), ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
    }

    private void verifySchema(FileFormat format, StructType schema2, boolean isReadPath) {
        schema2.foreach((Function1)new Serializable(format, isReadPath){
            public static final long serialVersionUID = 0L;
            private final FileFormat format$1;
            private final boolean isReadPath$1;

            public final void apply(StructField field) {
                if (this.format$1.supportDataType(field.dataType(), this.isReadPath$1)) {
                    return;
                }
                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " data source does not support ", " data type."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.format$1, field.dataType().catalogString()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            {
                this.format$1 = format$1;
                this.isReadPath$1 = isReadPath$1;
            }
        });
    }

    public boolean isDataPath(Path path) {
        String name2 = path.getName();
        return !name2.startsWith("_") && !name2.startsWith(".");
    }

    private DataSourceUtils$() {
        MODULE$ = this;
        this.PARTITIONING_COLUMNS_KEY = "__partition_columns";
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
    }
}

