/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.impl.store.raw.xact.GlobalXactId;
import org.apache.derby.impl.store.raw.xact.TransactionTableEntry;
import org.apache.derby.impl.store.raw.xact.Xact;
import org.apache.derby.impl.store.raw.xact.XactId;

public class TransactionTable
implements Formatable {
    private final ConcurrentHashMap<TransactionId, TransactionTableEntry> trans = new ConcurrentHashMap();
    private TransactionId largestUpdateXactId;

    private TransactionTableEntry findTransactionEntry(TransactionId transactionId) {
        return this.trans.get(transactionId);
    }

    void visitEntries(EntryVisitor entryVisitor) {
        for (TransactionTableEntry transactionTableEntry : this.trans.values()) {
            if (!entryVisitor.visit(transactionTableEntry)) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(Xact xact, boolean bl) {
        TransactionId transactionId = xact.getId();
        TransactionTableEntry transactionTableEntry = new TransactionTableEntry(xact, transactionId, 0, bl ? 4 : 0);
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            TransactionTableEntry transactionTableEntry2 = this.trans.put(transactionId, transactionTableEntry);
        }
    }

    boolean remove(TransactionId transactionId) {
        TransactionTableEntry transactionTableEntry = this.trans.remove(transactionId);
        return transactionTableEntry == null || transactionTableEntry.needExclusion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdateTransaction(TransactionId transactionId, RawTransaction rawTransaction, int n) {
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            TransactionTableEntry transactionTableEntry = this.findTransactionEntry(transactionId);
            if (transactionTableEntry != null) {
                transactionTableEntry.updateTransactionStatus((Xact)rawTransaction, n, 1);
            } else {
                transactionTableEntry = new TransactionTableEntry((Xact)rawTransaction, transactionId, n, 7);
                this.trans.put(transactionId, transactionTableEntry);
            }
            if (XactId.compare(transactionTableEntry.getXid(), this.largestUpdateXactId) > 0L) {
                this.largestUpdateXactId = transactionTableEntry.getXid();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUpdateTransaction(TransactionId transactionId) {
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            TransactionTableEntry transactionTableEntry = this.findTransactionEntry(transactionId);
            transactionTableEntry.removeUpdateTransaction();
            if (transactionTableEntry.isRecovery()) {
                this.remove(transactionId);
            }
        }
    }

    void prepareTransaction(TransactionId transactionId) {
        TransactionTableEntry transactionTableEntry = this.findTransactionEntry(transactionId);
        transactionTableEntry.prepareTransaction();
    }

    public ContextManager findTransactionContextByGlobalId(GlobalXactId globalXactId) {
        for (TransactionTableEntry transactionTableEntry : this.trans.values()) {
            GlobalTransactionId globalTransactionId = transactionTableEntry.getGid();
            if (globalTransactionId == null || !globalTransactionId.equals(globalXactId)) continue;
            return transactionTableEntry.getXact().getContextManager();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasActiveUpdateTransaction() {
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            for (TransactionTableEntry transactionTableEntry : this.trans.values()) {
                if (!transactionTableEntry.isUpdate()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getTypeFormatId() {
        return 262;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            int n = 0;
            for (TransactionTableEntry object : this.trans.values()) {
                if (!object.isUpdate()) continue;
                ++n;
            }
            CompressedNumber.writeInt(objectOutput, n);
            if (n > 0) {
                boolean bl = false;
                for (TransactionTableEntry transactionTableEntry : this.trans.values()) {
                    if (!transactionTableEntry.isUpdate()) continue;
                    objectOutput.writeObject(transactionTableEntry);
                }
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = CompressedNumber.readInt(objectInput);
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            TransactionTableEntry transactionTableEntry = (TransactionTableEntry)objectInput.readObject();
            this.trans.put(transactionTableEntry.getXid(), transactionTableEntry);
            if (!transactionTableEntry.isUpdate() || XactId.compare(transactionTableEntry.getXid(), this.largestUpdateXactId) <= 0L) continue;
            this.largestUpdateXactId = transactionTableEntry.getXid();
        }
    }

    public TransactionId largestUpdateXactId() {
        return this.largestUpdateXactId;
    }

    public boolean hasRollbackFirstTransaction() {
        for (TransactionTableEntry transactionTableEntry : this.trans.values()) {
            if (transactionTableEntry == null || !transactionTableEntry.isRecovery() || (transactionTableEntry.getTransactionStatus() & 0x10) == 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasPreparedRecoveredXact() {
        return this.hasPreparedXact(true);
    }

    public boolean hasPreparedXact() {
        return this.hasPreparedXact(false);
    }

    private boolean hasPreparedXact(boolean bl) {
        for (TransactionTableEntry transactionTableEntry : this.trans.values()) {
            if (transactionTableEntry == null || (transactionTableEntry.getTransactionStatus() & 2) == 0) continue;
            if (bl) {
                if (!transactionTableEntry.isRecovery()) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean getMostRecentRollbackFirstTransaction(RawTransaction rawTransaction) {
        if (this.trans.isEmpty()) {
            return this.findAndAssumeTransaction(null, rawTransaction);
        }
        TransactionId transactionId = null;
        for (TransactionTableEntry transactionTableEntry : this.trans.values()) {
            if (transactionTableEntry == null || !transactionTableEntry.isUpdate() || !transactionTableEntry.isRecovery() || (transactionTableEntry.getTransactionStatus() & 0x10) == 0 || transactionId != null && XactId.compare(transactionId, transactionTableEntry.getXid()) >= 0L) continue;
            transactionId = transactionTableEntry.getXid();
        }
        if (transactionId == null) {
            return this.findAndAssumeTransaction(transactionId, rawTransaction);
        }
        boolean bl = this.findAndAssumeTransaction(transactionId, rawTransaction);
        return true;
    }

    public boolean getMostRecentTransactionForRollback(RawTransaction rawTransaction) {
        TransactionId transactionId = null;
        if (!this.trans.isEmpty()) {
            for (TransactionTableEntry transactionTableEntry : this.trans.values()) {
                if (transactionTableEntry == null || !transactionTableEntry.isUpdate() || !transactionTableEntry.isRecovery() || transactionTableEntry.isPrepared() || transactionId != null && XactId.compare(transactionId, transactionTableEntry.getXid()) >= 0L) continue;
                transactionId = transactionTableEntry.getXid();
            }
        }
        return this.findAndAssumeTransaction(transactionId, rawTransaction);
    }

    public boolean getMostRecentPreparedRecoveredXact(RawTransaction rawTransaction) {
        TransactionTableEntry transactionTableEntry = null;
        if (!this.trans.isEmpty()) {
            TransactionId transactionId = null;
            GlobalTransactionId globalTransactionId = null;
            for (TransactionTableEntry transactionTableEntry2 : this.trans.values()) {
                if (transactionTableEntry2 == null || !transactionTableEntry2.isRecovery() || !transactionTableEntry2.isPrepared() || transactionId != null && XactId.compare(transactionId, transactionTableEntry2.getXid()) >= 0L) continue;
                transactionTableEntry = transactionTableEntry2;
                transactionId = transactionTableEntry2.getXid();
                globalTransactionId = transactionTableEntry2.getGid();
            }
            if (transactionTableEntry != null) {
                TransactionTableEntry transactionTableEntry3 = this.trans.remove(rawTransaction.getId());
                ((Xact)rawTransaction).assumeGlobalXactIdentity(transactionTableEntry);
                transactionTableEntry.unsetRecoveryStatus();
            }
        }
        return transactionTableEntry != null;
    }

    public LogInstant getFirstLogInstant() {
        LogInstant logInstant = null;
        for (TransactionTableEntry transactionTableEntry : this.trans.values()) {
            if (!transactionTableEntry.isUpdate() || logInstant != null && !transactionTableEntry.getFirstLog().lessThan(logInstant)) continue;
            logInstant = transactionTableEntry.getFirstLog();
        }
        return logInstant;
    }

    boolean findAndAssumeTransaction(TransactionId transactionId, RawTransaction rawTransaction) {
        TransactionTableEntry transactionTableEntry = null;
        if (transactionId != null && !this.trans.isEmpty()) {
            transactionTableEntry = this.findTransactionEntry(transactionId);
        }
        ((Xact)rawTransaction).assumeIdentity(transactionTableEntry);
        return transactionTableEntry != null;
    }

    public TransactionInfo[] getTransactionInfo() {
        if (this.trans.isEmpty()) {
            return null;
        }
        ArrayList<TransactionTableEntry> arrayList = new ArrayList<TransactionTableEntry>();
        for (TransactionTableEntry transactionTableEntry : this.trans.values()) {
            arrayList.add((TransactionTableEntry)transactionTableEntry.clone());
        }
        return arrayList.toArray(new TransactionTableEntry[arrayList.size()]);
    }

    public String toString() {
        return null;
    }

    static interface EntryVisitor {
        public boolean visit(TransactionTableEntry var1);
    }
}

