/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spark;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.spark.DataFrameCallback;
import org.apache.camel.component.spark.EndpointType;
import org.apache.camel.component.spark.RddCallback;
import org.apache.camel.component.spark.SparkEndpoint;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import org.apache.spark.api.java.JavaRDDLike;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class SparkEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        SparkEndpoint target = (SparkEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)SparkEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "collect": {
                target.setCollect((Boolean)SparkEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "dataframe": 
            case "dataFrame": {
                target.setDataFrame((Dataset<Row>)((Dataset)SparkEndpointConfigurer.property((CamelContext)camelContext, Dataset.class, (Object)value)));
                return true;
            }
            case "dataframecallback": 
            case "dataFrameCallback": {
                target.setDataFrameCallback((DataFrameCallback)SparkEndpointConfigurer.property((CamelContext)camelContext, DataFrameCallback.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)SparkEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "rdd": {
                target.setRdd((JavaRDDLike)SparkEndpointConfigurer.property((CamelContext)camelContext, JavaRDDLike.class, (Object)value));
                return true;
            }
            case "rddcallback": 
            case "rddCallback": {
                target.setRddCallback((RddCallback)SparkEndpointConfigurer.property((CamelContext)camelContext, RddCallback.class, (Object)value));
                return true;
            }
            case "synchronous": {
                target.setSynchronous((Boolean)SparkEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        SparkEndpoint target = (SparkEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "collect": {
                return target.isCollect();
            }
            case "dataframe": 
            case "dataFrame": {
                return target.getDataFrame();
            }
            case "dataframecallback": 
            case "dataFrameCallback": {
                return target.getDataFrameCallback();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "rdd": {
                return target.getRdd();
            }
            case "rddcallback": 
            case "rddCallback": {
                return target.getRddCallback();
            }
            case "synchronous": {
                return target.isSynchronous();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("endpointType", EndpointType.class);
        map.put("collect", Boolean.TYPE);
        map.put("dataFrame", Dataset.class);
        map.put("dataFrameCallback", DataFrameCallback.class);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("rdd", JavaRDDLike.class);
        map.put("rddCallback", RddCallback.class);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("synchronous", Boolean.TYPE);
        ALL_OPTIONS = map;
    }
}

