/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlExplain
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("EXPLAIN", SqlKind.EXPLAIN){

        @Override
        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlExplain(pos, operands[0], (SqlLiteral)operands[1], (SqlLiteral)operands[2], (SqlLiteral)operands[3], 0);
        }
    };
    SqlNode explicandum;
    SqlLiteral detailLevel;
    SqlLiteral depth;
    SqlLiteral asXml;
    private final int dynamicParameterCount;

    public SqlExplain(SqlParserPos pos, SqlNode explicandum, SqlLiteral detailLevel, SqlLiteral depth, SqlLiteral asXml, int dynamicParameterCount) {
        super(pos);
        this.explicandum = explicandum;
        this.detailLevel = detailLevel;
        this.depth = depth;
        this.asXml = asXml;
        this.dynamicParameterCount = dynamicParameterCount;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.EXPLAIN;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.explicandum, this.detailLevel, this.depth, this.asXml);
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.explicandum = operand;
                break;
            }
            case 1: {
                this.detailLevel = (SqlLiteral)operand;
                break;
            }
            case 2: {
                this.depth = (SqlLiteral)operand;
                break;
            }
            case 3: {
                this.asXml = (SqlLiteral)operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public SqlNode getExplicandum() {
        return this.explicandum;
    }

    public SqlExplainLevel getDetailLevel() {
        return (SqlExplainLevel)this.detailLevel.symbolValue();
    }

    public Depth getDepth() {
        return (Depth)this.depth.symbolValue();
    }

    public int getDynamicParamCount() {
        return this.dynamicParameterCount;
    }

    public boolean withImplementation() {
        return this.getDepth() == Depth.PHYSICAL;
    }

    public boolean withType() {
        return this.getDepth() == Depth.TYPE;
    }

    public boolean isXml() {
        return this.asXml.booleanValue();
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("EXPLAIN PLAN");
        switch (this.getDetailLevel()) {
            case NO_ATTRIBUTES: {
                writer.keyword("EXCLUDING ATTRIBUTES");
                break;
            }
            case EXPPLAN_ATTRIBUTES: {
                writer.keyword("INCLUDING ATTRIBUTES");
                break;
            }
            case ALL_ATTRIBUTES: {
                writer.keyword("INCLUDING ALL ATTRIBUTES");
            }
        }
        switch (this.getDepth()) {
            case TYPE: {
                writer.keyword("WITH TYPE");
                break;
            }
            case LOGICAL: {
                writer.keyword("WITHOUT IMPLEMENTATION");
                break;
            }
            case PHYSICAL: {
                writer.keyword("WITH IMPLEMENTATION");
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (this.isXml()) {
            writer.keyword("AS XML");
        }
        writer.keyword("FOR");
        writer.newlineAndIndent();
        this.explicandum.unparse(writer, this.getOperator().getLeftPrec(), this.getOperator().getRightPrec());
    }

    public static enum Depth implements SqlLiteral.SqlSymbol
    {
        TYPE,
        LOGICAL,
        PHYSICAL;


        public SqlLiteral symbol(SqlParserPos pos) {
            return SqlLiteral.createSymbol(this, pos);
        }
    }
}

