/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;

public class AuthorizationFactory {
    public static <T> T create(final Object delegated, Class<T> itface, final AuthorizationExceptionHandler handler) {
        InvocationHandler invocation = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                this.invokeAuth(method, args);
                return null;
            }

            private void invokeAuth(Method method, Object[] args) throws Throwable {
                block2: {
                    try {
                        method.invoke(delegated, args);
                    }
                    catch (InvocationTargetException e) {
                        if (!(e.getTargetException() instanceof AuthorizationException) && !(e.getTargetException() instanceof HiveAuthzPluginException) && !(e.getTargetException() instanceof HiveAccessControlException)) break block2;
                        handler.exception((Exception)e.getTargetException());
                    }
                }
            }
        };
        return (T)Proxy.newProxyInstance(AuthorizationFactory.class.getClassLoader(), new Class[]{itface}, invocation);
    }

    public static class DefaultAuthorizationExceptionHandler
    implements AuthorizationExceptionHandler {
        @Override
        public void exception(Exception exception) throws AuthorizationException, HiveAuthzPluginException, HiveAccessControlException {
            if (exception instanceof AuthorizationException) {
                throw (AuthorizationException)exception;
            }
            if (exception instanceof HiveAuthzPluginException) {
                throw (HiveAuthzPluginException)exception;
            }
            if (exception instanceof HiveAccessControlException) {
                throw (HiveAccessControlException)exception;
            }
            throw new RuntimeException(exception);
        }
    }

    public static interface AuthorizationExceptionHandler {
        public void exception(Exception var1) throws AuthorizationException, HiveAuthzPluginException, HiveAccessControlException;
    }
}

