/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.calcite.util.Util;
import org.eigenbase.util.property.BooleanProperty;
import org.eigenbase.util.property.StringProperty;

public class SaffronProperties
extends Properties {
    private static SaffronProperties properties;
    public final BooleanProperty allowInfiniteCostConverters = new BooleanProperty((Properties)this, "saffron.opt.allowInfiniteCostConverters", true);
    public final StringProperty defaultCharset = new StringProperty((Properties)this, "saffron.default.charset", "ISO-8859-1");
    public final StringProperty defaultNationalCharset = new StringProperty((Properties)this, "saffron.default.nationalcharset", "ISO-8859-1");
    public final StringProperty defaultCollation = new StringProperty((Properties)this, "saffron.default.collation.name", "ISO-8859-1$en_US");
    public final StringProperty defaultCollationStrength = new StringProperty((Properties)this, "saffron.default.collation.strength", "primary");

    private SaffronProperties() {
    }

    public static SaffronProperties instance() {
        if (properties == null) {
            block5: {
                properties = new SaffronProperties();
                File file = new File("saffron.properties");
                try {
                    if (!file.exists()) break block5;
                    try {
                        properties.load(new FileInputStream(file));
                    }
                    catch (IOException e) {
                        throw Util.newInternal(e, "while reading from " + file);
                    }
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
            }
            properties.loadSaffronProperties(System.getProperties());
        }
        return properties;
    }

    public void loadSaffronProperties(Properties source) {
        Enumeration<Object> keys = source.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = source.getProperty(key);
            if (!key.startsWith("saffron.") && !key.startsWith("net.sf.saffron.")) continue;
            properties.setProperty(key, value);
        }
    }

    public boolean getBooleanProperty(String key) {
        return this.getBooleanProperty(key, false);
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value.equalsIgnoreCase("1") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
    }

    public int getIntProperty(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            return -1;
        }
        int i = Integer.valueOf(value);
        return i;
    }
}

