/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayPosition$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array, element) - Returns the (1-based) index of the first element of the array as long.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(3, 2, 1), 1);\n       3\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001B\u0001\u0003\u0001>\u0011Q\"\u0011:sCf\u0004vn]5uS>t'BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001BcF\u000f\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\tR#\u0003\u0002\u0017\u0005\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012DA\u0004Qe>$Wo\u0019;\u0011\u0005aq\u0012BA\u0010\u001a\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\t\u0003A!f\u0001\n\u0003\u0011\u0013\u0001\u00027fMR,\u0012a\t\t\u0003#\u0011J!!\n\u0002\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0005(\u0001\tE\t\u0015!\u0003$\u0003\u0015aWM\u001a;!\u0011!I\u0003A!f\u0001\n\u0003\u0011\u0013!\u0002:jO\"$\b\u0002C\u0016\u0001\u0005#\u0005\u000b\u0011B\u0012\u0002\rILw\r\u001b;!\u0011\u0015i\u0003\u0001\"\u0001/\u0003\u0019a\u0014N\\5u}Q\u0019q\u0006M\u0019\u0011\u0005E\u0001\u0001\"B\u0011-\u0001\u0004\u0019\u0003\"B\u0015-\u0001\u0004\u0019\u0003\u0002C\u001a\u0001\u0011\u000b\u0007I\u0011\u0002\u001b\u0002\u0011=\u0014H-\u001a:j]\u001e,\u0012!\u000e\t\u0004my\neBA\u001c=\u001d\tA4(D\u0001:\u0015\tQd\"\u0001\u0004=e>|GOP\u0005\u00025%\u0011Q(G\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0004I\u0001\u0005Pe\u0012,'/\u001b8h\u0015\ti\u0014\u0004\u0005\u0002\u0019\u0005&\u00111)\u0007\u0002\u0004\u0003:L\b\u0002C#\u0001\u0011\u0003\u0005\u000b\u0015B\u001b\u0002\u0013=\u0014H-\u001a:j]\u001e\u0004\u0003F\u0001#H!\tA\u0002*\u0003\u0002J3\tIAO]1og&,g\u000e\u001e\u0005\u0006\u0017\u0002!\t\u0005T\u0001\tI\u0006$\u0018\rV=qKV\tQ\n\u0005\u0002O#6\tqJ\u0003\u0002Q\r\u0005)A/\u001f9fg&\u0011!k\u0014\u0002\t\t\u0006$\u0018\rV=qK\")A\u000b\u0001C!+\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003Y\u00032AN,Z\u0013\tA\u0006IA\u0002TKF\u0004\"A\u0014.\n\u0005m{%\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u0015i\u0006\u0001\"\u0011_\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\u0005y\u0006C\u00011d\u001b\u0005\t'B\u00012\u0005\u0003!\tg.\u00197zg&\u001c\u0018B\u00013b\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\b\"\u00024\u0001\t\u0003:\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGcA!iU\")\u0011.\u001aa\u0001\u0003\u0006\u0019\u0011M\u001d:\t\u000b-,\u0007\u0019A!\u0002\u000bY\fG.^3\t\u000b5\u0004A\u0011\t8\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001p!\t\u00018O\u0004\u0002\u0019c&\u0011!/G\u0001\u0007!J,G-\u001a4\n\u0005Q,(AB*ue&twM\u0003\u0002s3!)q\u000f\u0001C!q\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0005s~\fI\u0001\u0005\u0002{{6\t1P\u0003\u0002}\u0005\u000591m\u001c3fO\u0016t\u0017B\u0001@|\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\u0001m\u0002\u0007\u00111A\u0001\u0004GRD\bc\u0001>\u0002\u0006%\u0019\u0011qA>\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"1\u00111\u0002<A\u0002e\f!!\u001a<\t\u0013\u0005=\u0001!!A\u0005\u0002\u0005E\u0011\u0001B2paf$RaLA\n\u0003+A\u0001\"IA\u0007!\u0003\u0005\ra\t\u0005\tS\u00055\u0001\u0013!a\u0001G!I\u0011\u0011\u0004\u0001\u0012\u0002\u0013\u0005\u00111D\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiBK\u0002$\u0003?Y#!!\t\u0011\t\u0005\r\u0012QF\u0007\u0003\u0003KQA!a\n\u0002*\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003WI\u0012AC1o]>$\u0018\r^5p]&!\u0011qFA\u0013\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003g\u0001\u0011\u0013!C\u0001\u00037\tabY8qs\u0012\"WMZ1vYR$#\u0007C\u0005\u00028\u0001\t\t\u0011\"\u0011\u0002:\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u000f\u0011\t\u0005u\u0012qI\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005!A.\u00198h\u0015\t\t)%\u0001\u0003kCZ\f\u0017b\u0001;\u0002@!I\u00111\n\u0001\u0002\u0002\u0013\u0005\u0011QJ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u001f\u00022\u0001GA)\u0013\r\t\u0019&\u0007\u0002\u0004\u0013:$\b\"CA,\u0001\u0005\u0005I\u0011AA-\u00039\u0001(o\u001c3vGR,E.Z7f]R$2!QA.\u0011)\ti&!\u0016\u0002\u0002\u0003\u0007\u0011qJ\u0001\u0004q\u0012\n\u0004\"CA1\u0001\u0005\u0005I\u0011IA2\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA3!\u0015\t9'!\u001cB\u001b\t\tIGC\u0002\u0002le\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty'!\u001b\u0003\u0011%#XM]1u_JD\u0011\"a\u001d\u0001\u0003\u0003%\t!!\u001e\u0002\u0011\r\fg.R9vC2$B!a\u001e\u0002~A\u0019\u0001$!\u001f\n\u0007\u0005m\u0014DA\u0004C_>dW-\u00198\t\u0013\u0005u\u0013\u0011OA\u0001\u0002\u0004\t\u0005\"CAA\u0001\u0005\u0005I\u0011IAB\u0003\u0019)\u0017/^1mgR!\u0011qOAC\u0011%\ti&a \u0002\u0002\u0003\u0007\u0011\tK\b\u0001\u0003\u0013\u000by)!%\u0002\u0016\u0006]\u00151TAO!\r\t\u00121R\u0005\u0004\u0003\u001b\u0013!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003'\u000bqM\u0003\u0011!A\u0001zf)\u0016(D?\"\n'O]1zY\u0001*G.Z7f]RL\u0003%\f\u0011SKR,(O\\:!i\",\u0007\u0005K\u0019.E\u0006\u001cX\rZ\u0015!S:$W\r\u001f\u0011pM\u0002\"\b.\u001a\u0011gSJ\u001cH\u000fI3mK6,g\u000e\u001e\u0011pM\u0002\"\b.\u001a\u0011beJ\f\u0017\u0010I1tA1|gn\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u00033\u000bAI\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u001a-AIb\u0003%M\u0015-AEJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a\u000bA\u0001\nQa]5oG\u0016\f#!a(\u0002\u000bIrCG\f\u0019\b\u0013\u0005\r&!!A\t\u0002\u0005\u0015\u0016!D!se\u0006L\bk\\:ji&|g\u000eE\u0002\u0012\u0003O3\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011\u0011V\n\u0006\u0003O\u000bY+\b\t\b\u0003[\u000b\u0019lI\u00120\u001b\t\tyKC\u0002\u00022f\tqA];oi&lW-\u0003\u0003\u00026\u0006=&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9Q&a*\u0005\u0002\u0005eFCAAS\u0011)\ti,a*\u0002\u0002\u0013\u0015\u0013qX\u0001\ti>\u001cFO]5oOR\u0011\u00111\b\u0005\u000b\u0003\u0007\f9+!A\u0005\u0002\u0006\u0015\u0017!B1qa2LH#B\u0018\u0002H\u0006%\u0007BB\u0011\u0002B\u0002\u00071\u0005\u0003\u0004*\u0003\u0003\u0004\ra\t\u0005\u000b\u0003\u001b\f9+!A\u0005\u0002\u0006=\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0003#\fi\u000eE\u0003\u0019\u0003'\f9.C\u0002\u0002Vf\u0011aa\u00149uS>t\u0007#\u0002\r\u0002Z\u000e\u001a\u0013bAAn3\t1A+\u001e9mKJB\u0011\"a8\u0002L\u0006\u0005\t\u0019A\u0018\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002d\u0006\u001d\u0016\u0011!C\u0005\u0003K\f1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u001d\t\u0005\u0003{\tI/\u0003\u0003\u0002l\u0006}\"AB(cU\u0016\u001cG\u000f")
public class ArrayPosition
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression left;
    private final Expression right;
    private transient Ordering<Object> org$apache$spark$sql$catalyst$expressions$ArrayPosition$$ordering;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayPosition arrayPosition) {
        return ArrayPosition$.MODULE$.unapply(arrayPosition);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayPosition> tupled() {
        return ArrayPosition$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayPosition>> curried() {
        return ArrayPosition$.MODULE$.curried();
    }

    private Ordering org$apache$spark$sql$catalyst$expressions$ArrayPosition$$ordering$lzycompute() {
        ArrayPosition arrayPosition = this;
        synchronized (arrayPosition) {
            if (!this.bitmap$trans$0) {
                this.org$apache$spark$sql$catalyst$expressions$ArrayPosition$$ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.right().dataType());
                this.bitmap$trans$0 = true;
            }
            return this.org$apache$spark$sql$catalyst$expressions$ArrayPosition$$ordering;
        }
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    public Ordering<Object> org$apache$spark$sql$catalyst$expressions$ArrayPosition$$ordering() {
        return this.bitmap$trans$0 ? this.org$apache$spark$sql$catalyst$expressions$ArrayPosition$$ordering : this.org$apache$spark$sql$catalyst$expressions$ArrayPosition$$ordering$lzycompute();
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Seq seq;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 == null) return (Seq)Seq$.MODULE$.empty();
        DataType dataType2 = (DataType)tuple2._1();
        DataType e2 = (DataType)tuple2._2();
        if (!(dataType2 instanceof ArrayType)) return (Seq)Seq$.MODULE$.empty();
        ArrayType arrayType2 = (ArrayType)dataType2;
        DataType e1 = arrayType2.elementType();
        boolean hasNull = arrayType2.containsNull();
        Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e2);
        if (option instanceof Some) {
            Some some = (Some)option;
            DataType dt = (DataType)some.x();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{new ArrayType(dt, hasNull), dt}));
            return seq;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        ArrayType arrayType2;
        DataType e1;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 == null) return new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input to function ", " should have "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"been ", " followed by a value with same element type, but it's "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ArrayType$.MODULE$.simpleString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", ", ", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.left().dataType().catalogString(), this.right().dataType().catalogString()}))).toString());
        DataType dataType2 = (DataType)tuple2._1();
        DataType e2 = (DataType)tuple2._2();
        if (!(dataType2 instanceof ArrayType) || !(e1 = (arrayType2 = (ArrayType)dataType2).elementType()).sameType(e2)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input to function ", " should have "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"been ", " followed by a value with same element type, but it's "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ArrayType$.MODULE$.simpleString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", ", ", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.left().dataType().catalogString(), this.right().dataType().catalogString()}))).toString());
        return TypeUtils$.MODULE$.checkForOrderingExpr(e2, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"function ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName()})));
    }

    @Override
    public Object nullSafeEval(Object arr, Object value2) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Object object;
            Object object2 = new Object();
            try {
                ((ArrayData)arr).foreach(this.right().dataType(), (Function2<Object, Object, BoxedUnit>)new Serializable(this, value2, object2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ArrayPosition $outer;
                    private final Object value$2;
                    private final Object nonLocalReturnKey4$1;

                    public final void apply(int i, Object v) {
                        if (v != null && this.$outer.org$apache$spark$sql$catalyst$expressions$ArrayPosition$$ordering().equiv(v, this.value$2)) {
                            throw new NonLocalReturnControl.mcJ.sp(this.nonLocalReturnKey4$1, (long)(i + 1));
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.value$2 = value$2;
                        this.nonLocalReturnKey4$1 = nonLocalReturnKey4$1;
                    }
                });
                object = BoxesRunTime.boxToLong((long)0L);
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object2) break block2;
                object = nonLocalReturnControl2.value();
            }
            return object;
        }
        throw nonLocalReturnControl2;
    }

    @Override
    public String prettyName() {
        return "array_position";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ctx, ev){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayPosition $outer;
            private final CodegenContext ctx$11;
            private final ExprCode ev$11;

            public final String apply(String arr, String value2) {
                String pos = this.ctx$11.freshName("arrayPosition");
                String i = this.ctx$11.freshName("i");
                String getValue = CodeGenerator$.MODULE$.getValue(arr, this.$outer.right().dataType(), i);
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |int ", " = 0;\n         |for (int ", " = 0; ", " < ", ".numElements(); ", " ++) {\n         |  if (!", ".isNullAt(", ") && ", ") {\n         |    ", " = ", " + 1;\n         |    break;\n         |  }\n         |}\n         |", " = (long) ", ";\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pos, i, i, arr, i, arr, i, this.ctx$11.genEqual(this.$outer.right().dataType(), value2, getValue), pos, i, this.ev$11.value(), pos})))).stripMargin();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ctx$11 = ctx$11;
                this.ev$11 = ev$11;
            }
        });
    }

    public ArrayPosition copy(Expression left, Expression right) {
        return new ArrayPosition(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayPosition";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayPosition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayPosition)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayPosition arrayPosition = (ArrayPosition)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayPosition.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayPosition.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayPosition.canEqual(this)) return false;
        return true;
    }

    public ArrayPosition(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes$class.$init$(this);
    }
}

