/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.TimeZone;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression$class;
import org.apache.spark.sql.catalyst.expressions.TruncInstant;
import org.apache.spark.sql.catalyst.expressions.TruncInstant$class;
import org.apache.spark.sql.catalyst.expressions.TruncTimestamp$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(fmt, ts) - Returns timestamp `ts` truncated to the unit specified by the format model `fmt`.\n    `fmt` should be one of [\"YEAR\", \"YYYY\", \"YY\", \"MON\", \"MONTH\", \"MM\", \"DAY\", \"DD\", \"HOUR\", \"MINUTE\", \"SECOND\", \"WEEK\", \"QUARTER\"]\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('YEAR', '2015-03-05T09:32:05.359');\n       2015-01-01 00:00:00\n      > SELECT _FUNC_('MM', '2015-03-05T09:32:05.359');\n       2015-03-01 00:00:00\n      > SELECT _FUNC_('DD', '2015-03-05T09:32:05.359');\n       2015-03-05 00:00:00\n      > SELECT _FUNC_('HOUR', '2015-03-05T09:32:05.359');\n       2015-03-05 09:00:00\n  ", since="2.3.0")
@ScalaSignature(bytes="\u0006\u0001\t=a\u0001B\u0001\u0003\u0001>\u0011a\u0002\u0016:v]\u000e$\u0016.\\3ti\u0006l\u0007O\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0019\u0001\u0001\u0003F\f\u001bAA\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"!E\u000b\n\u0005Y\u0011!\u0001\u0004+sk:\u001c\u0017J\\:uC:$\bCA\t\u0019\u0013\tI\"AA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]B\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t9\u0001K]8ek\u000e$\bCA\u000e\"\u0013\t\u0011CD\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005%\u0001\tU\r\u0011\"\u0001&\u0003\u00191wN]7biV\ta\u0005\u0005\u0002\u0012O%\u0011\u0001F\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002\u0003\u0016\u0001\u0005#\u0005\u000b\u0011\u0002\u0014\u0002\u000f\u0019|'/\\1uA!AA\u0006\u0001BK\u0002\u0013\u0005Q%A\u0005uS6,7\u000f^1na\"Aa\u0006\u0001B\tB\u0003%a%\u0001\u0006uS6,7\u000f^1na\u0002B\u0001\u0002\r\u0001\u0003\u0016\u0004%\t!M\u0001\u000bi&lWMW8oK&#W#\u0001\u001a\u0011\u0007m\u0019T'\u0003\u000259\t1q\n\u001d;j_:\u0004\"AN\u001d\u000f\u0005m9\u0014B\u0001\u001d\u001d\u0003\u0019\u0001&/\u001a3fM&\u0011!h\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005ab\u0002\u0002C\u001f\u0001\u0005#\u0005\u000b\u0011\u0002\u001a\u0002\u0017QLW.\u001a.p]\u0016LE\r\t\u0005\u0006\u007f\u0001!\t\u0001Q\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0005\u00135\t\u0012\t\u0003#\u0001AQ\u0001\n A\u0002\u0019BQ\u0001\f A\u0002\u0019Bq\u0001\r \u0011\u0002\u0003\u0007!\u0007C\u0003G\u0001\u0011\u0005S%\u0001\u0003mK\u001a$\b\"\u0002%\u0001\t\u0003*\u0013!\u0002:jO\"$\b\"\u0002&\u0001\t\u0003Z\u0015AC5oaV$H+\u001f9fgV\tA\nE\u0002N+bs!AT*\u000f\u0005=\u0013V\"\u0001)\u000b\u0005Es\u0011A\u0002\u001fs_>$h(C\u0001\u001e\u0013\t!F$A\u0004qC\u000e\\\u0017mZ3\n\u0005Y;&aA*fc*\u0011A\u000b\b\t\u00033rk\u0011A\u0017\u0006\u00037\u001a\tQ\u0001^=qKNL!!\u0018.\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0007\"B0\u0001\t\u0003\u0002\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003\u0005\u0004\"!\u00172\n\u0005\rT&!\u0004+j[\u0016\u001cH/Y7q)f\u0004X\rC\u0003f\u0001\u0011\u0005c-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012!\u000e\u0005\bQ\u0002\u0011\r\u0011\"\u0011&\u0003\u001dIgn\u001d;b]RDaA\u001b\u0001!\u0002\u00131\u0013\u0001C5ogR\fg\u000e\u001e\u0011\t\u000b1\u0004A\u0011I7\u0002\u0019]LG\u000f\u001b+j[\u0016TvN\\3\u0015\u0005]q\u0007\"\u0002\u0019l\u0001\u0004)\u0004\"B \u0001\t\u0003\u0001HcA!re\")Ae\u001ca\u0001M!)Af\u001ca\u0001M!)A\u000f\u0001C!k\u0006!QM^1m)\t1\u0018\u0010\u0005\u0002\u001co&\u0011\u0001\u0010\b\u0002\u0004\u0003:L\bb\u0002>t!\u0003\u0005\ra_\u0001\u0006S:\u0004X\u000f\u001e\t\u0003yvl\u0011\u0001B\u0005\u0003}\u0012\u00111\"\u00138uKJt\u0017\r\u001c*po\"9\u0011\u0011\u0001\u0001\u0005B\u0005\r\u0011!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t)!!\u0005\u0002\u001cA!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\f\t\tqaY8eK\u001e,g.\u0003\u0003\u0002\u0010\u0005%!\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005Mq\u00101\u0001\u0002\u0016\u0005\u00191\r\u001e=\u0011\t\u0005\u001d\u0011qC\u0005\u0005\u00033\tIA\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005uq\u00101\u0001\u0002\u0006\u0005\u0011QM\u001e\u0005\n\u0003C\u0001\u0011\u0011!C\u0001\u0003G\tAaY8qsR9\u0011)!\n\u0002(\u0005%\u0002\u0002\u0003\u0013\u0002 A\u0005\t\u0019\u0001\u0014\t\u00111\ny\u0002%AA\u0002\u0019B\u0001\u0002MA\u0010!\u0003\u0005\rA\r\u0005\n\u0003[\u0001\u0011\u0013!C\u0001\u0003_\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00022)\u001aa%a\r,\u0005\u0005U\u0002\u0003BA\u001c\u0003\u0003j!!!\u000f\u000b\t\u0005m\u0012QH\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0010\u001d\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0007\nIDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a\u0012\u0001#\u0003%\t!a\f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u00111\n\u0001\u0012\u0002\u0013\u0005\u0011QJ\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tyEK\u00023\u0003gA\u0011\"a\u0015\u0001\u0003\u0003%\t%!\u0016\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\u0006\u0005\u0003\u0002Z\u0005\rTBAA.\u0015\u0011\ti&a\u0018\u0002\t1\fgn\u001a\u0006\u0003\u0003C\nAA[1wC&\u0019!(a\u0017\t\u0013\u0005\u001d\u0004!!A\u0005\u0002\u0005%\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAA6!\rY\u0012QN\u0005\u0004\u0003_b\"aA%oi\"I\u00111\u000f\u0001\u0002\u0002\u0013\u0005\u0011QO\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r1\u0018q\u000f\u0005\u000b\u0003s\n\t(!AA\u0002\u0005-\u0014a\u0001=%c!I\u0011Q\u0010\u0001\u0002\u0002\u0013\u0005\u0013qP\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u0011\t\u0006\u0003\u0007\u000bII^\u0007\u0003\u0003\u000bS1!a\"\u001d\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0017\u000b)I\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\ty\tAA\u0001\n\u0003\t\t*\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019*!'\u0011\u0007m\t)*C\u0002\u0002\u0018r\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002z\u00055\u0015\u0011!a\u0001m\"I\u0011Q\u0014\u0001\u0002\u0002\u0013\u0005\u0013qT\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005M\u0015\u0011\u0015\u0005\n\u0003s\nY*!AA\u0002YDs\u0002AAS\u0003W\u000bi+!-\u00024\u0006]\u0016\u0011\u0018\t\u0004#\u0005\u001d\u0016bAAU\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAX\u0003\u0005}'\u0002\t\u0011!A}3UKT\"`Q\u0019lG\u000f\f\u0011ug&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uS6,7\u000f^1na\u0002\u0002Go\u001d1!iJ,hnY1uK\u0012\u0004Co\u001c\u0011uQ\u0016\u0004SO\\5uAM\u0004XmY5gS\u0016$\u0007EY=!i\",\u0007EZ8s[\u0006$\b%\\8eK2\u0004\u0003MZ7uA:R\u0001\u0005\t\u0011!A\u001alG\u000f\u0019\u0011tQ>,H\u000e\u001a\u0011cK\u0002zg.\u001a\u0011pM\u0002Z&%W#B%\nb\u0003EI-Z3f\u0013C\u0006\t\u0012Z3\nb\u0003EI'P\u001d\nb\u0003EI'P\u001dRC%\u0005\f\u0011#\u001b6\u0013C\u0006\t\u0012E\u0003f\u0013C\u0006\t\u0012E\t\nb\u0003E\t%P+J\u0013C\u0006\t\u0012N\u0013:+F+\u0012\u0012-A\t\u001aViQ(O\t\nb\u0003EI,F\u000b.\u0013C\u0006\t\u0012R+\u0006\u0013F+\u0012*#;*\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t),\u0001Bb\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013,R!SO1\u0002sE\r\u00192k5\u00024'\f\u00196)BJ$h\r\u001a;aUr3'N\u001d(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00196[A\nT\u0006M\u0019!aAR\u0004\u0007\r\u001e1a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%T'(Y\u0001:#\u0007M\u00196[A\u001aT\u0006M\u001bUaeR4G\r\u001e1k9\u001aT'O\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'M\u001b.aMj\u0003'\r\u00111ai\u0002\u0004G\u000f\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":C\tR\u0014-A\u001d\u0012\u0004'M\u001b.aMj\u0003'\u000e+1si\u001a$G\u000f\u00196]M*\u0014hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014'N\u00171g5\u0002T\u0007\t\u00191uA\u0002$\b\r\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dBu*\u0016*(Y\u0001:#\u0007M\u00196[A\u001aT\u0006M\u001bUaeR4G\r\u001e1k9\u001aT'O\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'M\u001b.aMj\u0003'\u000e\u00111si\u0002\u0004G\u000f\u00191\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAA^\u0003\u0015\u0011df\r\u00181\u000f%\tyLAA\u0001\u0012\u0003\t\t-\u0001\bUeVt7\rV5nKN$\u0018-\u001c9\u0011\u0007E\t\u0019M\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAc'\u0015\t\u0019-a2!!!\tI-a4'MI\nUBAAf\u0015\r\ti\rH\u0001\beVtG/[7f\u0013\u0011\t\t.a3\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007C\u0004@\u0003\u0007$\t!!6\u0015\u0005\u0005\u0005\u0007BCAm\u0003\u0007\f\t\u0011\"\u0012\u0002\\\u0006AAo\\*ue&tw\r\u0006\u0002\u0002X!Q\u0011q\\Ab\u0003\u0003%\t)!9\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f\u0005\u000b\u0019/!:\u0002h\"1A%!8A\u0002\u0019Ba\u0001LAo\u0001\u00041\u0003\u0002\u0003\u0019\u0002^B\u0005\t\u0019\u0001\u001a\t\u0015\u0005-\u00181YA\u0001\n\u0003\u000bi/A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005=\u0018q\u001f\t\u00057M\n\t\u0010\u0005\u0004\u001c\u0003g4cEM\u0005\u0004\u0003kd\"A\u0002+va2,7\u0007C\u0005\u0002z\u0006%\u0018\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010\n\u0019\t\u0015\u0005u\u00181YI\u0001\n\u0003\ti%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$He\r\u0005\u000b\u0005\u0003\t\u0019-%A\u0005\u0002\u00055\u0013aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\t\u0015\t\u0015\u00111YA\u0001\n\u0013\u00119!A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0005!\u0011\tIFa\u0003\n\t\t5\u00111\f\u0002\u0007\u001f\nTWm\u0019;")
public class TruncTimestamp
extends BinaryExpression
implements TruncInstant,
TimeZoneAwareExpression,
Serializable {
    private final Expression format;
    private final Expression timestamp;
    private final Option<String> timeZoneId;
    private final Expression instant;
    private final boolean resolved;
    private final transient TimeZone timeZone;
    private final int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> apply$default$3() {
        return TruncTimestamp$.MODULE$.apply$default$3();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return TruncTimestamp$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(TruncTimestamp truncTimestamp) {
        return TruncTimestamp$.MODULE$.unapply(truncTimestamp);
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, TruncTimestamp> tupled() {
        return TruncTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, TruncTimestamp>>> curried() {
        return TruncTimestamp$.MODULE$.curried();
    }

    private boolean resolved$lzycompute() {
        TruncTimestamp truncTimestamp = this;
        synchronized (truncTimestamp) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = TimeZoneAwareExpression$class.resolved(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.resolved;
        }
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        TruncTimestamp truncTimestamp = this;
        synchronized (truncTimestamp) {
            if (!this.bitmap$trans$0) {
                this.timeZone = TimeZoneAwareExpression$class.timeZone(this);
                this.bitmap$trans$0 = true;
            }
            return this.timeZone;
        }
    }

    @Override
    public TimeZone timeZone() {
        return this.bitmap$trans$0 ? this.timeZone : this.timeZone$lzycompute();
    }

    private int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute() {
        TruncTimestamp truncTimestamp = this;
        synchronized (truncTimestamp) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel = TruncInstant$class.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
        }
    }

    @Override
    public int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    }

    @Override
    public boolean nullable() {
        return TruncInstant$class.nullable(this);
    }

    @Override
    public Object evalHelper(InternalRow input, int maxLevel, Function2<Object, Object, Object> truncFunc) {
        return TruncInstant$class.evalHelper(this, input, maxLevel, truncFunc);
    }

    @Override
    public ExprCode codeGenHelper(CodegenContext ctx, ExprCode ev, int maxLevel, boolean orderReversed, Function2<String, String, String> truncFunc) {
        return TruncInstant$class.codeGenHelper(this, ctx, ev, maxLevel, orderReversed, truncFunc);
    }

    @Override
    public boolean codeGenHelper$default$4() {
        return TruncInstant$class.codeGenHelper$default$4(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    @Override
    public Expression format() {
        return this.format;
    }

    public Expression timestamp() {
        return this.timestamp;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.format();
    }

    @Override
    public Expression right() {
        return this.timestamp();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, TimestampType$.MODULE$}));
    }

    @Override
    public TimestampType dataType() {
        return TimestampType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "date_trunc";
    }

    @Override
    public Expression instant() {
        return this.instant;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$35 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$36 = this.copy$default$1();
        Expression x$37 = this.copy$default$2();
        return this.copy(x$36, x$37, (Option<String>)x$35);
    }

    @Override
    public Object eval(InternalRow input) {
        return this.evalHelper(input, DateTimeUtils$.MODULE$.TRUNC_TO_SECOND(), (Function2<Object, Object, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TruncTimestamp $outer;

            public final long apply(Object t, int level) {
                return DateTimeUtils$.MODULE$.truncTimestamp(BoxesRunTime.unboxToLong((Object)t), level, this.$outer.timeZone());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String tz = ctx.addReferenceObj("timeZone", this.timeZone(), ctx.addReferenceObj$default$3());
        return this.codeGenHelper(ctx, ev, DateTimeUtils$.MODULE$.TRUNC_TO_SECOND(), true, (Function2<String, String, String>)new Serializable(this, tz){
            public static final long serialVersionUID = 0L;
            private final String tz$10;

            public final String apply(String date, String fmt) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"truncTimestamp(", ", ", ", ", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{date, fmt, this.tz$10}));
            }
            {
                this.tz$10 = tz$10;
            }
        });
    }

    public TruncTimestamp copy(Expression format2, Expression timestamp, Option<String> timeZoneId) {
        return new TruncTimestamp(format2, timestamp, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.format();
    }

    public Expression copy$default$2() {
        return this.timestamp();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "TruncTimestamp";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            case 1: {
                object = this.timestamp();
                break;
            }
            case 0: {
                object = this.format();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TruncTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TruncTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        TruncTimestamp truncTimestamp = (TruncTimestamp)x$1;
        Expression expression = this.format();
        Expression expression2 = truncTimestamp.format();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.timestamp();
        Expression expression4 = truncTimestamp.timestamp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = truncTimestamp.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!truncTimestamp.canEqual(this)) return false;
        return true;
    }

    public TruncTimestamp(Expression format2, Expression timestamp, Option<String> timeZoneId) {
        this.format = format2;
        this.timestamp = timestamp;
        this.timeZoneId = timeZoneId;
        ExpectsInputTypes$class.$init$(this);
        TruncInstant$class.$init$(this);
        TimeZoneAwareExpression$class.$init$(this);
        this.instant = timestamp;
    }

    public TruncTimestamp(Expression format2, Expression timestamp) {
        this(format2, timestamp, (Option<String>)None$.MODULE$);
    }
}

