/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.calcite.avatica.remote.JsonService;

public class RemoteService
extends JsonService {
    private final URL url;

    public RemoteService(URL url) {
        this.url = url;
    }

    @Override
    public String apply(String request) {
        try {
            int count;
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("request", request);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new RuntimeException("response code " + responseCode);
            }
            InputStream inputStream = connection.getInputStream();
            byte[] bytes = new byte[4096];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((count = inputStream.read(bytes, 0, bytes.length)) >= 0) {
                baos.write(bytes, 0, count);
            }
            return baos.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

