/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.SparkEdgeProperty;

@Explain(displayName="Spark")
public class SparkWork
extends AbstractOperatorDesc {
    private static int counter;
    private final String name;
    private final Set<BaseWork> roots = new LinkedHashSet<BaseWork>();
    private final Set<BaseWork> leaves = new LinkedHashSet<BaseWork>();
    protected final Map<BaseWork, List<BaseWork>> workGraph = new HashMap<BaseWork, List<BaseWork>>();
    protected final Map<BaseWork, List<BaseWork>> invertedWorkGraph = new HashMap<BaseWork, List<BaseWork>>();
    protected final Map<Pair<BaseWork, BaseWork>, SparkEdgeProperty> edgeProperties = new HashMap<Pair<BaseWork, BaseWork>, SparkEdgeProperty>();
    private Map<String, List<String>> requiredCounterPrefix;
    private Map<BaseWork, BaseWork> cloneToWork;

    public SparkWork(String name) {
        this.name = name + ":" + ++counter;
        this.cloneToWork = new HashMap<BaseWork, BaseWork>();
    }

    @Explain(displayName="DagName")
    public String getName() {
        return this.name;
    }

    @Explain(displayName="Vertices")
    public Map<String, BaseWork> getWorkMap() {
        LinkedHashMap<String, BaseWork> result = new LinkedHashMap<String, BaseWork>();
        for (BaseWork w : this.getAllWork()) {
            result.put(w.getName(), w);
        }
        return result;
    }

    public List<BaseWork> getAllWork() {
        LinkedList<BaseWork> result = new LinkedList<BaseWork>();
        HashSet<BaseWork> seen = new HashSet<BaseWork>();
        for (BaseWork leaf : this.leaves) {
            this.visit(leaf, seen, result);
        }
        return result;
    }

    public Collection<BaseWork> getAllWorkUnsorted() {
        return this.workGraph.keySet();
    }

    private void visit(BaseWork child, Set<BaseWork> seen, List<BaseWork> result) {
        if (seen.contains(child)) {
            return;
        }
        seen.add(child);
        for (BaseWork parent : this.getParents(child)) {
            if (seen.contains(parent)) continue;
            this.visit(parent, seen, result);
        }
        result.add(child);
    }

    public void addAll(Collection<BaseWork> c) {
        for (BaseWork w : c) {
            this.add(w);
        }
    }

    public void addAll(BaseWork[] bws) {
        for (BaseWork w : bws) {
            this.add(w);
        }
    }

    public boolean contains(BaseWork w) {
        return this.workGraph.containsKey(w);
    }

    public void add(BaseWork w) {
        if (this.workGraph.containsKey(w)) {
            return;
        }
        this.workGraph.put(w, new LinkedList());
        this.invertedWorkGraph.put(w, new LinkedList());
        this.roots.add(w);
        this.leaves.add(w);
    }

    public void disconnect(BaseWork a, BaseWork b) {
        this.workGraph.get(a).remove(b);
        this.invertedWorkGraph.get(b).remove(a);
        if (this.getParents(b).isEmpty()) {
            this.roots.add(b);
        }
        if (this.getChildren(a).isEmpty()) {
            this.leaves.add(a);
        }
        this.edgeProperties.remove(new ImmutablePair((Object)a, (Object)b));
    }

    public Set<BaseWork> getRoots() {
        return new LinkedHashSet<BaseWork>(this.roots);
    }

    public Set<BaseWork> getLeaves() {
        return new LinkedHashSet<BaseWork>(this.leaves);
    }

    public void setRequiredCounterPrefix(Map<String, List<String>> requiredCounterPrefix) {
        this.requiredCounterPrefix = requiredCounterPrefix;
    }

    public Map<String, List<String>> getRequiredCounterPrefix() {
        return this.requiredCounterPrefix;
    }

    public List<BaseWork> getParents(BaseWork work) {
        Preconditions.checkArgument((boolean)this.invertedWorkGraph.containsKey(work), (Object)"AssertionError: expected invertedWorkGraph.containsKey(work) to be true");
        Preconditions.checkArgument((this.invertedWorkGraph.get(work) != null ? 1 : 0) != 0, (Object)"AssertionError: expected invertedWorkGraph.get(work) to be not null");
        return new LinkedList<BaseWork>((Collection)this.invertedWorkGraph.get(work));
    }

    public List<BaseWork> getChildren(BaseWork work) {
        Preconditions.checkArgument((boolean)this.workGraph.containsKey(work), (Object)"AssertionError: expected workGraph.containsKey(work) to be true");
        Preconditions.checkArgument((this.workGraph.get(work) != null ? 1 : 0) != 0, (Object)"AssertionError: expected workGraph.get(work) to be not null");
        return new LinkedList<BaseWork>((Collection)this.workGraph.get(work));
    }

    public void remove(BaseWork work) {
        if (!this.workGraph.containsKey(work)) {
            return;
        }
        List<BaseWork> children = this.getChildren(work);
        List<BaseWork> parents = this.getParents(work);
        for (BaseWork w : children) {
            this.edgeProperties.remove(new ImmutablePair((Object)work, (Object)w));
            this.invertedWorkGraph.get(w).remove(work);
            if (this.invertedWorkGraph.get(w).size() != 0) continue;
            this.roots.add(w);
        }
        for (BaseWork w : parents) {
            this.edgeProperties.remove(new ImmutablePair((Object)w, (Object)work));
            this.workGraph.get(w).remove(work);
            if (this.workGraph.get(w).size() != 0) continue;
            this.leaves.add(w);
        }
        this.roots.remove(work);
        this.leaves.remove(work);
        this.workGraph.remove(work);
        this.invertedWorkGraph.remove(work);
    }

    public SparkEdgeProperty getEdgeProperty(BaseWork a, BaseWork b) {
        return this.edgeProperties.get(new ImmutablePair((Object)a, (Object)b));
    }

    public void connect(BaseWork a, BaseWork b, SparkEdgeProperty edgeProp) {
        this.workGraph.get(a).add(b);
        this.invertedWorkGraph.get(b).add(a);
        this.roots.remove(b);
        this.leaves.remove(a);
        ImmutablePair workPair = new ImmutablePair((Object)a, (Object)b);
        this.edgeProperties.put((Pair<BaseWork, BaseWork>)workPair, edgeProp);
    }

    @Explain(displayName="Edges")
    public Map<ComparableName, List<Dependency>> getDependencyMap() {
        HashMap<String, String> allDependencies = new HashMap<String, String>();
        LinkedHashMap<ComparableName, List<Dependency>> result = new LinkedHashMap<ComparableName, List<Dependency>>();
        for (BaseWork baseWork : this.getAllWork()) {
            if (this.invertedWorkGraph.get(baseWork) == null || this.invertedWorkGraph.get(baseWork).size() <= 0) continue;
            LinkedList<Dependency> dependencies = new LinkedList<Dependency>();
            for (BaseWork d : this.invertedWorkGraph.get(baseWork)) {
                allDependencies.put(baseWork.getName(), d.getName());
                Dependency dependency = new Dependency();
                dependency.w = d;
                dependency.prop = this.getEdgeProperty(d, baseWork);
                dependencies.add(dependency);
            }
            if (dependencies.isEmpty()) continue;
            Collections.sort(dependencies);
            result.put(new ComparableName(allDependencies, baseWork.getName()), dependencies);
        }
        return result;
    }

    public List<ReduceWork> getAllReduceWork() {
        ArrayList<ReduceWork> result = new ArrayList<ReduceWork>();
        for (BaseWork work : this.getAllWork()) {
            if (!(work instanceof ReduceWork)) continue;
            result.add((ReduceWork)work);
        }
        return result;
    }

    public Map<BaseWork, BaseWork> getCloneToWork() {
        return this.cloneToWork;
    }

    public void setCloneToWork(Map<BaseWork, BaseWork> cloneToWork) {
        this.cloneToWork = cloneToWork;
    }

    private static class ComparableName
    implements Comparable<ComparableName> {
        private final Map<String, String> dependencies;
        private final String name;

        ComparableName(Map<String, String> dependencies, String name) {
            this.dependencies = dependencies;
            this.name = name;
        }

        boolean dependsOn(String n1, String n2) {
            String p = this.dependencies.get(n1);
            while (p != null) {
                if (p.equals(n2)) {
                    return true;
                }
                p = this.dependencies.get(p);
            }
            return false;
        }

        int getDepth(String n) {
            int depth = 0;
            String p = this.dependencies.get(n);
            while (p != null) {
                ++depth;
                p = this.dependencies.get(p);
            }
            return depth;
        }

        @Override
        public int compareTo(ComparableName o) {
            int d2;
            if (this.dependsOn(this.name, o.name)) {
                return 1;
            }
            if (this.dependsOn(o.name, this.name)) {
                return -1;
            }
            int d1 = this.getDepth(this.name);
            if (d1 == (d2 = this.getDepth(o.name))) {
                return this.name.compareTo(o.name);
            }
            return d1 > d2 ? 1 : -1;
        }

        public String toString() {
            return this.name;
        }
    }

    public class Dependency
    implements Serializable,
    Comparable<Dependency> {
        public BaseWork w;
        public SparkEdgeProperty prop;

        @Explain(displayName="Name")
        public String getName() {
            return this.w.getName();
        }

        @Explain(displayName="Shuffle Type")
        public String getShuffleType() {
            return this.prop.getShuffleType();
        }

        @Explain(displayName="Number of Partitions")
        public String getNumPartitions() {
            return Integer.toString(this.prop.getNumPartitions());
        }

        @Override
        public int compareTo(Dependency o) {
            int compare = this.getName().compareTo(o.getName());
            if (compare == 0) {
                compare = this.getShuffleType().compareTo(o.getShuffleType());
            }
            return compare;
        }
    }
}

