/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.correlation;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;

abstract class AbstractCorrelationProcCtx
implements NodeProcessorCtx {
    private ParseContext pctx;
    private final boolean trustScript;
    private final int minReducer;
    private final Set<Operator<?>> removedOps = new HashSet();

    public AbstractCorrelationProcCtx(ParseContext pctx) {
        this.trustScript = pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVESCRIPTOPERATORTRUST);
        this.minReducer = pctx.getConf().getIntVar(HiveConf.ConfVars.HIVEOPTREDUCEDEDUPLICATIONMINREDUCER);
        this.pctx = pctx;
    }

    public ParseContext getPctx() {
        return this.pctx;
    }

    public void setPctx(ParseContext pctx) {
        this.pctx = pctx;
    }

    public boolean trustScript() {
        return this.trustScript;
    }

    public int minReducer() {
        return this.minReducer;
    }

    public boolean hasBeenRemoved(Operator<?> rsOp) {
        return this.removedOps.contains(rsOp);
    }

    public boolean addRemovedOperator(Operator<?> rsOp) {
        return this.removedOps.add(rsOp);
    }
}

