/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.TimeZone;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MonthsBetween$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression$class;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(timestamp1, timestamp2[, roundOff]) - If `timestamp1` is later than `timestamp2`, then the result\n      is positive. If `timestamp1` and `timestamp2` are on the same day of month, or both\n      are the last day of month, time of day will be ignored. Otherwise, the difference is\n      calculated based on 31 days per month, and rounded to 8 digits unless roundOff=false.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('1997-02-28 10:30:00', '1996-10-30');\n       3.94959677\n      > SELECT _FUNC_('1997-02-28 10:30:00', '1996-10-30', false);\n       3.9495967741935485\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t\u0005b\u0001B\u0001\u0003\u0001>\u0011Q\"T8oi\"\u001c()\u001a;xK\u0016t'BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001\u0001Bc\u0006\u000e!!\t\t\"#D\u0001\u0003\u0013\t\u0019\"AA\tUKJt\u0017M]=FqB\u0014Xm]:j_:\u0004\"!E\u000b\n\u0005Y\u0011!a\u0006+j[\u0016TvN\\3Bo\u0006\u0014X-\u0012=qe\u0016\u001c8/[8o!\t\t\u0002$\u0003\u0002\u001a\u0005\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBDA\u0004Qe>$Wo\u0019;\u0011\u0005m\t\u0013B\u0001\u0012\u001d\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!!\u0003A!f\u0001\n\u0003)\u0013!\u00023bi\u0016\fT#\u0001\u0014\u0011\u0005E9\u0013B\u0001\u0015\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tU\u0001\u0011\t\u0012)A\u0005M\u00051A-\u0019;fc\u0001B\u0001\u0002\f\u0001\u0003\u0016\u0004%\t!J\u0001\u0006I\u0006$XM\r\u0005\t]\u0001\u0011\t\u0012)A\u0005M\u00051A-\u0019;fe\u0001B\u0001\u0002\r\u0001\u0003\u0016\u0004%\t!J\u0001\te>,h\u000eZ(gM\"A!\u0007\u0001B\tB\u0003%a%A\u0005s_VtGm\u00144gA!AA\u0007\u0001BK\u0002\u0013\u0005Q'\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012A\u000e\t\u00047]J\u0014B\u0001\u001d\u001d\u0005\u0019y\u0005\u000f^5p]B\u0011!(\u0010\b\u00037mJ!\u0001\u0010\u000f\u0002\rA\u0013X\rZ3g\u0013\tqtH\u0001\u0004TiJLgn\u001a\u0006\u0003yqA\u0001\"\u0011\u0001\u0003\u0012\u0003\u0006IAN\u0001\fi&lWMW8oK&#\u0007\u0005C\u0003D\u0001\u0011\u0005A)\u0001\u0004=S:LGO\u0010\u000b\u0006\u000b\u001a;\u0005*\u0013\t\u0003#\u0001AQ\u0001\n\"A\u0002\u0019BQ\u0001\f\"A\u0002\u0019BQ\u0001\r\"A\u0002\u0019Bq\u0001\u000e\"\u0011\u0002\u0003\u0007a\u0007C\u0003D\u0001\u0011\u00051\nF\u0002F\u00196CQ\u0001\n&A\u0002\u0019BQ\u0001\f&A\u0002\u0019BQa\u0011\u0001\u0005\u0002=#B!\u0012)R%\")AE\u0014a\u0001M!)AF\u0014a\u0001M!)\u0001G\u0014a\u0001M!)A\u000b\u0001C!+\u0006A1\r[5mIJ,g.F\u0001W!\r9vL\n\b\u00031vs!!\u0017/\u000e\u0003iS!a\u0017\b\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0012B\u00010\u001d\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Y1\u0003\u0007M+\u0017O\u0003\u0002_9!)1\r\u0001C!I\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003\u0015\u00042aV0g!\t9'.D\u0001i\u0015\tIg!A\u0003usB,7/\u0003\u0002lQ\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/\u001a\u0005\u0006[\u0002!\tE\\\u0001\tI\u0006$\u0018\rV=qKV\tq\u000e\u0005\u0002ha&\u0011\u0011\u000f\u001b\u0002\t\t\u0006$\u0018\rV=qK\")1\u000f\u0001C!i\u0006aq/\u001b;i)&lWMW8oKR\u0011A#\u001e\u0005\u0006iI\u0004\r!\u000f\u0005\u0006o\u0002!\t\u0005_\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0006srt\u0018\u0011\u0001\t\u00037iL!a\u001f\u000f\u0003\u0007\u0005s\u0017\u0010C\u0003~m\u0002\u0007\u00110\u0001\u0002uc!)qP\u001ea\u0001s\u0006\u0011AO\r\u0005\u0006aY\u0004\r!\u001f\u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002\n\u0005U\u0011q\u0004\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011q\u0002\u0002\u0002\u000f\r|G-Z4f]&!\u00111CA\u0007\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\u0002CA\f\u0003\u0007\u0001\r!!\u0007\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\f\u0005m\u0011\u0002BA\u000f\u0003\u001b\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0005\u0002\"\u0005\r\u0001\u0019AA\u0005\u0003\t)g\u000fC\u0004\u0002&\u0001!\t%a\n\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001:\u0011%\tY\u0003AA\u0001\n\u0003\ti#\u0001\u0003d_BLH#C#\u00020\u0005E\u00121GA\u001b\u0011!!\u0013\u0011\u0006I\u0001\u0002\u00041\u0003\u0002\u0003\u0017\u0002*A\u0005\t\u0019\u0001\u0014\t\u0011A\nI\u0003%AA\u0002\u0019B\u0001\u0002NA\u0015!\u0003\u0005\rA\u000e\u0005\n\u0003s\u0001\u0011\u0013!C\u0001\u0003w\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002>)\u001aa%a\u0010,\u0005\u0005\u0005\u0003\u0003BA\"\u0003\u001bj!!!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0013\u001d\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001f\n)EA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a\u0015\u0001#\u0003%\t!a\u000f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u0011q\u000b\u0001\u0012\u0002\u0013\u0005\u00111H\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011%\tY\u0006AI\u0001\n\u0003\ti&\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005}#f\u0001\u001c\u0002@!I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0013QM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u001d\u0004\u0003BA5\u0003gj!!a\u001b\u000b\t\u00055\u0014qN\u0001\u0005Y\u0006twM\u0003\u0002\u0002r\u0005!!.\u0019<b\u0013\rq\u00141\u000e\u0005\n\u0003o\u0002\u0011\u0011!C\u0001\u0003s\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u001f\u0011\u0007m\ti(C\u0002\u0002\u0000q\u00111!\u00138u\u0011%\t\u0019\tAA\u0001\n\u0003\t))\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007e\f9\t\u0003\u0006\u0002\n\u0006\u0005\u0015\u0011!a\u0001\u0003w\n1\u0001\u001f\u00132\u0011%\ti\tAA\u0001\n\u0003\ny)A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\nE\u0003\u0002\u0014\u0006e\u00150\u0004\u0002\u0002\u0016*\u0019\u0011q\u0013\u000f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001c\u0006U%\u0001C%uKJ\fGo\u001c:\t\u0013\u0005}\u0005!!A\u0005\u0002\u0005\u0005\u0016\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\r\u0016\u0011\u0016\t\u00047\u0005\u0015\u0016bAAT9\t9!i\\8mK\u0006t\u0007\"CAE\u0003;\u000b\t\u00111\u0001z\u0011%\ti\u000bAA\u0001\n\u0003\ny+\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003G\u000b\t\fC\u0005\u0002\n\u0006-\u0016\u0011!a\u0001s\"z\u0001!!.\u0002<\u0006u\u0016\u0011YAb\u0003\u000f\fI\rE\u0002\u0012\u0003oK1!!/\u0003\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a0\u0002\u0007\u0007Q\u0001\u0005\t\u0011!?\u001a+fjQ0)i&lWm\u001d;b[B\fD\u0006\t;j[\u0016\u001cH/Y7qemc\u0003E]8v]\u0012|eMZ/*A5\u0002\u0013J\u001a\u0011ai&lWm\u001d;b[B\f\u0004\rI5tA1\fG/\u001a:!i\"\fg\u000e\t1uS6,7\u000f^1naJ\u0002G\u0006\t;iK:\u0004C\u000f[3!e\u0016\u001cX\u000f\u001c;\u000bA\u0001\u0002\u0003\u0005\t\u0011jg\u0002\u0002xn]5uSZ,g\u0006I%gA\u0001$\u0018.\\3ti\u0006l\u0007/\r1!C:$\u0007\u0005\u0019;j[\u0016\u001cH/Y7qe\u0001\u0004\u0013M]3!_:\u0004C\u000f[3!g\u0006lW\r\t3bs\u0002zg\rI7p]RDG\u0006I8sA\t|G\u000f\u001b\u0006!A\u0001\u0002\u0003\u0005I1sK\u0002\"\b.\u001a\u0011mCN$\b\u0005Z1zA=4\u0007%\\8oi\"d\u0003\u0005^5nK\u0002zg\r\t3bs\u0002:\u0018\u000e\u001c7!E\u0016\u0004\u0013n\u001a8pe\u0016$g\u0006I(uQ\u0016\u0014x/[:fY\u0001\"\b.\u001a\u0011eS\u001a4WM]3oG\u0016\u0004\u0013n\u001d\u0006!A\u0001\u0002\u0003\u0005I2bY\u000e,H.\u0019;fI\u0002\u0012\u0017m]3eA=t\u0007eM\u0019!I\u0006L8\u000f\t9fe\u0002jwN\u001c;iY\u0001\ng\u000e\u001a\u0011s_VtG-\u001a3!i>\u0004\u0003\b\t3jO&$8\u000fI;oY\u0016\u001c8\u000f\t:pk:$wJ\u001a4>M\u0006d7/\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u000b\f\u0011\u0011\u0010\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OEJ\u0014hN\u00171e5\u0012\u0004\bI\u00191uM\u0002$\b\r\u0019(Y\u0001:\u0013'O\u001d7[E\u0002Tf\r\u0019(SmR\u0001\u0005\t\u0011!A\u0001\u00023GL\u001d5sUJdgN\u001c\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n\u0014(O\u001c.aIj#\u0007\u000f\u00112ai\u001a\u0004G\u000f\u00191O1\u0002s%M\u001d:m5\n\u0004'L\u001a1O1\u0002c-\u00197tK&Z$\u0002\t\u0011!A\u0001\u0002\u0003e\r\u0018:ie*\u0014HN\u001c8iEJ4'\u000e\u001b9k)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002L\u0006)\u0011GL\u001b/a\u001dI\u0011q\u001a\u0002\u0002\u0002#\u0005\u0011\u0011[\u0001\u000e\u001b>tG\u000f[:CKR<X-\u001a8\u0011\u0007E\t\u0019N\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAk'\u0015\t\u0019.a6!!%\tI.a8'M\u00192T)\u0004\u0002\u0002\\*\u0019\u0011Q\u001c\u000f\u0002\u000fI,h\u000e^5nK&!\u0011\u0011]An\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\u0005\b\u0007\u0006MG\u0011AAs)\t\t\t\u000e\u0003\u0006\u0002j\u0006M\u0017\u0011!C#\u0003W\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003OB!\"a<\u0002T\u0006\u0005I\u0011QAy\u0003\u0015\t\u0007\u000f\u001d7z)%)\u00151_A{\u0003o\fI\u0010\u0003\u0004%\u0003[\u0004\rA\n\u0005\u0007Y\u00055\b\u0019\u0001\u0014\t\rA\ni\u000f1\u0001'\u0011!!\u0014Q\u001eI\u0001\u0002\u00041\u0004BCA\u007f\u0003'\f\t\u0011\"!\u0002\u0000\u00069QO\\1qa2LH\u0003\u0002B\u0001\u0005\u0013\u0001BaG\u001c\u0003\u0004A91D!\u0002'M\u00192\u0014b\u0001B\u00049\t1A+\u001e9mKRB\u0011Ba\u0003\u0002|\u0006\u0005\t\u0019A#\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003\u0010\u0005M\u0017\u0013!C\u0001\u0003;\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0004B\u0003B\n\u0003'\f\n\u0011\"\u0001\u0002^\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C\u0007\u0003\u0006\u0003\u0018\u0005M\u0017\u0011!C\u0005\u00053\t1B]3bIJ+7o\u001c7wKR\u0011!1\u0004\t\u0005\u0003S\u0012i\"\u0003\u0003\u0003 \u0005-$AB(cU\u0016\u001cG\u000f")
public class MonthsBetween
extends TernaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
Serializable {
    private final Expression date1;
    private final Expression date2;
    private final Expression roundOff;
    private final Option<String> timeZoneId;
    private final boolean resolved;
    private final transient TimeZone timeZone;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> apply$default$4() {
        return MonthsBetween$.MODULE$.apply$default$4();
    }

    public static Option<String> $lessinit$greater$default$4() {
        return MonthsBetween$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Expression, Expression, Expression, Option<String>>> unapply(MonthsBetween monthsBetween) {
        return MonthsBetween$.MODULE$.unapply(monthsBetween);
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Option<String>>, MonthsBetween> tupled() {
        return MonthsBetween$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Option<String>, MonthsBetween>>>> curried() {
        return MonthsBetween$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    private boolean resolved$lzycompute() {
        MonthsBetween monthsBetween = this;
        synchronized (monthsBetween) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression$class.resolved(this);
                this.bitmap$0 = true;
            }
            return this.resolved;
        }
    }

    @Override
    public boolean resolved() {
        return this.bitmap$0 ? this.resolved : this.resolved$lzycompute();
    }

    private TimeZone timeZone$lzycompute() {
        MonthsBetween monthsBetween = this;
        synchronized (monthsBetween) {
            if (!this.bitmap$trans$0) {
                this.timeZone = TimeZoneAwareExpression$class.timeZone(this);
                this.bitmap$trans$0 = true;
            }
            return this.timeZone;
        }
    }

    @Override
    public TimeZone timeZone() {
        return this.bitmap$trans$0 ? this.timeZone : this.timeZone$lzycompute();
    }

    public Expression date1() {
        return this.date1;
    }

    public Expression date2() {
        return this.date2;
    }

    public Expression roundOff() {
        return this.roundOff;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.date1(), this.date2(), this.roundOff()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{TimestampType$.MODULE$, TimestampType$.MODULE$, BooleanType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$31 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$32 = this.copy$default$1();
        Expression x$33 = this.copy$default$2();
        Expression x$34 = this.copy$default$3();
        return this.copy(x$32, x$33, x$34, (Option<String>)x$31);
    }

    @Override
    public Object nullSafeEval(Object t1, Object t2, Object roundOff) {
        return BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(BoxesRunTime.unboxToLong((Object)t1), BoxesRunTime.unboxToLong((Object)t2), BoxesRunTime.unboxToBoolean((Object)roundOff), this.timeZone()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String tz = ctx.addReferenceObj("timeZone", this.timeZone(), ctx.addReferenceObj$default$3());
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)new Serializable(this, tz, dtu){
            public static final long serialVersionUID = 0L;
            private final String tz$9;
            private final String dtu$21;

            public final String apply(String d1, String d2, String roundOff) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".monthsBetween(", ", ", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dtu$21, d1, d2, roundOff, this.tz$9}));
            }
            {
                this.tz$9 = tz$9;
                this.dtu$21 = dtu$21;
            }
        });
    }

    @Override
    public String prettyName() {
        return "months_between";
    }

    public MonthsBetween copy(Expression date1, Expression date2, Expression roundOff, Option<String> timeZoneId) {
        return new MonthsBetween(date1, date2, roundOff, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.date1();
    }

    public Expression copy$default$2() {
        return this.date2();
    }

    public Expression copy$default$3() {
        return this.roundOff();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "MonthsBetween";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            case 2: {
                object = this.roundOff();
                break;
            }
            case 1: {
                object = this.date2();
                break;
            }
            case 0: {
                object = this.date1();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MonthsBetween;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MonthsBetween)) return false;
        boolean bl = true;
        if (!bl) return false;
        MonthsBetween monthsBetween = (MonthsBetween)x$1;
        Expression expression = this.date1();
        Expression expression2 = monthsBetween.date1();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.date2();
        Expression expression4 = monthsBetween.date2();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.roundOff();
        Expression expression6 = monthsBetween.roundOff();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = monthsBetween.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!monthsBetween.canEqual(this)) return false;
        return true;
    }

    public MonthsBetween(Expression date1, Expression date2, Expression roundOff, Option<String> timeZoneId) {
        this.date1 = date1;
        this.date2 = date2;
        this.roundOff = roundOff;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression$class.$init$(this);
        ExpectsInputTypes$class.$init$(this);
    }

    public MonthsBetween(Expression date1, Expression date2) {
        this(date1, date2, Literal$.MODULE$.TrueLiteral(), (Option<String>)None$.MODULE$);
    }

    public MonthsBetween(Expression date1, Expression date2, Expression roundOff) {
        this(date1, date2, roundOff, (Option<String>)None$.MODULE$);
    }
}

