/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;

public class AggregateProjectMergeRule
extends RelOptRule {
    public static final AggregateProjectMergeRule INSTANCE = new AggregateProjectMergeRule();

    private AggregateProjectMergeRule() {
        super(AggregateProjectMergeRule.operand(Aggregate.class, AggregateProjectMergeRule.operand(Project.class, AggregateProjectMergeRule.any()), new RelOptRuleOperand[0]));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project;
        Aggregate aggregate = (Aggregate)call.rel(0);
        RelNode x = AggregateProjectMergeRule.apply(aggregate, project = (Project)call.rel(1));
        if (x != null) {
            call.transformTo(x);
        }
    }

    public static RelNode apply(Aggregate aggregate, Project project) {
        Aggregate newAggregate;
        ArrayList newKeys = Lists.newArrayList();
        for (int key : aggregate.getGroupSet()) {
            RexNode rex = project.getProjects().get(key);
            if (rex instanceof RexInputRef) {
                newKeys.add(((RexInputRef)rex).getIndex());
                continue;
            }
            return null;
        }
        ImmutableBitSet newGroupSet = ImmutableBitSet.of(newKeys);
        ImmutableList newGroupingSets = null;
        if (aggregate.indicator) {
            ImmutableList.Builder newGroupingSetsBuilder = ImmutableList.builder();
            for (ImmutableBitSet groupingSet : aggregate.getGroupSets()) {
                ImmutableBitSet.Builder newGroupingSet = ImmutableBitSet.builder();
                for (int c : groupingSet) {
                    newGroupingSet.set((Integer)newKeys.get(c));
                }
                newGroupingSetsBuilder.add((Object)newGroupingSet.build());
            }
            newGroupingSets = newGroupingSetsBuilder.build();
        }
        ImmutableList.Builder aggCalls = ImmutableList.builder();
        for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
            ImmutableList.Builder newArgs = ImmutableList.builder();
            for (int arg : aggregateCall.getArgList()) {
                RexNode rex = project.getProjects().get(arg);
                if (rex instanceof RexInputRef) {
                    newArgs.add((Object)((RexInputRef)rex).getIndex());
                    continue;
                }
                return null;
            }
            aggCalls.add((Object)aggregateCall.copy((List<Integer>)newArgs.build()));
        }
        RelNode rel = newAggregate = aggregate.copy(aggregate.getTraitSet(), project.getInput(), aggregate.indicator, newGroupSet, (List<ImmutableBitSet>)newGroupingSets, (List<AggregateCall>)aggCalls.build());
        if (!newGroupSet.toList().equals(newKeys)) {
            ArrayList posList = Lists.newArrayList();
            for (int newKey : newKeys) {
                posList.add(newGroupSet.indexOf(newKey));
            }
            if (aggregate.indicator) {
                for (int newKey : newKeys) {
                    posList.add(aggregate.getGroupCount() + newGroupSet.indexOf(newKey));
                }
            }
            for (int i = newAggregate.getGroupCount() + newAggregate.getIndicatorCount(); i < newAggregate.getRowType().getFieldCount(); ++i) {
                posList.add(i);
            }
            rel = RelOptUtil.createProject(RelFactories.DEFAULT_PROJECT_FACTORY, rel, posList);
        }
        return rel;
    }
}

