/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedTableMacro;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;

public class ProcedureNamespace
extends AbstractNamespace {
    private final SqlValidatorScope scope;
    private final SqlCall call;

    ProcedureNamespace(SqlValidatorImpl validator, SqlValidatorScope scope, SqlCall call, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.scope = scope;
        this.call = call;
    }

    @Override
    public RelDataType validateImpl() {
        this.validator.inferUnknownTypes(this.validator.unknownType, this.scope, this.call);
        RelDataType type = this.validator.deriveTypeImpl(this.scope, this.call);
        SqlOperator operator = this.call.getOperator();
        if (operator instanceof SqlUserDefinedTableFunction) {
            assert (type.getSqlTypeName() == SqlTypeName.CURSOR) : "User-defined table function should have CURSOR type, not " + type;
            SqlUserDefinedTableFunction udf = (SqlUserDefinedTableFunction)operator;
            return udf.getRowType(this.validator.typeFactory, this.call.getOperandList());
        }
        if (operator instanceof SqlUserDefinedTableMacro) {
            assert (type.getSqlTypeName() == SqlTypeName.CURSOR) : "User-defined table macro should have CURSOR type, not " + type;
            SqlUserDefinedTableMacro udf = (SqlUserDefinedTableMacro)operator;
            return udf.getTable(this.validator.typeFactory, this.call.getOperandList()).getRowType(this.validator.typeFactory);
        }
        return type;
    }

    @Override
    public SqlNode getNode() {
        return this.call;
    }
}

