/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.AvaticaParameter;
import org.apache.calcite.avatica.AvaticaResultSet;
import org.apache.calcite.avatica.Meta;

public abstract class AvaticaStatement
implements Statement {
    public final AvaticaConnection connection;
    public final Meta.StatementHandle handle;
    protected boolean closed;
    protected boolean closeOnCompletion;
    protected AvaticaResultSet openResultSet;
    protected int updateCount;
    private int queryTimeoutMillis;
    final int resultSetType;
    final int resultSetConcurrency;
    final int resultSetHoldability;
    private int fetchSize;
    private int fetchDirection;
    protected int maxRowCount = 0;

    protected AvaticaStatement(AvaticaConnection connection, Meta.StatementHandle h, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.connection = Objects.requireNonNull(connection);
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.closed = false;
        if (h == null) {
            Meta.ConnectionHandle ch = new Meta.ConnectionHandle(connection.id);
            h = connection.meta.createStatement(ch);
        }
        connection.statementMap.put(h.id, this);
        this.handle = h;
    }

    public int getId() {
        return this.handle.id;
    }

    private void checkNotPreparedOrCallable(String s) throws SQLException {
        if (this instanceof PreparedStatement || this instanceof CallableStatement) {
            throw this.connection.helper.createException("Cannot call " + s + " on prepared or callable statement");
        }
    }

    protected void executeInternal(String sql) throws SQLException {
        this.updateCount = -1;
        try {
            int maxRowCount1 = this.maxRowCount <= 0 ? -1 : this.maxRowCount;
            Meta.ExecuteResult executeResult = this.connection.prepareAndExecuteInternal(this, sql, maxRowCount1);
        }
        catch (RuntimeException e) {
            throw this.connection.helper.createException("error while executing SQL \"" + sql + "\": " + e.getMessage(), e);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkNotPreparedOrCallable("execute(String)");
        this.executeInternal(sql);
        return this.openResultSet != null && !this.openResultSet.isClosed();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkNotPreparedOrCallable("executeQuery(String)");
        try {
            this.executeInternal(sql);
            if (this.openResultSet == null) {
                throw this.connection.helper.createException("Statement did not return a result set");
            }
            return this.openResultSet;
        }
        catch (RuntimeException e) {
            throw this.connection.helper.createException("error while executing SQL \"" + sql + "\": " + e.getMessage(), e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkNotPreparedOrCallable("executeUpdate(String)");
        this.executeInternal(sql);
        return this.updateCount;
    }

    @Override
    public synchronized void close() throws SQLException {
        try {
            this.close_();
        }
        catch (RuntimeException e) {
            throw this.connection.helper.createException("While closing statement", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close_() {
        if (!this.closed) {
            this.closed = true;
            if (this.openResultSet != null) {
                AvaticaResultSet c = this.openResultSet;
                this.openResultSet = null;
                c.close();
            }
            try {
                this.connection.meta.closeStatement(this.handle);
            }
            finally {
                this.connection.statementMap.remove(this.handle.id);
            }
            this.connection.driver.handler.onStatementClose(this);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxRows() {
        return this.maxRowCount;
    }

    @Override
    public void setMaxRows(int maxRowCount) throws SQLException {
        if (maxRowCount < 0) {
            throw this.connection.helper.createException("illegal maxRows value: " + maxRowCount);
        }
        this.maxRowCount = maxRowCount;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        long timeoutSeconds = this.getQueryTimeoutMillis() / 1000;
        if (timeoutSeconds > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (timeoutSeconds == 0L && this.getQueryTimeoutMillis() > 0) {
            return 1;
        }
        return (int)timeoutSeconds;
    }

    int getQueryTimeoutMillis() {
        return this.queryTimeoutMillis;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw this.connection.helper.createException("illegal timeout value " + seconds);
        }
        this.setQueryTimeoutMillis(seconds * 1000);
    }

    void setQueryTimeoutMillis(int millis) {
        this.queryTimeoutMillis = millis;
    }

    @Override
    public synchronized void cancel() throws SQLException {
        if (this.openResultSet != null) {
            this.openResultSet.cancel();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.openResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.updateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() {
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public AvaticaConnection getConnection() {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnCompletion;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw this.connection.helper.createException("does not implement '" + iface + "'");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    protected boolean executeInternal(Meta.Signature signature) throws SQLException {
        ResultSet resultSet = this.executeQueryInternal(signature);
        return !resultSet.isClosed();
    }

    protected ResultSet executeQueryInternal(Meta.Signature signature) throws SQLException {
        return this.connection.executeQueryInternal(this, signature, null);
    }

    void onResultSetClose(ResultSet resultSet) {
        if (this.closeOnCompletion) {
            this.close_();
        }
    }

    protected List<Object> getParameterValues() {
        return Collections.emptyList();
    }

    protected List<Object> getBoundParameterValues() throws SQLException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object parameterValue : this.getParameterValues()) {
            if (parameterValue == null) {
                throw new SQLException("unbound parameter");
            }
            if (parameterValue == AvaticaParameter.DUMMY_VALUE) {
                parameterValue = null;
            }
            list.add(parameterValue);
        }
        return list;
    }
}

