/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.stomp.client.Promise;
import org.fusesource.stomp.codec.StompFrame;
import org.fusesource.stomp.jms.MessageQueue;
import org.fusesource.stomp.jms.StompChannel;
import org.fusesource.stomp.jms.StompJmsDestination;
import org.fusesource.stomp.jms.StompJmsExceptionSupport;
import org.fusesource.stomp.jms.StompJmsMessageListener;
import org.fusesource.stomp.jms.StompJmsSession;
import org.fusesource.stomp.jms.TxMessageQueue;
import org.fusesource.stomp.jms.message.StompJmsMessage;

public class StompJmsMessageConsumer
implements MessageConsumer,
StompJmsMessageListener {
    final StompJmsSession session;
    final StompJmsDestination destination;
    final AsciiBuffer id;
    final AtomicBoolean closed = new AtomicBoolean();
    boolean started;
    MessageListener messageListener;
    final String messageSelector;
    final MessageQueue messageQueue;
    final Lock lock = new ReentrantLock();
    final AtomicBoolean suspendedConnection = new AtomicBoolean();

    protected StompJmsMessageConsumer(AsciiBuffer id, StompJmsSession s, StompJmsDestination destination, String selector) throws JMSException {
        this.id = id;
        this.session = s;
        this.destination = destination;
        this.messageSelector = selector;
        this.messageQueue = this.session.acknowledgementMode == 0 ? new TxMessageQueue(this.session.consumerMessageBufferSize) : new MessageQueue(this.session.consumerMessageBufferSize);
    }

    public boolean tcpFlowControl() {
        return this.session.acknowledgementMode == -1;
    }

    public void init() throws JMSException {
        this.session.add(this);
    }

    public boolean isDurableSubscription() {
        return false;
    }

    public boolean isBrowser() {
        return false;
    }

    public void close() throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.session.remove(this);
            if (this.suspendedConnection.compareAndSet(true, false)) {
                this.session.channel.connection().resume();
            }
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return this.messageListener;
    }

    public String getMessageSelector() throws JMSException {
        this.checkClosed();
        return this.messageSelector;
    }

    public Message receive() throws JMSException {
        this.checkClosed();
        try {
            return this.copy(this.ack(this.messageQueue.dequeue(-1L)));
        }
        catch (Exception e) {
            throw StompJmsExceptionSupport.create(e);
        }
    }

    public Message receive(long timeout) throws JMSException {
        this.checkClosed();
        try {
            return this.copy(this.ack(this.messageQueue.dequeue(timeout)));
        }
        catch (InterruptedException e) {
            throw StompJmsExceptionSupport.create(e);
        }
    }

    public Message receiveNoWait() throws JMSException {
        this.checkClosed();
        StompJmsMessage result = this.copy(this.ack(this.messageQueue.dequeueNoWait()));
        return result;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkClosed();
        this.messageListener = listener;
        this.drainMessageQueueToListener();
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            throw new IllegalStateException("The MessageProducer is closed");
        }
    }

    StompJmsMessage copy(StompJmsMessage message) throws JMSException {
        if (message == null) {
            return null;
        }
        return message.copy();
    }

    StompJmsMessage ack(StompJmsMessage message) {
        if (message != null) {
            if (message.getAcknowledgeCallback() != null) {
                StompFrame frame = this.session.channel.serverAdaptor.createCreditFrame(this, message.getFrame());
                if (frame != null) {
                    try {
                        this.session.channel.sendFrame(frame);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return message;
            }
            this.doAck(message);
        }
        return message;
    }

    private void doAck(StompJmsMessage message) {
        if (this.tcpFlowControl()) {
            if (!this.messageQueue.isFull() && this.suspendedConnection.compareAndSet(true, false)) {
                this.session.channel.connection().resume();
            }
        } else {
            try {
                StompChannel channel = this.session.channel;
                if (channel == null) {
                    throw new JMSException("Consumer closed");
                }
                Promise<StompFrame> ack = new Promise<StompFrame>();
                switch (this.session.acknowledgementMode) {
                    case 2: {
                        channel.ackMessage(this.id, message.getMessageID(), null, ack);
                        break;
                    }
                    case 1: {
                        channel.ackMessage(this.id, message.getMessageID(), null, ack);
                        break;
                    }
                    case 3: {
                        channel.ackMessage(this.id, message.getMessageID(), null, null);
                        ack.onSuccess(null);
                        break;
                    }
                    case 0: {
                        channel.ackMessage(this.id, message.getMessageID(), this.session.currentTransactionId, null);
                        ack.onSuccess(null);
                        break;
                    }
                    case -1: {
                        throw new IllegalStateException("This should never get called.");
                    }
                }
                ack.await();
            }
            catch (JMSException e) {
                this.session.connection.onException(e);
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                this.session.connection.onException(new JMSException("Exception occurred sending ACK for message id : " + message.getMessageID()));
                throw new RuntimeException("Exception occurred sending ACK for message id : " + message.getMessageID(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(final StompJmsMessage message) {
        this.lock.lock();
        try {
            if (this.session.acknowledgementMode == 2) {
                message.setAcknowledgeCallback(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        if (StompJmsMessageConsumer.this.session.channel == null) {
                            throw new IllegalStateException("Session closed.");
                        }
                        StompJmsMessageConsumer.this.doAck(message);
                        return null;
                    }
                });
            }
            this.messageQueue.enqueue(message);
            if (this.tcpFlowControl() && this.messageQueue.isFull() && this.suspendedConnection.compareAndSet(false, true)) {
                this.session.channel.connection().suspend();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.messageListener != null && this.started) {
            this.session.getExecutor().execute(new Runnable(){

                public void run() {
                    StompJmsMessage message;
                    while (StompJmsMessageConsumer.this.session.isStarted() && (message = StompJmsMessageConsumer.this.messageQueue.dequeueNoWait()) != null) {
                        try {
                            StompJmsMessageConsumer.this.messageListener.onMessage((Message)StompJmsMessageConsumer.this.copy(StompJmsMessageConsumer.this.ack(message)));
                        }
                        catch (Exception e) {
                            StompJmsMessageConsumer.this.session.connection.onException(e);
                        }
                    }
                }
            });
        }
    }

    public AsciiBuffer getId() {
        return this.id;
    }

    public StompJmsDestination getDestination() {
        return this.destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.lock.lock();
        try {
            this.started = true;
            this.messageQueue.start();
            this.drainMessageQueueToListener();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.lock.lock();
        try {
            this.started = false;
            this.messageQueue.stop();
        }
        finally {
            this.lock.unlock();
        }
    }

    void rollback() {
        ((TxMessageQueue)this.messageQueue).rollback();
    }

    void commit() {
        ((TxMessageQueue)this.messageQueue).commit();
    }

    void drainMessageQueueToListener() {
        MessageListener listener = this.messageListener;
        if (listener != null && !this.messageQueue.isEmpty()) {
            List<StompJmsMessage> drain = this.messageQueue.removeAll();
            for (StompJmsMessage m : drain) {
                try {
                    listener.onMessage((Message)this.copy(this.ack(m)));
                }
                catch (Exception e) {
                    this.session.connection.onException(e);
                }
            }
            drain.clear();
        }
    }

    protected int getMessageQueueSize() {
        return this.messageQueue.size();
    }

    public boolean getNoLocal() throws IllegalStateException {
        return false;
    }
}

