/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stomp;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class StompEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":destination";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "stomp".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "destination", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(14);
        props.add("synchronous");
        props.add("destination");
        props.add("exchangePattern");
        props.add("sslContextParameters");
        props.add("login");
        props.add("version");
        props.add("brokerURL");
        props.add("lazyStartProducer");
        props.add("bridgeErrorHandler");
        props.add("headerFilterStrategy");
        props.add("host");
        props.add("exceptionHandler");
        props.add("customHeaders");
        props.add("passcode");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("login");
        secretProps.add("passcode");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

