/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DatumShiftTransform;
import org.apache.sis.referencing.operation.transform.InterpolatedTransform2D;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class InterpolatedTransform
extends DatumShiftTransform {
    private static final long serialVersionUID = -8962688502524486475L;
    private static final int GRID_DIMENSION = 2;
    private final int dimension;
    private final Inverse inverse;

    protected <T extends Quantity<T>> InterpolatedTransform(DatumShiftGrid<T, T> datumShiftGrid) throws NoninvertibleMatrixException {
        super(datumShiftGrid.getParameterDescriptors(), datumShiftGrid);
        Serializable serializable;
        Unit<Angle> unit;
        if (!datumShiftGrid.isCellValueRatio()) {
            throw new IllegalArgumentException(Resources.format((short)25, "isCellValueRatio", Boolean.FALSE));
        }
        Unit<T> unit2 = datumShiftGrid.getTranslationUnit();
        if (unit2 != datumShiftGrid.getCoordinateUnit()) {
            throw new IllegalArgumentException(Resources.format((short)26, "translation", unit2));
        }
        this.dimension = datumShiftGrid.getTranslationDimensions();
        MatrixSIS matrixSIS = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        matrixSIS.setMatrix(datumShiftGrid.getCoordinateToGrid().getMatrix());
        Unit<Angle> unit3 = unit = Units.isAngular(unit2) ? Units.DEGREE : unit2.getSystemUnit();
        if (!unit2.equals(unit)) {
            serializable = 1.0;
            Number number = 0.0;
            Number[] numberArray = Units.coefficients(unit.getConverterTo(unit2));
            switch (numberArray != null ? numberArray.length : -1) {
                case 2: {
                    serializable = numberArray[1];
                }
                case 1: {
                    number = numberArray[0];
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Resources.format((short)54, unit, unit2));
                }
            }
            for (int i = 0; i < this.dimension; ++i) {
                matrixSIS.convertBefore(i, (Number)serializable, number);
            }
        }
        serializable = matrixSIS.inverse();
        this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION).setMatrix((Matrix)serializable);
        datumShiftGrid.getParameterValues(this.context);
        this.inverse = this.createInverse();
    }

    public static <T extends Quantity<T>> MathTransform createGeodeticTransformation(MathTransformFactory mathTransformFactory, DatumShiftGrid<T, T> datumShiftGrid) throws FactoryException {
        InterpolatedTransform interpolatedTransform;
        ArgumentChecks.ensureNonNull("grid", datumShiftGrid);
        try {
            interpolatedTransform = datumShiftGrid.getTranslationDimensions() == 2 ? new InterpolatedTransform2D(datumShiftGrid) : new InterpolatedTransform(datumShiftGrid);
        }
        catch (NoninvertibleMatrixException noninvertibleMatrixException) {
            throw new FactoryException(noninvertibleMatrixException.getLocalizedMessage(), (Throwable)((Object)noninvertibleMatrixException));
        }
        return interpolatedTransform.context.completeTransform(mathTransformFactory, interpolatedTransform);
    }

    @Override
    public final int getSourceDimensions() {
        return this.dimension;
    }

    @Override
    public final int getTargetDimensions() {
        return this.dimension;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        if (dArray2 != null) {
            double[] dArray3 = new double[this.dimension];
            this.grid.interpolateInCell(d, d2, dArray3);
            if (this.dimension > 2) {
                System.arraycopy(dArray, n + 2, dArray2, n2 + 2, this.dimension - 2);
                int n3 = this.dimension;
                do {
                    int n4 = n2 + --n3;
                    dArray2[n4] = dArray2[n4] + dArray3[n3];
                } while (n3 > 2);
            }
            dArray2[n2 + 1] = d2 + dArray3[1];
            dArray2[n2] = d + dArray3[0];
        }
        if (!bl) {
            return null;
        }
        return this.grid.derivativeInCell(d, d2);
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        int n4 = this.dimension;
        if (dArray == dArray2) {
            switch (IterationStrategy.suggest(n, n4, n2, n4, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n4;
                    n2 += (n3 - 1) * n4;
                    n4 = -n4;
                    break;
                }
                default: {
                    dArray = Arrays.copyOfRange(dArray, n, n + n3 * n4);
                    n = 0;
                }
            }
        }
        double[] dArray3 = new double[this.dimension];
        while (--n3 >= 0) {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            this.grid.interpolateInCell(d, d2, dArray3);
            if (this.dimension > 2) {
                System.arraycopy(dArray, n + 2, dArray2, n2 + 2, this.dimension - 2);
                int n5 = this.dimension;
                do {
                    int n6 = n2 + --n5;
                    dArray2[n6] = dArray2[n6] + dArray3[n5];
                } while (n5 > 2);
            }
            dArray2[n2 + 1] = d2 + dArray3[1];
            dArray2[n2] = d + dArray3[0];
            n2 += n4;
            n += n4;
        }
    }

    @Override
    public MathTransform inverse() {
        return this.inverse;
    }

    Inverse createInverse() {
        return new Inverse(this);
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() + Objects.hashCode(this.grid);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        return super.equals(object, comparisonMode) && Objects.equals(this.grid, ((InterpolatedTransform)object).grid);
    }

    static class Inverse
    extends AbstractMathTransform.Inverse
    implements Serializable {
        private static final long serialVersionUID = 4335801994727826360L;
        private static final boolean DEBUG = false;
        private static final boolean SIMPLE = false;
        private static final int MAXIMUM_ITERATIONS = 36;
        private final InterpolatedTransform forward;
        private final double tolerance;

        Inverse(InterpolatedTransform interpolatedTransform) {
            this.forward = interpolatedTransform;
            this.tolerance = interpolatedTransform.grid.getCellPrecision();
            if (!(this.tolerance > 0.0)) {
                throw new IllegalArgumentException(Errors.format((short)165, "grid.cellPrecision", this.tolerance));
            }
        }

        @Override
        public MathTransform inverse() {
            return this.forward;
        }

        @Override
        public final Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
            int n3 = this.forward.dimension;
            if (dArray2 == null) {
                dArray2 = new double[n3];
                n2 = 0;
            }
            this.transform(dArray, n, dArray2, n2, 1);
            if (bl) {
                return Matrices.inverse(this.forward.derivative(new DirectPositionView.Double(dArray2, n2, n3)));
            }
            return null;
        }

        @Override
        public final void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
            int n4;
            int n5 = n4 = this.forward.dimension;
            if (dArray == dArray2) {
                switch (IterationStrategy.suggest(n, n5, n2, n5, n3)) {
                    case ASCENDING: {
                        break;
                    }
                    case DESCENDING: {
                        n += (n3 - 1) * n5;
                        n2 += (n3 - 1) * n5;
                        n5 = -n5;
                        break;
                    }
                    default: {
                        dArray = Arrays.copyOfRange(dArray, n, n + n3 * n5);
                        n = 0;
                    }
                }
            }
            double[] dArray3 = new double[n4 + 4];
            while (--n3 >= 0) {
                int n6;
                double d;
                double d2;
                block9: {
                    double d3 = d2 = dArray[n];
                    double d4 = d = dArray[n + 1];
                    double d5 = this.tolerance;
                    n6 = 36;
                    while (true) {
                        this.forward.grid.interpolateInCell(d2, d, dArray3);
                        double d6 = dArray3[0];
                        double d7 = dArray3[1];
                        double d8 = dArray3[n4];
                        double d9 = dArray3[n4 + 1];
                        double d10 = dArray3[n4 + 2];
                        double d11 = dArray3[n4 + 3];
                        double d12 = d8 * d11 - d9 * d10;
                        double d13 = d2 + d6 - d3;
                        double d14 = d + d7 - d4;
                        double d15 = (d13 * d11 - d14 * d9) / d12;
                        double d16 = (d14 * d8 - d13 * d10) / d12;
                        d2 -= d15;
                        d -= d16;
                        if (!(Math.abs(d13) > d5) && !(Math.abs(d14) > d5)) break block9;
                        if (--n6 >= 0) continue;
                        if (n6 != -1 || this.forward.grid.isCellInGrid(d2, d)) break;
                        d5 = 0.5;
                    }
                    throw new TransformException(Resources.format((short)46));
                }
                if (n4 > 2) {
                    System.arraycopy(dArray, n + 2, dArray2, n2 + 2, n4 - 2);
                    n6 = n4;
                    do {
                        int n7 = n2 + --n6;
                        dArray2[n7] = dArray2[n7] - dArray3[n6];
                    } while (n6 > 2);
                }
                dArray2[n2] = d2;
                dArray2[n2 + 1] = d;
                n2 += n5;
                n += n5;
            }
        }
    }
}

