/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.MismatchedReferenceSystemException;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

class SpecializableTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -7379277748632094312L;
    private final MathTransform global;
    private final SubArea[] domains;
    private MathTransform inverse;

    SpecializableTransform(MathTransform mathTransform, Map<Envelope, MathTransform> map) {
        this.global = mathTransform;
        int n = mathTransform.getSourceDimensions();
        int n2 = mathTransform.getTargetDimensions();
        ArrayList<SubArea> arrayList = new ArrayList<SubArea>(map.size());
        for (Map.Entry<Envelope, MathTransform> entry : map.entrySet()) {
            MathTransform mathTransform2 = entry.getValue();
            SpecializableTransform.ensureDimensionMatches(0, n, mathTransform2.getSourceDimensions());
            SpecializableTransform.ensureDimensionMatches(1, n2, mathTransform2.getTargetDimensions());
            SubArea[] subAreaArray = null;
            if (mathTransform2 instanceof SpecializableTransform) {
                subAreaArray = ((SpecializableTransform)mathTransform2).domains;
                mathTransform2 = ((SpecializableTransform)mathTransform2).global;
            }
            SubArea subArea = new SubArea(entry.getKey(), mathTransform2);
            SpecializableTransform.addSpecialization(subArea, arrayList, n);
            if (subAreaArray == null) continue;
            for (SubArea subArea2 : subAreaArray) {
                SubArea subArea3 = new SubArea(subArea2, subArea2.transform);
                subArea3.intersect(subArea);
                SpecializableTransform.addSpecialization(subArea3, arrayList, n);
            }
        }
        this.domains = arrayList.toArray(new SubArea[arrayList.size()]);
        SubArea.uniformize(this.domains);
    }

    private static void ensureDimensionMatches(int n, int n2, int n3) {
        if (n2 != n3) {
            throw new MismatchedDimensionException(Resources.format((short)37, n, n2, n3));
        }
    }

    private static void addSpecialization(SubArea subArea, List<SubArea> list, int n) {
        if (!subArea.isEmpty()) {
            if (subArea.getDimension() != n) {
                throw new MismatchedDimensionException(Errors.format((short)81, "envelope", n, subArea.getDimension()));
            }
            for (SubArea subArea2 : list) {
                if (!subArea2.addSpecialization(subArea)) continue;
                return;
            }
            for (SubArea subArea2 : list) {
                if (!subArea.intersects(subArea2)) continue;
                throw new IllegalArgumentException("Current implementation does not accept overlapping envelopes.");
            }
            list.add(subArea);
        }
    }

    @Override
    public final int getSourceDimensions() {
        return this.global.getSourceDimensions();
    }

    @Override
    public final int getTargetDimensions() {
        return this.global.getTargetDimensions();
    }

    private MathTransform forDomain(SubArea subArea) {
        return subArea != null ? subArea.transform : this.global;
    }

    @Override
    public final DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) throws TransformException {
        return this.forDomain(SubArea.find(this.domains, directPosition)).transform(directPosition, directPosition2);
    }

    @Override
    public final Matrix derivative(DirectPosition directPosition) throws TransformException {
        return this.forDomain(SubArea.find(this.domains, directPosition)).derivative(directPosition);
    }

    @Override
    public final Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        Matrix matrix;
        DirectPositionView.Double double_ = new DirectPositionView.Double(dArray, n, this.global.getSourceDimensions());
        MathTransform mathTransform = this.forDomain(SubArea.find(this.domains, (DirectPosition)double_));
        if (mathTransform instanceof AbstractMathTransform) {
            return ((AbstractMathTransform)mathTransform).transform(dArray, n, dArray2, n2, bl);
        }
        Matrix matrix2 = matrix = bl ? mathTransform.derivative((DirectPosition)double_) : null;
        if (dArray2 != null) {
            mathTransform.transform(dArray, n, dArray2, n2, 1);
        }
        return matrix;
    }

    private void transform(TransformCall transformCall, DirectPositionView directPositionView, int n, int n2, int n3, int n4) throws TransformException {
        boolean bl = n2 < 0;
        SubArea subArea = SubArea.find(this.domains, (DirectPosition)directPositionView);
        while (n4 > 0) {
            MathTransform mathTransform;
            int n5 = directPositionView.offset;
            if (subArea == null) {
                mathTransform = this.global;
                do {
                    directPositionView.offset += n2;
                } while (--n4 > 0 && (subArea = SubArea.find(this.domains, (DirectPosition)directPositionView)) == null);
            } else {
                SubArea subArea2 = subArea;
                mathTransform = subArea.transform;
                do {
                    directPositionView.offset += n2;
                } while (--n4 > 0 && (subArea = SubArea.find(subArea, (DirectPosition)directPositionView)) == subArea2);
                if (subArea == null) {
                    subArea = SubArea.find(this.domains, (DirectPosition)directPositionView);
                }
            }
            int n6 = (directPositionView.offset - n5) / n2;
            int n7 = n;
            n += n3 * n6;
            if (bl) {
                n5 = directPositionView.offset - n2;
                n7 = n - n3;
            }
            transformCall.apply(mathTransform, n5, n7, n6);
        }
    }

    @Override
    public final void transform(double[] dArray, int n4, double[] dArray2, int n5, int n6) throws TransformException {
        int n7 = this.getSourceDimensions();
        int n8 = this.getTargetDimensions();
        if (dArray == dArray2) {
            switch (IterationStrategy.suggest(n4, n7, n5, n8, n6)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n4 += (n6 - 1) * n7;
                    n7 = -n7;
                    n5 += (n6 - 1) * n8;
                    n8 = -n8;
                    break;
                }
                default: {
                    dArray = Arrays.copyOfRange(dArray, n4, n4 + n6 * n7);
                    n4 = 0;
                }
            }
        }
        double[] dArray3 = dArray;
        this.transform((mathTransform, n, n2, n3) -> mathTransform.transform(dArray3, n, dArray2, n2, n3), new DirectPositionView.Double(dArray, n4, Math.abs(n7)), n5, n7, n8, n6);
    }

    @Override
    public final void transform(float[] fArray, int n4, float[] fArray2, int n5, int n6) throws TransformException {
        int n7 = this.getSourceDimensions();
        int n8 = this.getTargetDimensions();
        if (fArray == fArray2) {
            switch (IterationStrategy.suggest(n4, n7, n5, n8, n6)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n4 += (n6 - 1) * n7;
                    n7 = -n7;
                    n5 += (n6 - 1) * n8;
                    n8 = -n8;
                    break;
                }
                default: {
                    fArray = Arrays.copyOfRange(fArray, n4, n4 + n6 * n7);
                    n4 = 0;
                }
            }
        }
        float[] fArray3 = fArray;
        this.transform((mathTransform, n, n2, n3) -> mathTransform.transform(fArray3, n, fArray2, n2, n3), new DirectPositionView.Float(fArray, n4, Math.abs(n7)), n5, n7, n8, n6);
    }

    @Override
    public final void transform(double[] dArray, int n4, float[] fArray, int n5, int n6) throws TransformException {
        int n7 = this.getSourceDimensions();
        int n8 = this.getTargetDimensions();
        this.transform((mathTransform, n, n2, n3) -> mathTransform.transform(dArray, n, fArray, n2, n3), new DirectPositionView.Double(dArray, n4, n7), n5, n7, n8, n6);
    }

    @Override
    public final void transform(float[] fArray, int n4, double[] dArray, int n5, int n6) throws TransformException {
        int n7 = this.getSourceDimensions();
        int n8 = this.getTargetDimensions();
        this.transform((mathTransform, n, n2, n3) -> mathTransform.transform(fArray, n, dArray, n2, n3), new DirectPositionView.Float(fArray, n4, n7), n5, n7, n8, n6);
    }

    @Override
    protected final int computeHashCode() {
        return super.computeHashCode() + 7 * this.global.hashCode() ^ Arrays.hashCode(this.domains);
    }

    @Override
    public final boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            SpecializableTransform specializableTransform = (SpecializableTransform)object;
            return Utilities.deepEquals(this.global, specializableTransform.global, comparisonMode) && Utilities.deepEquals(this.domains, specializableTransform.domains, comparisonMode);
        }
        return false;
    }

    @Override
    protected final String formatTo(Formatter formatter) {
        formatter.newLine();
        formatter.append(this.global);
        for (SubArea subArea : this.domains) {
            SubArea.format(subArea, formatter);
        }
        formatter.setInvalidWKT(SpecializableTransform.class, null);
        return "Specializable_MT";
    }

    @Override
    public synchronized MathTransform inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            this.inverse = this.createInverse();
        }
        return this.inverse;
    }

    Inverse createInverse() throws NoninvertibleTransformException {
        return new Inverse(this);
    }

    static class Inverse
    extends AbstractMathTransform.Inverse
    implements Serializable {
        private static final long serialVersionUID = 1060617594604917167L;
        private final SpecializableTransform forward;
        private final MathTransform global;

        Inverse(SpecializableTransform specializableTransform) throws NoninvertibleTransformException {
            this.forward = specializableTransform;
            this.global = specializableTransform.global.inverse();
            for (SubArea subArea : specializableTransform.domains) {
                SubArea.createInverse(subArea);
            }
        }

        @Override
        public MathTransform inverse() {
            return this.forward;
        }

        @Override
        public final DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) throws TransformException {
            double[] dArray = directPosition.getCoordinate();
            directPosition2 = this.global.transform(directPosition, directPosition2);
            SubArea subArea = SubArea.find(this.forward.domains, directPosition2);
            if (subArea != null) {
                directPosition2 = subArea.inverse.transform((DirectPosition)new DirectPositionView.Double(dArray), directPosition2);
            }
            return directPosition2;
        }

        @Override
        public final Matrix derivative(DirectPosition directPosition) throws TransformException {
            return this.transform(directPosition.getCoordinate(), 0, null, 0, true);
        }

        @Override
        public final Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
            Matrix matrix;
            int n3 = this.global.getSourceDimensions();
            int n4 = this.global.getTargetDimensions();
            if (dArray2 == null) {
                dArray2 = new double[n4];
                n2 = 0;
            } else if (dArray == dArray2 && n + n3 > n2 && n < n2 + n4) {
                dArray = Arrays.copyOfRange(dArray, n, n3);
                n = 0;
            }
            MathTransform mathTransform = this.global;
            boolean bl2 = false;
            do {
                if (mathTransform instanceof AbstractMathTransform) {
                    matrix = ((AbstractMathTransform)mathTransform).transform(dArray, n, dArray2, n2, bl);
                } else {
                    mathTransform.transform(dArray, n, dArray2, n2, 1);
                    Matrix matrix2 = matrix = bl ? mathTransform.derivative((DirectPosition)new DirectPositionView.Double(dArray, n, n3)) : null;
                }
                if (bl2) break;
                SubArea subArea = SubArea.find(this.forward.domains, (DirectPosition)new DirectPositionView.Double(dArray2, n2, n4));
                if (subArea == null) continue;
                mathTransform = subArea.inverse;
                bl2 = true;
            } while (bl2);
            return matrix;
        }

        private void transform(TransformCall transformCall, double[] dArray, int n, int n2, int n3, int n4, int n5) throws TransformException {
            SubArea[] subAreaArray = this.forward.domains;
            transformCall.apply(this.global, n, n2, n5);
            DirectPositionView.Double double_ = new DirectPositionView.Double(dArray, n2, n4);
            while (n5 > 0) {
                SubArea subArea = SubArea.find(subAreaArray, (DirectPosition)double_);
                if (subArea == null) {
                    double_.offset += n4;
                    --n5;
                    continue;
                }
                do {
                    SubArea subArea2 = subArea;
                    int n6 = (double_.offset - n2) / n4;
                    n += n6 * n3;
                    n2 = double_.offset;
                    do {
                        double_.offset += n4;
                        if (--n5 > 0) continue;
                        subArea = null;
                        break;
                    } while ((subArea = SubArea.find(subArea, (DirectPosition)double_)) == subArea2);
                    n6 = (double_.offset - n2) / n4;
                    transformCall.apply(subArea2.inverse, n, n2, n6);
                    n += n3 * n6;
                    n2 = double_.offset;
                } while (subArea != null);
            }
        }

        @Override
        public void transform(double[] dArray, int n4, double[] dArray2, int n5, int n6) throws TransformException {
            int n7;
            if (n6 <= 0) {
                return;
            }
            int n8 = this.global.getSourceDimensions();
            int n9 = this.global.getTargetDimensions();
            if (dArray == dArray2 && ((n7 = n4 + n6 * n8) > n5 || n5 + n6 * n9 > n4)) {
                dArray = Arrays.copyOfRange(dArray, n4, n7);
                n4 = 0;
            }
            double[] dArray3 = dArray;
            this.transform((mathTransform, n, n2, n3) -> mathTransform.transform(dArray3, n, dArray2, n2, n3), dArray2, n4, n5, n8, n9, n6);
        }

        @Override
        public void transform(float[] fArray, int n4, float[] fArray2, int n5, int n6) throws TransformException {
            if (n6 <= 0) {
                return;
            }
            int n7 = this.global.getSourceDimensions();
            int n8 = this.global.getTargetDimensions();
            double[] dArray = new double[n6 * n8];
            this.transform((mathTransform, n, n2, n3) -> mathTransform.transform(fArray, n, dArray, n2, n3), dArray, n4, 0, n7, n8, n6);
            n6 *= n8;
            for (int i = 0; i < n6; ++i) {
                fArray2[n5++] = (float)dArray[i];
            }
        }

        @Override
        public void transform(double[] dArray, int n4, float[] fArray, int n5, int n6) throws TransformException {
            if (n6 <= 0) {
                return;
            }
            int n7 = this.global.getSourceDimensions();
            int n8 = this.global.getTargetDimensions();
            double[] dArray2 = new double[n6 * n8];
            this.transform((mathTransform, n, n2, n3) -> mathTransform.transform(dArray3, n, dArray2, n2, n3), dArray2, n4, 0, n7, n8, n6);
            n6 *= n8;
            for (int i = 0; i < n6; ++i) {
                fArray[n5++] = (float)dArray2[i];
            }
        }

        @Override
        public void transform(float[] fArray, int n4, double[] dArray, int n5, int n6) throws TransformException {
            if (n6 <= 0) {
                return;
            }
            int n7 = this.global.getSourceDimensions();
            int n8 = this.global.getTargetDimensions();
            this.transform((mathTransform, n, n2, n3) -> mathTransform.transform(fArray, n, dArray, n2, n3), dArray, n4, n5, n7, n8, n6);
        }
    }

    @FunctionalInterface
    private static interface TransformCall {
        public void apply(MathTransform var1, int var2, int var3, int var4) throws TransformException;
    }

    private static final class SubArea
    extends GeneralEnvelope {
        private static final long serialVersionUID = 4197316795428796526L;
        final MathTransform transform;
        MathTransform inverse;
        private SubArea specialization;

        SubArea(Envelope envelope, MathTransform mathTransform) {
            super(envelope);
            this.transform = mathTransform;
        }

        boolean addSpecialization(SubArea subArea) {
            if (this.specialization == null) {
                if (!this.contains(subArea)) {
                    return false;
                }
            } else if (!subArea.addSpecialization(this.specialization)) {
                return this.specialization.addSpecialization(subArea);
            }
            this.specialization = subArea;
            return true;
        }

        static void uniformize(SubArea[] subAreaArray) {
            CoordinateReferenceSystem coordinateReferenceSystem = null;
            for (SubArea subArea : subAreaArray) {
                do {
                    CoordinateReferenceSystem coordinateReferenceSystem2 = subArea.getCoordinateReferenceSystem();
                    if (coordinateReferenceSystem == null) {
                        coordinateReferenceSystem = coordinateReferenceSystem2;
                        continue;
                    }
                    if (coordinateReferenceSystem2 == null || Utilities.equalsIgnoreMetadata(coordinateReferenceSystem, coordinateReferenceSystem2)) continue;
                    throw new MismatchedReferenceSystemException(Errors.format((short)78));
                } while ((subArea = subArea.specialization) != null);
            }
            for (SubArea subArea : subAreaArray) {
                do {
                    subArea.setCoordinateReferenceSystem(coordinateReferenceSystem);
                } while ((subArea = subArea.specialization) != null);
            }
        }

        static void createInverse(SubArea subArea) throws NoninvertibleTransformException {
            do {
                subArea.inverse = subArea.transform.inverse();
            } while ((subArea = subArea.specialization) != null);
        }

        static SubArea find(SubArea[] subAreaArray, DirectPosition directPosition) {
            for (SubArea subArea : subAreaArray) {
                if (!subArea.contains(directPosition)) continue;
                SubArea subArea2 = subArea.specialization;
                while (subArea2 != null && subArea2.contains(directPosition)) {
                    subArea = subArea2;
                    subArea2 = subArea2.specialization;
                }
                return subArea;
            }
            return null;
        }

        static SubArea find(SubArea subArea, DirectPosition directPosition) {
            SubArea subArea2 = null;
            while (subArea.contains(directPosition)) {
                subArea2 = subArea;
                subArea = subArea.specialization;
                if (subArea != null) continue;
                break;
            }
            return subArea2;
        }

        static void format(SubArea subArea, Formatter formatter) {
            while (subArea != null) {
                formatter.newLine();
                formatter.append(subArea);
                formatter.newLine();
                formatter.append(subArea.transform);
                subArea = subArea.specialization;
            }
        }

        @Override
        public int hashCode() {
            int n = super.hashCode() ^ this.transform.hashCode();
            if (this.specialization != null) {
                n += 37 * this.specialization.hashCode();
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (super.equals(object)) {
                SubArea subArea = (SubArea)object;
                return this.transform.equals(subArea.transform) && Objects.equals(this.specialization, subArea.specialization);
            }
            return false;
        }

        @Override
        protected String formatTo(Formatter formatter) {
            super.formatTo(formatter);
            return "Domain";
        }
    }
}

