/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.internal.metadata.Identifiers;
import org.apache.sis.internal.simple.CitationConstant;
import org.apache.sis.internal.simple.SimpleCitation;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Static;
import org.apache.sis.xml.IdentifierSpace;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

public final class Citations
extends Static {
    public static final List<Citation> ISO_19115 = UnmodifiableArrayList.wrap(new CitationConstant[]{new CitationConstant("ISO 19115-1"), new CitationConstant("ISO 19115-2")});
    static final CitationConstant IOGP = new CitationConstant("IOGP");
    public static final IdentifierSpace<Integer> EPSG = new CitationConstant.Authority<Integer>("EPSG");
    public static final IdentifierSpace<Integer> WMS = new CitationConstant.Authority<Integer>("WMS", "OGC");
    public static final IdentifierSpace<String> OGC = new CitationConstant.Authority<String>("OGC");
    public static final IdentifierSpace<String> ESRI = new CitationConstant.Authority<String>("ArcGIS", "ESRI");
    public static final IdentifierSpace<String> NETCDF = new CitationConstant.Authority<String>("NetCDF");
    public static final IdentifierSpace<Integer> GEOTIFF = new CitationConstant.Authority<Integer>("GeoTIFF");
    public static final IdentifierSpace<String> PROJ4 = new CitationConstant.Authority<String>("Proj4");
    public static final IdentifierSpace<Integer> MAP_INFO = new CitationConstant.Authority<Integer>("MapInfo");
    public static final IdentifierSpace<Integer> S57 = new CitationConstant.Authority<Integer>("IHO S-57", "S57");
    public static final IdentifierSpace<String> ISBN = new NonMarshalledAuthority<String>("ISBN", 5);
    public static final IdentifierSpace<String> ISSN = new NonMarshalledAuthority<String>("ISSN", 4);
    public static final Citation SIS = new CitationConstant.Authority("SIS");
    private static final CitationConstant[] CITATIONS = new CitationConstant[]{(CitationConstant)((Object)EPSG), (CitationConstant)((Object)OGC), (CitationConstant)((Object)WMS), (CitationConstant)((Object)ESRI), (CitationConstant)((Object)NETCDF), (CitationConstant)((Object)GEOTIFF), (CitationConstant)((Object)PROJ4), (CitationConstant)((Object)MAP_INFO), (CitationConstant)((Object)S57), (CitationConstant)((Object)ISBN), (CitationConstant)((Object)ISSN), (CitationConstant)SIS, (CitationConstant)ISO_19115.get(0), (CitationConstant)ISO_19115.get(1)};

    private Citations() {
    }

    static void refresh() {
        for (CitationConstant citationConstant : CITATIONS) {
            citationConstant.refresh();
        }
        IOGP.refresh();
    }

    public static Citation[] values() {
        return (Citation[])Arrays.copyOf(CITATIONS, CITATIONS.length, Citation[].class);
    }

    public static Citation fromName(String string) {
        if (string == null || (string = CharSequences.trimWhitespaces(string)).isEmpty()) {
            return null;
        }
        for (CitationConstant citationConstant : CITATIONS) {
            if (!Citations.equalsFiltered(string, citationConstant.namespace)) continue;
            return citationConstant;
        }
        if (Citations.equalsFiltered(string, "CRS") || Citations.equalsFiltered(string, "WMS")) {
            return WMS;
        }
        if (Citations.equalsFiltered(string, "IOGP") || Citations.equalsFiltered(string, "OGP")) {
            return IOGP;
        }
        return new SimpleCitation(string);
    }

    private static boolean equalsFiltered(CharSequence charSequence, CharSequence charSequence2) {
        return CharSequences.equalsFiltered(charSequence, charSequence2, Characters.Filter.LETTERS_AND_DIGITS, true);
    }

    public static boolean titleMatches(Citation citation, Citation citation2) {
        if (citation != null && citation2 != null) {
            if (citation == citation2) {
                return true;
            }
            InternationalString internationalString = citation2.getTitle();
            Iterator<? extends InternationalString> iterator = null;
            while (true) {
                if (internationalString != null) {
                    String string = internationalString.toString(Locale.ROOT);
                    if (Citations.titleMatches(citation, string)) {
                        return true;
                    }
                    String string2 = internationalString.toString();
                    if (!Objects.equals(string2, string) && Citations.titleMatches(citation, string2)) {
                        return true;
                    }
                }
                if (iterator == null && (iterator = CollectionsExt.nonEmptyIterator(citation2.getAlternateTitles())) == null || !iterator.hasNext()) break;
                internationalString = iterator.next();
            }
        }
        return false;
    }

    public static boolean titleMatches(Citation citation, String string) {
        if (citation != null && string != null) {
            InternationalString internationalString = citation.getTitle();
            Iterator<? extends InternationalString> iterator = null;
            while (true) {
                if (internationalString != null) {
                    String string2 = internationalString.toString(Locale.ROOT);
                    if (Citations.equalsFiltered(string2, string)) {
                        return true;
                    }
                    String string3 = internationalString.toString();
                    if (!Objects.equals(string3, string2) && Citations.equalsFiltered(string3, string)) {
                        return true;
                    }
                }
                if (iterator == null && (iterator = CollectionsExt.nonEmptyIterator(citation.getAlternateTitles())) == null || !iterator.hasNext()) break;
                internationalString = iterator.next();
            }
        }
        return false;
    }

    public static boolean identifierMatches(Citation citation, Citation citation2) {
        if (citation != null && citation2 != null) {
            if (citation == citation2) {
                return true;
            }
            if (citation instanceof CitationConstant && citation2 instanceof CitationConstant) {
                return citation.equals(citation2);
            }
            Iterator<? extends Identifier> iterator = CollectionsExt.nonEmptyIterator(citation2.getIdentifiers());
            if (iterator == null) {
                iterator = CollectionsExt.nonEmptyIterator(citation.getIdentifiers());
                if (iterator == null) {
                    return Citations.titleMatches(citation, citation2);
                }
                citation = citation2;
            }
            do {
                Identifier identifier;
                if ((identifier = iterator.next()) == null || !Citations.identifierMatches(citation, identifier, identifier.getCode())) continue;
                return true;
            } while (iterator.hasNext());
        }
        return false;
    }

    public static boolean identifierMatches(Citation citation, String string) {
        return Citations.identifierMatches(citation, null, string);
    }

    static boolean identifierMatches(Citation citation, Identifier identifier, String string) {
        if (citation != null && string != null) {
            CharSequence charSequence;
            Collection<? extends Identifier> collection = citation.getIdentifiers();
            Iterator<? extends Identifier> iterator = CollectionsExt.nonEmptyIterator(collection);
            if (iterator == null) {
                return Citations.titleMatches(citation, string);
            }
            while (iterator.hasNext()) {
                String string2;
                Identifier identifier2 = iterator.next();
                if (identifier2 == null || !Citations.equalsFiltered(string, identifier2.getCode()) || identifier instanceof ReferenceIdentifier && (string2 = ((ReferenceIdentifier)identifier).getCodeSpace()) != null && identifier2 instanceof ReferenceIdentifier && (charSequence = ((ReferenceIdentifier)identifier2).getCodeSpace()) != null && !Citations.equalsFiltered(string2, charSequence)) continue;
                return true;
            }
            if (identifier == null) {
                int n = 0;
                int n2 = string.length();
                while ((n = CharSequences.indexOf((CharSequence)string, 58, n, n2)) >= 0) {
                    charSequence = string.subSequence(0, n);
                    CharSequence charSequence2 = string.subSequence(++n, n2);
                    for (Identifier identifier3 : collection) {
                        String string3 = identifier3 instanceof ReferenceIdentifier ? ((ReferenceIdentifier)identifier3).getCodeSpace() : null;
                        if (!Citations.equalsFiltered(charSequence, string3) || !Citations.equalsFiltered(charSequence2, identifier3.getCode())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static String getIdentifier(Citation citation) {
        return Identifiers.getIdentifier(citation, false);
    }

    @Deprecated
    public static String getUnicodeIdentifier(Citation citation) {
        return Citations.removeIgnorableCharacters(Identifiers.getIdentifier(citation, true));
    }

    public static String toCodeSpace(Citation citation) {
        if (citation instanceof IdentifierSpace) {
            return ((IdentifierSpace)citation).getName();
        }
        return Citations.removeIgnorableCharacters(Identifiers.getIdentifier(citation, true));
    }

    @Deprecated
    public static String getCodeSpace(Citation citation) {
        return Citations.toCodeSpace(citation);
    }

    private static String removeIgnorableCharacters(String string) {
        if (string != null) {
            int n;
            int n2 = string.length();
            for (int i = 0; i < n2; i += n) {
                int n3 = string.codePointAt(i);
                n = Character.charCount(n3);
                if (!Character.isIdentifierIgnorable(n3)) continue;
                StringBuilder stringBuilder = new StringBuilder(n2 - n).append(string, 0, i);
                while ((i += n) < n2) {
                    n3 = string.codePointAt(i);
                    n = Character.charCount(n3);
                    if (Character.isIdentifierIgnorable(n3)) continue;
                    stringBuilder.appendCodePoint(n3);
                }
                return stringBuilder.toString();
            }
        }
        return string;
    }

    static {
        SystemListener.add(new SystemListener("org.apache.sis.metadata"){

            @Override
            protected void classpathChanged() {
                Citations.refresh();
            }

            @Override
            protected void databaseChanged() {
                Citations.refresh();
            }
        });
    }
}

