/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.code.CI_RoleCode;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.DefaultResponsibleParty;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.extent.Extent;

@XmlType(name="CI_Responsibility_Type", propOrder={"role", "extent", "party"})
@XmlRootElement(name="CI_Responsibility")
@XmlSeeAlso(value={DefaultResponsibleParty.class})
@UML(identifier="CI_Responsibility", specification=Specification.ISO_19115)
public class DefaultResponsibility
extends ISOMetadata {
    private static final long serialVersionUID = -8290895980682233572L;
    private Role role;
    private Collection<Extent> extents;
    private Collection<AbstractParty> parties;

    public DefaultResponsibility() {
    }

    public DefaultResponsibility(Role role, Extent extent, AbstractParty abstractParty) {
        this.role = role;
        this.extents = this.singleton(extent, Extent.class);
        this.parties = this.singleton(abstractParty, AbstractParty.class);
    }

    public DefaultResponsibility(DefaultResponsibility defaultResponsibility) {
        super(defaultResponsibility);
        if (defaultResponsibility != null) {
            this.role = defaultResponsibility.getRole();
            this.extents = this.copyCollection(defaultResponsibility.getExtents(), Extent.class);
            this.parties = this.copyCollection(defaultResponsibility.getParties(), AbstractParty.class);
        }
    }

    DefaultResponsibility(ResponsibleParty responsibleParty) {
        super(responsibleParty);
        if (responsibleParty != null) {
            this.role = responsibleParty.getRole();
            if (responsibleParty instanceof DefaultResponsibility) {
                DefaultResponsibility defaultResponsibility = (DefaultResponsibility)((Object)responsibleParty);
                this.extents = this.copyCollection(defaultResponsibility.getExtents(), Extent.class);
                this.parties = this.copyCollection(defaultResponsibility.getParties(), AbstractParty.class);
            }
        }
    }

    @XmlElement(name="role", required=true)
    @XmlJavaTypeAdapter(value=CI_RoleCode.Since2014.class)
    @UML(identifier="role", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.checkWritePermission(this.role);
        this.role = role;
    }

    @UML(identifier="extent", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Extent> getExtents() {
        this.extents = this.nonNullCollection(this.extents, Extent.class);
        return this.extents;
    }

    public void setExtents(Collection<? extends Extent> collection) {
        this.extents = this.writeCollection(collection, this.extents, Extent.class);
    }

    @UML(identifier="party", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Collection<AbstractParty> getParties() {
        this.parties = this.nonNullCollection(this.parties, AbstractParty.class);
        return this.parties;
    }

    public void setParties(Collection<? extends AbstractParty> collection) {
        this.parties = this.writeCollection(collection, this.parties, AbstractParty.class);
    }

    @XmlElement(name="extent")
    private Collection<Extent> getExtent() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getExtents() : null;
    }

    @XmlElement(name="party", required=true)
    private Collection<AbstractParty> getParty() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getParties() : null;
    }
}

