/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.util.Static;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.util.GenericName;

public final class FeatureUtilities
extends Static {
    public static final ParameterDescriptorGroup LINK_PARAMS = FeatureUtilities.parameters("Link", new ParameterDescriptor[0]);

    private FeatureUtilities() {
    }

    public static ParameterDescriptorGroup parameters(String string, ParameterDescriptor<?> ... parameterDescriptorArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put("name", string);
        hashMap.put("authority", (String)Citations.SIS);
        return new DefaultParameterDescriptorGroup(hashMap, 1, 1, new GeneralParameterDescriptor[0]);
    }

    static String linkOf(AbstractIdentifiedType abstractIdentifiedType) {
        AbstractOperation abstractOperation;
        if (abstractIdentifiedType instanceof AbstractOperation && (abstractOperation = (AbstractOperation)abstractIdentifiedType).getParameters() == LINK_PARAMS) {
            return CollectionsExt.first(abstractOperation.getDependencies());
        }
        return null;
    }

    public static String[] getNames(Collection<? extends AbstractIdentifiedType> collection) {
        if (collection == null) {
            return null;
        }
        String[] stringArray = new String[collection.size()];
        Iterator<? extends AbstractIdentifiedType> iterator = collection.iterator();
        for (int i = 0; i < stringArray.length; ++i) {
            GenericName genericName;
            AbstractIdentifiedType abstractIdentifiedType = iterator.next();
            if (abstractIdentifiedType == null || (genericName = abstractIdentifiedType.getName()) == null) continue;
            stringArray[i] = genericName.toString();
        }
        if (iterator.hasNext()) {
            throw new ConcurrentModificationException();
        }
        return stringArray;
    }
}

