/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import javax.measure.quantity.Time;
import org.apache.sis.internal.referencing.EllipsoidalHeightCombiner;
import org.apache.sis.internal.referencing.ReferencingFactoryContainer;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.PolarStereographicA;
import org.apache.sis.internal.referencing.provider.TransverseMercator;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.Builder;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public final class GeodeticObjectBuilder
extends Builder<GeodeticObjectBuilder> {
    private GeodeticDatum datum;
    private String conversionName;
    private OperationMethod method;
    private ParameterValueGroup parameters;
    private final ReferencingFactoryContainer factories;
    private final Locale locale;

    public GeodeticObjectBuilder() {
        this((Locale)null);
    }

    public GeodeticObjectBuilder(Locale locale) {
        this.factories = new ReferencingFactoryContainer();
        this.locale = locale;
    }

    public GeodeticObjectBuilder(ReferencingFactoryContainer referencingFactoryContainer, Locale locale) {
        this.factories = referencingFactoryContainer;
        this.locale = locale;
    }

    private static Map<String, Object> name(IdentifiedObject identifiedObject) {
        return Collections.singletonMap("name", identifiedObject.getName());
    }

    public GeodeticObjectBuilder setDomainOfValidity(CharSequence charSequence, double d, double d2, double d3, double d4) {
        DefaultGeographicBoundingBox defaultGeographicBoundingBox = new DefaultGeographicBoundingBox(d, d2, d3, d4);
        if (defaultGeographicBoundingBox.isEmpty()) {
            defaultGeographicBoundingBox = null;
        }
        if (charSequence != null || defaultGeographicBoundingBox != null) {
            DefaultExtent defaultExtent = new DefaultExtent(charSequence, defaultGeographicBoundingBox, null, null);
            this.properties.put("domainOfValidity", defaultExtent);
        }
        return this;
    }

    public GeodeticObjectBuilder setFlattenedSphere(String string, double d, double d2, Unit<Length> unit) throws FactoryException {
        DatumFactory datumFactory = this.factories.getDatumFactory();
        Ellipsoid ellipsoid = datumFactory.createFlattenedSphere(Collections.singletonMap("name", string), d, d2, unit);
        this.datum = datumFactory.createGeodeticDatum(GeodeticObjectBuilder.name((IdentifiedObject)ellipsoid), ellipsoid, CommonCRS.WGS84.primeMeridian());
        return this;
    }

    public GeodeticObjectBuilder setConversionMethod(String string) throws FactoryException {
        if (this.method != null) {
            throw new IllegalStateException(Errors.getResources(this.locale).getString((short)27, "OperationMethod"));
        }
        this.method = this.factories.getCoordinateOperationFactory().getOperationMethod(string);
        this.parameters = this.method.getParameters().createValue();
        return this;
    }

    public GeodeticObjectBuilder setConversionName(String string) {
        this.conversionName = string;
        return this;
    }

    public GeodeticObjectBuilder setConversion(ParameterValueGroup parameterValueGroup) throws FactoryException {
        ArgumentChecks.ensureNonNull("parameters", parameterValueGroup);
        this.method = this.factories.getCoordinateOperationFactory().getOperationMethod(parameterValueGroup.getDescriptor().getName().getCode());
        this.parameters = parameterValueGroup;
        return this;
    }

    private void ensureConversionMethodSet() {
        if (this.parameters == null) {
            throw new IllegalStateException(Resources.forLocale(this.locale).getString((short)70));
        }
    }

    public GeodeticObjectBuilder setParameter(String string, double d, Unit<?> unit) throws IllegalStateException, ParameterNotFoundException, InvalidParameterValueException {
        this.ensureConversionMethodSet();
        this.parameters.parameter(string).setValue(d, unit);
        return this;
    }

    public GeodeticObjectBuilder setTransverseMercator(TransverseMercator.Zoner zoner, double d, double d2) throws FactoryException {
        ArgumentChecks.ensureBetween("latitude", -90.0, 90.0, d);
        ArgumentChecks.ensureBetween("longitude", -4.052915431398935E8, 4.052915431398935E8, d2);
        this.setConversionMethod("Transverse Mercator");
        this.setConversionName(zoner.setParameters(this.parameters, d, d2));
        return this;
    }

    public GeodeticObjectBuilder setPolarStereographic(boolean bl) throws FactoryException {
        this.setConversionMethod("Polar Stereographic (variant A)");
        this.setConversionName(PolarStereographicA.setParameters(this.parameters, bl));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectedCRS createProjectedCRS(GeographicCRS geographicCRS, CartesianCS cartesianCS) throws FactoryException {
        this.ensureConversionMethodSet();
        this.onCreate(false);
        try {
            String string = this.conversionName != null ? this.properties.put("name", this.conversionName) : null;
            Object v = this.properties.put("alias", null);
            Object v2 = this.properties.put("identifiers", null);
            Conversion conversion = this.factories.getCoordinateOperationFactory().createDefiningConversion(this.properties, this.method, this.parameters);
            this.properties.put("identifiers", v2);
            this.properties.put("alias", v);
            if (string != null) {
                this.properties.put("name", string);
            }
            ProjectedCRS projectedCRS = this.factories.getCRSFactory().createProjectedCRS(this.properties, geographicCRS, conversion, cartesianCS);
            return projectedCRS;
        }
        finally {
            this.onCreate(true);
        }
    }

    public ProjectedCRS createProjectedCRS() throws FactoryException {
        GeographicCRS geographicCRS = CommonCRS.WGS84.geographic();
        if (this.datum != null) {
            geographicCRS = this.factories.getCRSFactory().createGeographicCRS(GeodeticObjectBuilder.name((IdentifiedObject)this.datum), this.datum, geographicCRS.getCoordinateSystem());
        }
        return this.createProjectedCRS(geographicCRS, this.factories.getStandardProjectedCS());
    }

    public GeographicCRS createGeographicCRS(boolean bl) throws FactoryException {
        GeographicCRS geographicCRS;
        GeographicCRS geographicCRS2 = geographicCRS = bl ? CommonCRS.WGS84.geographic() : CommonCRS.defaultGeographic();
        if (this.datum != null) {
            this.properties.putIfAbsent("name", this.datum.getName());
        }
        return this.factories.getCRSFactory().createGeographicCRS(this.properties, this.datum, geographicCRS.getCoordinateSystem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporalCRS createTemporalCRS(Date date, Unit<Time> unit) throws FactoryException {
        TimeCS timeCS = null;
        TemporalDatum temporalDatum = null;
        for (CommonCRS.Temporal temporal : CommonCRS.Temporal.values()) {
            TimeCS timeCS2;
            TemporalDatum temporalDatum2;
            if (temporalDatum == null && date.equals((temporalDatum2 = temporal.datum()).getOrigin())) {
                temporalDatum = temporalDatum2;
            }
            if (timeCS != null || !unit.equals((timeCS2 = (temporalDatum2 = temporal.crs()).getCoordinateSystem()).getAxis(0).getUnit())) continue;
            if (temporalDatum == timeCS2 && this.properties.isEmpty()) {
                return temporalDatum2;
            }
            timeCS = timeCS2;
        }
        this.onCreate(false);
        try {
            if (timeCS == null) {
                CSFactory cSFactory = this.factories.getCSFactory();
                timeCS = CommonCRS.Temporal.JAVA.crs().getCoordinateSystem();
                timeCS = cSFactory.createTimeCS(GeodeticObjectBuilder.name((IdentifiedObject)timeCS), cSFactory.createCoordinateSystemAxis(GeodeticObjectBuilder.name((IdentifiedObject)timeCS.getAxis(0)), "t", AxisDirection.FUTURE, unit));
            }
            if (this.properties.get("name") == null) {
                this.properties.putAll(GeodeticObjectBuilder.name((IdentifiedObject)timeCS));
            }
            if (temporalDatum == null) {
                Object v = this.properties.remove("remarks");
                Object v2 = this.properties.remove("identifiers");
                temporalDatum = this.factories.getDatumFactory().createTemporalDatum(this.properties, date);
                this.properties.put("identifiers", v2);
                this.properties.put("remarks", v);
                this.properties.put("name", temporalDatum.getName());
            }
            TemporalCRS temporalCRS = this.factories.getCRSFactory().createTemporalCRS(this.properties, temporalDatum, timeCS);
            return temporalCRS;
        }
        finally {
            this.onCreate(true);
        }
    }

    public CoordinateReferenceSystem createCompoundCRS(CoordinateReferenceSystem ... coordinateReferenceSystemArray) throws FactoryException {
        return new EllipsoidalHeightCombiner(this.factories).createCompoundCRS(this.properties, coordinateReferenceSystemArray);
    }

    public CoordinateReferenceSystem replaceComponent(CoordinateReferenceSystem coordinateReferenceSystem, int n, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        int n2 = ReferencingUtilities.getDimension(coordinateReferenceSystem);
        int n3 = ReferencingUtilities.getDimension(coordinateReferenceSystem2);
        if (n == 0 && n2 == n3) {
            return coordinateReferenceSystem2;
        }
        ArgumentChecks.ensureValidIndex(n2 - n3, n);
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            CoordinateReferenceSystem[] coordinateReferenceSystemArray = CollectionsExt.toArray(((CompoundCRS)coordinateReferenceSystem).getComponents(), CoordinateReferenceSystem.class);
            int n4 = 0;
            for (int i = 0; i < coordinateReferenceSystemArray.length; ++i) {
                CoordinateReferenceSystem coordinateReferenceSystem3 = coordinateReferenceSystemArray[i];
                if (n >= n4) {
                    Object object = this.properties.remove("name");
                    Object v = this.properties.remove("alias");
                    Object v2 = this.properties.remove("identifiers");
                    CoordinateReferenceSystem coordinateReferenceSystem4 = this.replaceComponent(coordinateReferenceSystem3, n - n4, coordinateReferenceSystem2);
                    if (object == null) {
                        object = coordinateReferenceSystem.getName();
                    }
                    this.properties.put("name", object);
                    this.properties.put("alias", v);
                    this.properties.put("identifiers", v2);
                    if (coordinateReferenceSystem4 == coordinateReferenceSystem3) {
                        return coordinateReferenceSystem;
                    }
                    coordinateReferenceSystemArray[i] = coordinateReferenceSystem4;
                    return this.createCompoundCRS(coordinateReferenceSystemArray);
                }
                n4 += ReferencingUtilities.getDimension(coordinateReferenceSystem3);
            }
        }
        throw new IllegalArgumentException(Resources.forLocale(this.locale).getString((short)84, IdentifiedObjects.getName((IdentifiedObject)coordinateReferenceSystem, null)));
    }
}

