/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import javax.measure.Unit;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class WraparoundAdjustment {
    private Envelope domainOfValidity;
    private final MathTransform domainToAOI;
    private final MathTransform domainToAny;
    private MathTransform geographicToAOI;
    private CoordinateReferenceSystem crs;
    private boolean isDomainTransformed;
    private boolean isResultTransformed;

    public WraparoundAdjustment(Envelope envelope, MathTransform mathTransform, MathTransform mathTransform2) {
        this.domainOfValidity = envelope;
        this.domainToAOI = mathTransform;
        this.domainToAny = mathTransform2;
    }

    static double range(CoordinateSystem coordinateSystem, int n) {
        CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(n);
        if (coordinateSystemAxis != null && RangeMeaning.WRAPAROUND.equals((Object)coordinateSystemAxis.getRangeMeaning())) {
            double d = coordinateSystemAxis.getMaximumValue() - coordinateSystemAxis.getMinimumValue();
            if (d > 0.0 && d != Double.POSITIVE_INFINITY) {
                return d;
            }
            AxisDirection axisDirection = AxisDirections.absolute(coordinateSystemAxis.getDirection());
            if (AxisDirection.EAST.equals((Object)axisDirection) && coordinateSystem instanceof EllipsoidalCS) {
                d = 360.0;
                Unit unit = coordinateSystemAxis.getUnit();
                if (unit != null) {
                    d = Units.DEGREE.getConverterTo(Units.ensureAngular(unit)).convert(d);
                }
                return d;
            }
        }
        return Double.NaN;
    }

    private boolean setIfNonNull(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem == null) {
            assert (this.domainToAOI == null || this.domainToAOI.isIdentity());
            coordinateReferenceSystem = this.domainOfValidity.getCoordinateReferenceSystem();
            if (coordinateReferenceSystem == null) {
                return false;
            }
        }
        this.crs = coordinateReferenceSystem;
        return true;
    }

    private boolean replaceCRS() {
        if (this.crs instanceof ProjectedCRS) {
            ProjectedCRS projectedCRS = (ProjectedCRS)this.crs;
            this.crs = projectedCRS.getBaseCRS();
            this.geographicToAOI = projectedCRS.getConversionFromBase().getMathTransform();
            return true;
        }
        return false;
    }

    private void transformDomainToAOI() throws TransformException {
        if (!this.isDomainTransformed) {
            this.isDomainTransformed = true;
            MathTransform mathTransform = this.domainToAOI;
            if (mathTransform == null) {
                mathTransform = this.geographicToAOI;
            } else if (this.geographicToAOI != null) {
                mathTransform = MathTransforms.concatenate(mathTransform, this.geographicToAOI.inverse());
            }
            if (mathTransform != null && !mathTransform.isIdentity()) {
                this.domainOfValidity = Envelopes.transform(mathTransform, this.domainOfValidity);
            }
        }
    }

    private MathTransform toFinal() throws TransformException {
        MathTransform mathTransform = this.domainToAny;
        if (this.isResultTransformed && this.geographicToAOI != null) {
            mathTransform = MathTransforms.concatenate(this.geographicToAOI, mathTransform);
        }
        return mathTransform;
    }

    public GeneralEnvelope shift(Envelope envelope) throws TransformException {
        if (this.setIfNonNull(envelope.getCoordinateReferenceSystem())) {
            DirectPosition directPosition;
            DirectPosition directPosition2;
            GeneralEnvelope generalEnvelope;
            if (this.replaceCRS()) {
                generalEnvelope = Envelopes.transform(this.geographicToAOI.inverse(), envelope);
                directPosition2 = generalEnvelope.getLowerCorner();
                directPosition = generalEnvelope.getUpperCorner();
            } else {
                generalEnvelope = null;
                directPosition2 = envelope.getLowerCorner();
                directPosition = envelope.getUpperCorner();
            }
            CoordinateSystem coordinateSystem = this.crs.getCoordinateSystem();
            int n = coordinateSystem.getDimension();
            while (--n >= 0) {
                boolean bl;
                double d;
                double d2 = WraparoundAdjustment.range(coordinateSystem, n);
                if (!(d2 > 0.0)) continue;
                this.transformDomainToAOI();
                double d3 = directPosition2.getOrdinate(n);
                double d4 = directPosition.getOrdinate(n);
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = d4 - d3;
                if (MathFunctions.isNegative(d7)) {
                    d = d7 == 0.0 ? -1.0 : Math.floor(d7 / d2);
                    if (Math.abs(d3 + (d7 = d * d2)) < Math.abs(d4 - d7)) {
                        d5 = d;
                    } else {
                        d6 = -d;
                    }
                }
                d = this.domainOfValidity.getMinimum(n);
                double d8 = this.domainOfValidity.getMaximum(n);
                double d9 = (d - d3) / d2 - d5;
                double d10 = (d8 - d4) / d2 - d6;
                boolean bl2 = d9 > 0.0;
                boolean bl3 = bl = d10 < 0.0;
                if (bl2 != bl) {
                    double d11;
                    double d12 = (d - d4) / d2 - d6;
                    double d13 = (d8 - d3) / d2 - d5;
                    if (bl2) {
                        d11 = Math.min(Math.floor(d13), Math.max(Math.floor(d9), Math.ceil(d12)));
                        d6 = d11 + 1.0 < d13 ? (d6 += Math.ceil(d10)) : (d6 += d11);
                        d5 += d11;
                    } else {
                        d11 = Math.max(Math.ceil(d12), Math.min(Math.ceil(d10), Math.floor(d13)));
                        d5 = d11 - 1.0 > d12 ? (d5 += Math.floor(d9)) : (d5 += d11);
                        d6 += d11;
                    }
                }
                if (d5 == 0.0 && d6 == 0.0) continue;
                this.isResultTransformed = true;
                if (generalEnvelope == null) {
                    generalEnvelope = new GeneralEnvelope(envelope);
                }
                envelope = generalEnvelope;
                generalEnvelope.setRange(n, d3 + d5 * d2, d4 + d6 * d2);
            }
        }
        return Envelopes.transform(this.toFinal(), envelope);
    }

    public DirectPosition shift(DirectPosition directPosition) throws TransformException {
        if (this.setIfNonNull(directPosition.getCoordinateReferenceSystem())) {
            DirectPosition directPosition2 = this.replaceCRS() ? this.geographicToAOI.inverse().transform(directPosition, null) : directPosition;
            CoordinateSystem coordinateSystem = this.crs.getCoordinateSystem();
            int n = coordinateSystem.getDimension();
            while (--n >= 0) {
                double d = WraparoundAdjustment.range(coordinateSystem, n);
                if (!(d > 0.0)) continue;
                this.transformDomainToAOI();
                double d2 = directPosition2.getOrdinate(n);
                double d3 = this.domainOfValidity.getMinimum(n) - d2;
                if (d3 > 0.0) {
                    d3 = Math.ceil(d3 / d);
                } else {
                    d3 = this.domainOfValidity.getMaximum(n) - d2;
                    if (!(d3 < 0.0)) continue;
                    d3 = Math.floor(d3 / d);
                }
                if (d3 == 0.0) continue;
                this.isResultTransformed = true;
                if (directPosition2 == directPosition) {
                    directPosition2 = new GeneralDirectPosition(directPosition);
                }
                directPosition = directPosition2;
                directPosition2.setOrdinate(n, d2 + d3 * d);
            }
        }
        return this.toFinal().transform(directPosition, null);
    }
}

