/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.ObliqueMercatorCenter;
import org.apache.sis.internal.referencing.provider.ObliqueMercatorTwoPoints;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Angle;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.ConformalProjection;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;

public class ObliqueMercator
extends ConformalProjection {
    private static final long serialVersionUID = -5289761492678147674L;
    private static final byte CENTER = 1;
    private static final byte TWO_POINTS = 2;
    private final double B;
    private final double H;
    private final double sin\u03b30;
    private final double cos\u03b30;

    private static byte getVariant(OperationMethod operationMethod) {
        if (ObliqueMercator.identMatch(operationMethod, "(?i).*\\bvariant\\s*A\\b.*", "9812")) {
            return 0;
        }
        if (ObliqueMercator.identMatch(operationMethod, "(?i).*\\bvariant\\s*B\\b.*", "9815")) {
            return 1;
        }
        if (ObliqueMercator.identMatch(operationMethod, "(?i).*\\bTwo[_\\s]Point[_\\s]Natural\\b.*", null)) {
            return 2;
        }
        if (ObliqueMercator.identMatch(operationMethod, "(?i).*\\bTwo[_\\s]Point[_\\s]Center\\b.*", null)) {
            return 3;
        }
        return 0;
    }

    public ObliqueMercator(OperationMethod operationMethod, Parameters parameters) {
        this(ObliqueMercator.initializer(operationMethod, parameters));
    }

    private static Initializer initializer(OperationMethod operationMethod, Parameters parameters) {
        byte by = ObliqueMercator.getVariant(operationMethod);
        boolean bl = (by & 1) != 0;
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor> enumMap = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor>(NormalizedProjection.ParameterRole.class);
        enumMap.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, ObliqueMercatorCenter.SCALE_FACTOR);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_EASTING, bl ? ObliqueMercatorCenter.EASTING_AT_CENTRE : ObliqueMercatorCenter.FALSE_EASTING);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, bl ? ObliqueMercatorCenter.NORTHING_AT_CENTRE : ObliqueMercatorCenter.FALSE_NORTHING);
        return new Initializer(operationMethod, parameters, enumMap, by);
    }

    private ObliqueMercator(Initializer initializer) {
        super(initializer);
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8 = Math.toRadians(initializer.getAndStore((ParameterDescriptor<? extends Number>)ObliqueMercatorCenter.LONGITUDE_OF_CENTRE));
        double d9 = Math.toRadians(initializer.getAndStore((ParameterDescriptor<? extends Number>)ObliqueMercatorCenter.LATITUDE_OF_CENTRE));
        double d10 = Math.sin(d9);
        double d11 = Math.cos(d9);
        double d12 = d11 * d11;
        this.B = Math.sqrt(1.0 + this.eccentricitySquared * (d12 * d12) / (1.0 - this.eccentricitySquared));
        double d13 = this.B * initializer.axisLengthRatio().doubleValue();
        double d14 = initializer.r\u03bd2(d10).doubleValue();
        double d15 = d13 / d14;
        double d16 = d13 / (d11 * Math.sqrt(d14));
        double d17 = Math.sqrt(Math.max(d16 * d16 - 1.0, 0.0));
        double d18 = d16 + Math.copySign(d17, d9);
        this.H = d18 * Math.pow(this.exp\u03a8(d9, this.eccentricity * d10), -this.B);
        if ((initializer.variant & 2) == 0) {
            d7 = initializer.getAndStore((ParameterDescriptor<? extends Number>)ObliqueMercatorCenter.AZIMUTH);
            d6 = Math.toRadians(initializer.getAndStore((ParameterDescriptor<Double>)ObliqueMercatorCenter.RECTIFIED_GRID_ANGLE, d7));
            d5 = Math.asin(Math.sin(d7 = Math.toRadians(d7)) / d16);
            d4 = (d18 - 1.0 / d18) * 0.5 * Math.tan(d5);
            d3 = Math.abs(d4);
            if (d3 > 1.0 && d3 <= 1.0000000015706707) {
                d4 = Math.copySign(1.0, d4);
            }
            if (Double.isNaN(d2 = d8 - Math.asin(d4) / this.B)) {
                String string = ObliqueMercatorCenter.AZIMUTH.getName().getCode();
                Angle angle = new Angle(Math.toDegrees(d7));
                throw new InvalidParameterValueException(Resources.format((short)25, string, angle), string, (Object)angle);
            }
        } else {
            d4 = Math.toRadians(initializer.getAndStore(ObliqueMercatorTwoPoints.LAT_OF_1ST_POINT));
            d3 = Math.toRadians(initializer.getAndStore(ObliqueMercatorTwoPoints.LAT_OF_2ND_POINT));
            d = Math.toRadians(initializer.getAndStore(ObliqueMercatorTwoPoints.LONG_OF_1ST_POINT));
            double d19 = Math.toRadians(initializer.getAndStore(ObliqueMercatorTwoPoints.LONG_OF_2ND_POINT));
            double d20 = Math.pow(this.exp\u03a8(d4, Math.sin(this.eccentricity * d4)), -this.B);
            double d21 = Math.pow(this.exp\u03a8(d3, Math.sin(this.eccentricity * d3)), -this.B);
            double d22 = this.H * this.H;
            double d23 = d21 * d20;
            double d24 = (d22 - d23) / (d22 + d23);
            double d25 = (d21 - d20) / (d21 + d20);
            double d26 = d - d19;
            if (Math.abs(d26) > Math.PI) {
                d19 += Math.copySign(Math.PI * 2, d26);
                d26 = d - d19;
            }
            if (Math.abs(d26 = d - (d2 = (d + d19) / 2.0 - Math.atan(d24 * Math.tan(this.B * d26 / 2.0) / d25) / this.B)) > Math.PI) {
                d2 += Math.copySign(Math.PI * 2, d26);
                d26 = d - d2;
            }
            d5 = Math.atan(2.0 * Math.sin(this.B * d26) / (this.H / d20 - d20 / this.H));
            d7 = d6 = Math.asin(d16 * Math.sin(d5));
        }
        this.sin\u03b30 = Math.sin(d5);
        this.cos\u03b30 = Math.cos(d5);
        this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION).convertAfter(0, null, -d2);
        MatrixSIS matrixSIS = this.getContextualParameters().getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        Matrix3 matrix3 = new Matrix3();
        matrix3.m00 = matrix3.m11 = Math.cos(d6);
        matrix3.m01 = Math.sin(d6);
        matrix3.m10 = -matrix3.m01;
        matrixSIS.setMatrix(matrixSIS.multiply(matrix3));
        d3 = d15 / this.B;
        if ((initializer.variant & 1) != 0) {
            d = Math.abs(Math.abs(d7) - 1.5707963267948966) < 1.5706706731410455E-9 ? d15 * (d8 - d2) : d3 * Math.atan2(d17, Math.cos(d7));
            matrixSIS.convertBefore(1, null, -Math.copySign(d, d9));
        }
        matrixSIS.convertBefore(0, d3, null);
        matrixSIS.convertBefore(1, d3, null);
    }

    @Override
    final String[] getInternalParameterNames() {
        return new String[]{"B", "H", "\u03b3\u2080"};
    }

    @Override
    final double[] getInternalParameterValues() {
        return new double[]{this.B, this.H, this.\u03b30()};
    }

    private double \u03b30() {
        return Math.abs(this.sin\u03b30) < Math.abs(this.cos\u03b30) ? Math.asin(this.sin\u03b30) : Math.acos(this.cos\u03b30);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = Math.sin(d2);
        double d4 = this.H * Math.pow(this.exp\u03a8(d2, this.eccentricity * d3), this.B);
        double d5 = 1.0 / d4;
        double d6 = (d4 - d5) * 0.5;
        double d7 = (d4 + d5) * 0.5;
        double d8 = Math.sin(this.B * d);
        double d9 = (d6 * this.sin\u03b30 - d8 * this.cos\u03b30) / d7;
        double d10 = Math.cos(this.B * d);
        if (dArray2 != null) {
            dArray2[n2] = MathFunctions.atanh(-d9);
            dArray2[n2 + 1] = Math.atan2(d6 * this.cos\u03b30 + d8 * this.sin\u03b30, d10);
        }
        if (!bl) {
            return null;
        }
        double d11 = this.B * d4 * this.dy_d\u03c6(d3, Math.cos(d2));
        double d12 = -this.B * (this.cos\u03b30 / d7) * d10;
        double d13 = d11 * (this.sin\u03b30 + (this.sin\u03b30 + d9) / (d4 * d4) - d9) / (2.0 * d7);
        double d14 = 0.5 * d11 * (1.0 + 1.0 / (d4 * d4));
        double d15 = d6 * this.cos\u03b30 + d8 * this.sin\u03b30;
        double d16 = Math.hypot(d10, d15);
        double d17 = d16 + d10;
        double d18 = d17 * d17 + d15 * d15;
        double d19 = 2.0 * this.B * (d10 * (this.sin\u03b30 * d17 + (d8 - this.sin\u03b30 * d15) * d15 / d16) + d8 * d15) / d18;
        double d20 = 2.0 * this.cos\u03b30 * d14 * (d17 - d15 * d15 / d16) / d18;
        double d21 = d9 * d9 - 1.0;
        return new Matrix2(d12 / d21, d13 / d21, d19, d20);
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = Math.exp(-d);
        double d4 = 1.0 / d3;
        double d5 = (d3 - d4) * 0.5;
        double d6 = (d3 + d4) * 0.5;
        double d7 = Math.sin(d2);
        double d8 = (d7 * this.cos\u03b30 + d5 * this.sin\u03b30) / d6;
        double d9 = -Math.atan2(d5 * this.cos\u03b30 - d7 * this.sin\u03b30, Math.cos(d2)) / this.B;
        double d10 = this.\u03c6(Math.pow(this.H / Math.sqrt((1.0 + d8) / (1.0 - d8)), 1.0 / this.B));
        dArray2[n2] = d9;
        dArray2[n2 + 1] = d10;
    }
}

