/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;

class MathTransformsOrFactory {
    private static final MathTransformsOrFactory INSTANCE = new MathTransformsOrFactory();

    private MathTransformsOrFactory() {
    }

    static MathTransformsOrFactory wrap(MathTransformFactory mathTransformFactory) {
        return mathTransformFactory != null ? new Specified(mathTransformFactory) : INSTANCE;
    }

    MathTransform linear(Matrix matrix) throws FactoryException {
        return MathTransforms.linear(matrix);
    }

    MathTransform passThrough(int n, MathTransform mathTransform, int n2) throws FactoryException {
        return MathTransforms.passThrough(n, mathTransform, n2);
    }

    MathTransform concatenate(MathTransform mathTransform, MathTransform mathTransform2) throws FactoryException {
        return MathTransforms.concatenate(mathTransform, mathTransform2);
    }

    final MathTransform concatenate(boolean bl, MathTransform mathTransform, MathTransform mathTransform2) throws FactoryException {
        if (bl) {
            return this.concatenate(mathTransform2, mathTransform);
        }
        return this.concatenate(mathTransform, mathTransform2);
    }

    private static final class Specified
    extends MathTransformsOrFactory {
        private final MathTransformFactory factory;

        Specified(MathTransformFactory mathTransformFactory) {
            this.factory = mathTransformFactory;
        }

        @Override
        MathTransform linear(Matrix matrix) throws FactoryException {
            return this.factory.createAffineTransform(matrix);
        }

        @Override
        MathTransform passThrough(int n, MathTransform mathTransform, int n2) throws FactoryException {
            return this.factory.createPassThroughTransform(n, mathTransform, n2);
        }

        @Override
        MathTransform concatenate(MathTransform mathTransform, MathTransform mathTransform2) throws FactoryException {
            return this.factory.createConcatenatedTransform(mathTransform, mathTransform2);
        }
    }
}

