/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.query;

import java.util.stream.Stream;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.internal.storage.AbstractFeatureSet;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.query.SimpleQuery;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.event.StoreListeners;

final class FeatureSubset
extends AbstractFeatureSet {
    private final FeatureSet source;
    private final SimpleQuery query;
    private DefaultFeatureType resultType;

    FeatureSubset(FeatureSet featureSet, SimpleQuery simpleQuery) {
        super(featureSet instanceof StoreListeners ? (StoreListeners)((Object)featureSet) : null);
        this.source = featureSet;
        this.query = simpleQuery;
    }

    @Override
    public synchronized DefaultFeatureType getType() throws DataStoreException {
        if (this.resultType == null) {
            DefaultFeatureType defaultFeatureType = this.source.getType();
            try {
                this.resultType = this.query.expectedType(defaultFeatureType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new DataStoreContentException(Resources.forLocale(this.getLocale()).getString((short)55, defaultFeatureType.getName()), illegalArgumentException);
            }
        }
        return this.resultType;
    }

    @Override
    public Stream<AbstractFeature> features(boolean bl) throws DataStoreException {
        long l;
        Stream<AbstractFeature> stream = this.source.features(bl);
        long l2 = this.query.getOffset();
        if (l2 > 0L) {
            stream = stream.skip(l2);
        }
        if ((l = this.query.getLimit()) >= 0L) {
            stream = stream.limit(l);
        }
        return stream;
    }
}

