/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.wkt;

import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.referencing.DefinitionVerifier;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.referencing.CRS;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArraysExt;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

public final class StoreFormat
extends WKTFormat {
    private final GeometryLibrary library;
    private final StoreListeners listeners;

    public StoreFormat(GeometryLibrary geometryLibrary, StoreListeners storeListeners) {
        super(null, null);
        this.library = geometryLibrary;
        this.listeners = storeListeners;
    }

    public Geometry parseGeometry(String string, String string2, String string3) {
        if (string != null) {
            try {
                Object object = Geometries.implementation(this.library).parseWKT(string);
                GeneralEnvelope generalEnvelope = Geometries.getEnvelope(string);
                if (generalEnvelope != null) {
                    generalEnvelope.setCoordinateReferenceSystem(this.parseCRS(string2, string3));
                    return new GeometryWrapper(object, (Envelope)generalEnvelope);
                }
            }
            catch (Exception exception) {
                this.log(exception);
            }
        }
        return null;
    }

    public CoordinateReferenceSystem parseCRS(String ... stringArray) {
        try {
            CoordinateReferenceSystem[] coordinateReferenceSystemArray = new CoordinateReferenceSystem[stringArray.length];
            int n = 0;
            for (String string : stringArray) {
                if (string == null) continue;
                Object object = this.parseObject(string);
                this.validate(object);
                coordinateReferenceSystemArray[n++] = (CoordinateReferenceSystem)object;
            }
            if (n != 0) {
                return CRS.compound((CoordinateReferenceSystem[])ArraysExt.resize(coordinateReferenceSystemArray, n));
            }
        }
        catch (ClassCastException | IllegalArgumentException | ParseException | FactoryException throwable) {
            this.log((Exception)throwable);
        }
        return null;
    }

    public void validate(Object object) {
        Warnings warnings = this.getWarnings();
        if (warnings != null) {
            this.log(new LogRecord(Level.WARNING, warnings.toString()));
        }
        if (object instanceof CoordinateReferenceSystem) {
            try {
                LogRecord logRecord;
                DefinitionVerifier definitionVerifier = DefinitionVerifier.withAuthority((CoordinateReferenceSystem)((CoordinateReferenceSystem)object), null, (boolean)false);
                if (definitionVerifier != null && (logRecord = definitionVerifier.warning(false)) != null) {
                    this.log(logRecord);
                }
            }
            catch (FactoryException factoryException) {
                this.listeners.warning((Exception)((Object)factoryException));
            }
        }
    }

    private void log(Exception exception) {
        this.listeners.warning(Resources.forLocale(this.listeners.getLocale()).getString((short)37, this.listeners.getSourceName()), exception);
    }

    private void log(LogRecord logRecord) {
        logRecord.setSourceClassName(this.listeners.getSource().getClass().getName());
        logRecord.setSourceMethodName("getMetadata");
        logRecord.setLoggerName("org.apache.sis.io.wkt");
        this.listeners.warning(logRecord);
    }
}

