/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.math.Vector;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.Classes;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class JTS
extends Geometries<Geometry> {
    private final GeometryFactory factory = new GeometryFactory();

    JTS() {
        super(GeometryLibrary.JTS, Geometry.class, Point.class, LineString.class, Polygon.class);
    }

    @Override
    public Object parseWKT(String string) throws ParseException {
        return new WKTReader(this.factory).read(string);
    }

    @Override
    final String tryFormatWKT(Object object, double d) {
        return object instanceof Geometry ? ((Geometry)object).toText() : null;
    }

    @Override
    final String tryGetLabel(Object object) {
        return object instanceof Geometry ? Classes.getShortClassName(object) : null;
    }

    @Override
    final GeneralEnvelope tryGetEnvelope(Object object) {
        if (object instanceof Geometry) {
            Envelope envelope = ((Geometry)object).getEnvelopeInternal();
            GeneralEnvelope generalEnvelope = new GeneralEnvelope(2);
            generalEnvelope.setRange(0, envelope.getMinX(), envelope.getMaxX());
            generalEnvelope.setRange(1, envelope.getMinY(), envelope.getMaxY());
            if (!generalEnvelope.isEmpty()) {
                return generalEnvelope;
            }
        }
        return null;
    }

    @Override
    final double[] tryGetCoordinate(Object object) {
        double[] dArray;
        Coordinate coordinate;
        if (object instanceof Point) {
            coordinate = ((Point)object).getCoordinate();
        } else if (object instanceof Coordinate) {
            coordinate = (Coordinate)object;
        } else {
            return null;
        }
        double d = coordinate.getZ();
        if (Double.isNaN(d)) {
            dArray = new double[2];
        } else {
            dArray = new double[3];
            dArray[2] = d;
        }
        dArray[1] = coordinate.y;
        dArray[0] = coordinate.x;
        return dArray;
    }

    @Override
    final CoordinateReferenceSystem tryGetCoordinateReferenceSystem(Object object) throws FactoryException {
        if (object instanceof Geometry) {
            return org.apache.sis.internal.feature.jts.JTS.getCoordinateReferenceSystem((Geometry)object);
        }
        return super.tryGetCoordinateReferenceSystem(object);
    }

    private static void copyMetadata(Geometry geometry, Geometry geometry2) {
        geometry2.setSRID(geometry.getSRID());
        Object object = geometry.getUserData();
        if (!(object instanceof CoordinateReferenceSystem)) {
            if (!(object instanceof Map)) {
                return;
            }
            if (!((object = ((Map)object).get("CRS")) instanceof CoordinateReferenceSystem)) {
                return;
            }
        }
        geometry2.setUserData(object);
    }

    @Override
    final Object tryGetCentroid(Object object) {
        if (object instanceof Geometry) {
            Geometry geometry = (Geometry)object;
            Point point = geometry.getCentroid();
            JTS.copyMetadata(geometry, (Geometry)point);
            return point;
        }
        return null;
    }

    @Override
    public Object createPoint(double d, double d2) {
        return this.factory.createPoint(new Coordinate(d, d2));
    }

    @Override
    public Geometry createPolyline(int n, Vector ... vectorArray) {
        boolean bl;
        boolean bl2 = bl = n == 3;
        if (!bl && n != 2) {
            throw new UnsupportedOperationException(JTS.unsupported(n));
        }
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>(32);
        ArrayList<LineString> arrayList2 = new ArrayList<LineString>();
        for (Vector vector : vectorArray) {
            if (vector == null) continue;
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                double d = vector.doubleValue(n3++);
                double d2 = vector.doubleValue(n3++);
                if (!Double.isNaN(d) && !Double.isNaN(d2)) {
                    Coordinate coordinate = bl ? new Coordinate(d, d2, vector.doubleValue(n3++)) : new Coordinate(d, d2);
                    arrayList.add(coordinate);
                    continue;
                }
                if (bl) {
                    ++n3;
                }
                this.toLineString(arrayList, arrayList2);
                arrayList.clear();
            }
        }
        this.toLineString(arrayList, arrayList2);
        return this.toGeometry(arrayList2);
    }

    private void toLineString(List<Coordinate> list, List<LineString> list2) {
        int n = list.size();
        if (n >= 2) {
            Coordinate[] coordinateArray = list.toArray(new Coordinate[n]);
            Object object = coordinateArray[0].equals2D(coordinateArray[n - 1]) ? this.factory.createLinearRing(coordinateArray) : this.factory.createLineString(coordinateArray);
            list2.add((LineString)object);
        }
    }

    private Geometry toGeometry(List<LineString> list) {
        int n = list.size();
        switch (n) {
            case 0: {
                return this.factory.createLinearRing((Coordinate[])null);
            }
            case 1: {
                return (Geometry)list.get(0);
            }
        }
        return this.factory.createMultiLineString(list.toArray(new LineString[n]));
    }

    @Override
    final Geometry tryMergePolylines(Object object, Iterator<?> iterator) {
        if (!(object instanceof MultiLineString || object instanceof LineString || object instanceof Point)) {
            return null;
        }
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
        ArrayList<LineString> arrayList2 = new ArrayList<LineString>();
        block0: while (true) {
            Geometry geometry;
            if (object instanceof Point) {
                geometry = ((Point)object).getCoordinate();
                if (!Double.isNaN(geometry.x) && !Double.isNaN(geometry.y)) {
                    arrayList.add((Coordinate)geometry);
                } else {
                    this.toLineString(arrayList, arrayList2);
                    arrayList.clear();
                }
            } else {
                geometry = (Geometry)object;
                int n = geometry.getNumGeometries();
                for (int i = 0; i < n; ++i) {
                    LineString lineString = (LineString)geometry.getGeometryN(i);
                    if (arrayList.isEmpty()) {
                        arrayList2.add(lineString);
                        continue;
                    }
                    arrayList.addAll(Arrays.asList(lineString.getCoordinates()));
                    this.toLineString(arrayList, arrayList2);
                    arrayList.clear();
                }
            }
            while (iterator.hasNext()) {
                object = iterator.next();
                if (object == null) continue;
                continue block0;
            }
            break;
        }
        this.toLineString(arrayList, arrayList2);
        return this.toGeometry(arrayList2);
    }

    @Override
    Object tryBuffer(Object object, double d) {
        if (object instanceof Geometry) {
            Geometry geometry = (Geometry)object;
            Geometry geometry2 = geometry.buffer(d);
            JTS.copyMetadata(geometry, geometry2);
            return geometry2;
        }
        return null;
    }

    Geometry tryTransform(Object object, CoordinateOperation coordinateOperation, CoordinateReferenceSystem coordinateReferenceSystem) throws FactoryException, TransformException {
        if (object instanceof Geometry) {
            if (coordinateOperation != null) {
                return org.apache.sis.internal.feature.jts.JTS.transform((Geometry)object, coordinateOperation);
            }
            return org.apache.sis.internal.feature.jts.JTS.transform((Geometry)object, coordinateReferenceSystem);
        }
        return null;
    }
}

