/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.sis.internal.converter.SurjectiveConverter;
import org.apache.sis.internal.metadata.RecordSchemaSIS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.iso.RecordDefinition;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.MemberName;
import org.opengis.util.NameSpace;
import org.opengis.util.Record;
import org.opengis.util.RecordSchema;
import org.opengis.util.RecordType;
import org.opengis.util.Type;
import org.opengis.util.TypeName;

@XmlType(name="RecordType")
public class DefaultRecordType
extends RecordDefinition
implements RecordType,
Serializable {
    private static final long serialVersionUID = -1534515712654429099L;
    private final TypeName typeName;
    private final RecordSchema container;
    private transient Type[] memberTypes;

    public DefaultRecordType(RecordType recordType) {
        this.typeName = recordType.getTypeName();
        this.container = recordType.getContainer();
        this.memberTypes = this.computeTransientFields(recordType.getMemberTypes());
    }

    public DefaultRecordType(TypeName typeName, RecordSchema recordSchema, Map<? extends MemberName, ? extends Type> map) {
        ArgumentChecks.ensureNonNull("typeName", typeName);
        ArgumentChecks.ensureNonNull("container", recordSchema);
        ArgumentChecks.ensureNonNull("members", map);
        this.typeName = typeName;
        this.container = recordSchema;
        this.memberTypes = this.computeTransientFields(map);
        LocalName localName = recordSchema.getSchemaName();
        GenericName genericName = typeName.toFullyQualifiedName();
        if (localName.compareTo(typeName.scope().name().tip()) != 0) {
            throw new IllegalArgumentException(Errors.format((short)68, localName, genericName));
        }
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            MemberName memberName = this.getName(i);
            Type type = this.memberTypes[i];
            if (type == null || memberName.getAttributeType().compareTo(type.getTypeName()) != 0) {
                throw new IllegalArgumentException(Errors.format((short)55, memberName, type));
            }
            if (genericName.compareTo(memberName.scope().name()) == 0) continue;
            throw new IllegalArgumentException(Errors.format((short)68, genericName, memberName.toFullyQualifiedName()));
        }
    }

    DefaultRecordType(TypeName typeName, RecordSchema recordSchema, Map<? extends CharSequence, ? extends Type> map, DefaultNameFactory defaultNameFactory) {
        this.typeName = typeName;
        this.container = recordSchema;
        NameSpace nameSpace = defaultNameFactory.createNameSpace(typeName, null);
        LinkedHashMap<MemberName, Type> linkedHashMap = new LinkedHashMap<MemberName, Type>(Containers.hashMapCapacity(map.size()));
        for (Map.Entry<? extends CharSequence, ? extends Type> entry : map.entrySet()) {
            Type type = entry.getValue();
            CharSequence charSequence = entry.getKey();
            MemberName memberName = defaultNameFactory.createMemberName(nameSpace, charSequence, type.getTypeName());
            if (linkedHashMap.put(memberName, type) == null) continue;
            throw new IllegalArgumentException(Errors.format((short)24, memberName));
        }
        this.memberTypes = this.computeTransientFields(linkedHashMap);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        LinkedHashMap<MemberName, Type> linkedHashMap = new LinkedHashMap<MemberName, Type>(Containers.hashMapCapacity(n));
        for (int i = 0; i < n; ++i) {
            Type type;
            MemberName memberName = (MemberName)objectInputStream.readObject();
            if (linkedHashMap.put(memberName, type = (Type)objectInputStream.readObject()) == null) continue;
            throw new InvalidObjectException(Errors.format((short)24, memberName));
        }
        this.memberTypes = this.computeTransientFields(linkedHashMap);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.size();
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutputStream.writeObject(this.getName(i));
            objectOutputStream.writeObject(this.memberTypes[i]);
        }
    }

    public static DefaultRecordType castOrCopy(RecordType recordType) {
        if (recordType == null || recordType instanceof DefaultRecordType) {
            return (DefaultRecordType)recordType;
        }
        return new DefaultRecordType(recordType);
    }

    @Override
    final RecordType getRecordType() {
        return this;
    }

    @Override
    public TypeName getTypeName() {
        return this.typeName;
    }

    @Override
    public RecordSchema getContainer() {
        return this.container;
    }

    @Override
    public Map<MemberName, Type> getMemberTypes() {
        return ObjectConverters.derivedValues(this.memberIndices(), MemberName.class, new SurjectiveConverter<Integer, Type>(){

            @Override
            public Class<Integer> getSourceClass() {
                return Integer.class;
            }

            @Override
            public Class<Type> getTargetClass() {
                return Type.class;
            }

            @Override
            public Type apply(Integer n) {
                return DefaultRecordType.this.getType(n);
            }
        });
    }

    @Override
    public Set<MemberName> getMembers() {
        return this.memberIndices().keySet();
    }

    final Type getType(int n) {
        return this.memberTypes[n];
    }

    @Override
    public TypeName locate(MemberName memberName) {
        Integer n = this.indexOf(memberName);
        return n != null ? this.getType(n).getTypeName() : null;
    }

    @Override
    public boolean isInstance(Record record) {
        return record != null && this.getMembers().containsAll(record.getAttributes().keySet());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            DefaultRecordType defaultRecordType = (DefaultRecordType)object;
            return Objects.equals(this.typeName, defaultRecordType.typeName) && Objects.equals(this.container, defaultRecordType.container) && Arrays.equals(this.memberTypes, defaultRecordType.memberTypes) && this.memberIndices().equals(defaultRecordType.memberIndices());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.typeName) + 31 * (this.memberIndices().hashCode() + 31 * Arrays.hashCode(this.memberTypes));
    }

    private DefaultRecordType() {
        DefaultRecordType defaultRecordType = RecordSchemaSIS.STRING;
        this.typeName = defaultRecordType.typeName;
        this.container = defaultRecordType.container;
    }

    @XmlValue
    private String getValue() {
        switch (this.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return String.valueOf(this.memberTypes[0]);
            }
        }
        return this.toString(null, null);
    }

    private void setValue(String string) {
        if (string != null) {
            LinkedHashMap<MemberName, Type> linkedHashMap = new LinkedHashMap<MemberName, Type>();
            for (CharSequence charSequence : CharSequences.splitOnEOL(string)) {
                int n = ((String)charSequence).indexOf(58);
                if (n >= 0) {
                    charSequence = charSequence.subSequence(0, CharSequences.skipTrailingWhitespaces(charSequence, 0, n));
                }
                MemberName memberName = Names.createMemberName(null, null, charSequence, String.class);
                linkedHashMap.put(memberName, RecordSchemaSIS.INSTANCE.toAttributeType(String.class));
            }
            this.memberTypes = this.computeTransientFields(linkedHashMap);
        }
    }
}

