/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.text.DecimalFormat;
import java.text.Format;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Statistics;
import org.apache.sis.math.Vector;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Static;

public final class Numerics
extends Static {
    private static final Map<Object, Object> CACHE = new HashMap<Object, Object>(32);
    public static final int MAXIMUM_MATRIX_SIZE = Short.MAX_VALUE;
    public static final double COMPARISON_THRESHOLD = 1.0E-13;
    public static final long SIGN_BIT_MASK = Long.MIN_VALUE;
    public static final int SIGNIFICAND_SIZE = 52;
    public static final int SIGNIFICAND_SIZE_OF_FLOAT = 23;

    private static void cache(double d) {
        Double d2 = d;
        CACHE.put(d2, d2);
        d2 = -d;
        CACHE.put(d2, d2);
    }

    private Numerics() {
    }

    public static long bitmask(int n) {
        return n >= 0 && n < 64 ? 1L << n : 0L;
    }

    public static int ceilDiv(int n, int n2) {
        int n3 = n / n2;
        if ((n ^ n2) >= 0 && n3 * n2 != n) {
            ++n3;
        }
        return n3;
    }

    public static long ceilDiv(long l, long l2) {
        long l3 = l / l2;
        if ((l ^ l2) >= 0L && l3 * l2 != l) {
            ++l3;
        }
        return l3;
    }

    public static long multiplyDivide(long l, long l2, long l3) {
        return Math.multiplyExact(l, l2) / l3;
    }

    public static <T> T cached(T t) {
        return (T)CACHE.getOrDefault(t, t);
    }

    public static Double valueOf(double d) {
        Double d2 = d;
        return (Double)CACHE.getOrDefault(d2, d2);
    }

    public static boolean equals(float f, float f2) {
        return Float.floatToIntBits(f) == Float.floatToIntBits(f2);
    }

    public static boolean equals(double d, double d2) {
        return Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    public static boolean equalsIgnoreZeroSign(double d, double d2) {
        return d == d2 || Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    public static boolean epsilonEqual(double d, double d2, double d3) {
        return Math.abs(d - d2) <= d3 || Numerics.equals(d, d2);
    }

    public static boolean epsilonEqual(double d, double d2, ComparisonMode comparisonMode) {
        double d3;
        if (comparisonMode.isApproximate() && (d3 = Math.max(Math.abs(d), Math.abs(d2))) != Double.POSITIVE_INFINITY) {
            return Numerics.epsilonEqual(d, d2, 1.0E-13 * d3);
        }
        return Numerics.equals(d, d2);
    }

    public static String messageForDifference(String string, double d, double d2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string).append(": ");
        }
        stringBuilder.append("values ").append(d).append(" and ").append(d2).append(" differ");
        float f = (float)Math.abs(d - d2);
        if (f < Float.POSITIVE_INFINITY) {
            stringBuilder.append(" by ").append(f);
        }
        return stringBuilder.toString();
    }

    public static boolean isUnsignedInteger(String string) {
        int n;
        if (string != null && (n = string.length()) != 0) {
            char c;
            int n2 = 0;
            while ((c = string.charAt(n2)) >= '0' && c <= '9') {
                if (++n2 < n) continue;
                return true;
            }
        }
        return false;
    }

    public static float toUnsignedFloat(long l) {
        if (l >= 0L) {
            return l;
        }
        return Float.parseFloat(Long.toUnsignedString(l));
    }

    public static double toUnsignedDouble(long l) {
        if (l >= 0L) {
            return l;
        }
        return Double.parseDouble(Long.toUnsignedString(l));
    }

    public static int toExp10(int n) {
        assert (n >= -2620 && n <= 2620) : n;
        return n * 315653 >> 20;
    }

    public static long getSignificand(double d) {
        long l = Double.doubleToRawLongBits(d);
        long l2 = l & 0x7FF0000000000000L;
        l &= 0xFFFFFFFFFFFFFL;
        l = l2 != 0L ? (l |= 0x10000000000000L) : (l <<= 1);
        return l;
    }

    public static int getSignificand(float f) {
        int n = Float.floatToRawIntBits(f);
        int n2 = n & 0x7F800000;
        n = (int)((long)n & 0x7FFFFFL);
        n = n2 != 0 ? (int)((long)n | 0x800000L) : (n <<= 1);
        return n;
    }

    public static int fractionDigitsForDelta(double d) {
        return d != 0.0 ? Math.max(0, Math.min(16, DecimalFunctions.fractionDigitsForDelta(d, false))) : 0;
    }

    public static int suggestFractionDigits(double ... dArray) {
        double d = 0.0;
        if (dArray != null) {
            for (double d2 : dArray) {
                double d3 = Math.ulp(d2);
                if (!(d3 > d) || d3 == Double.POSITIVE_INFINITY) continue;
                d = d3;
            }
        }
        return Numerics.fractionDigitsForDelta(d);
    }

    public static int suggestFractionDigits(Statistics statistics) {
        double d = statistics.minimum();
        double d2 = statistics.maximum();
        double d3 = statistics.standardDeviation(true);
        if (d3 == 0.0) {
            d3 = statistics.span();
            if (d3 == 0.0) {
                d3 = Math.abs(d2) / 1000000.0;
            }
        } else {
            double d4 = statistics.mean();
            d3 *= 2.0;
            d3 = Math.min(d2, d4 + d3) - Math.max(d, d4 - d3);
            d3 /= Math.min((double)statistics.count() * 100.0, 1000000.0);
            d3 = Math.max(d3, Math.max(Math.ulp(d), Math.ulp(d2)));
        }
        return Numerics.fractionDigitsForDelta(d3);
    }

    public static int[] suggestFractionDigits(Vector[] vectorArray) {
        int n = 0;
        int n2 = vectorArray.length - 1;
        for (int i = 0; i <= n2; ++i) {
            int n3 = vectorArray[i].size();
            if (n3 <= n) continue;
            n = n3;
        }
        int[] nArray = new int[n];
        Statistics statistics = new Statistics(null);
        for (int i = 0; i < n; ++i) {
            boolean bl = true;
            for (Vector vector : vectorArray) {
                if (vector.size() <= i) continue;
                double d = vector.doubleValue(i);
                statistics.accept(d);
                if (!bl || Math.floor(d) == d || Double.isNaN(d)) continue;
                bl = false;
            }
            if (!bl) {
                nArray[i] = Numerics.suggestFractionDigits(statistics);
            }
            statistics.reset();
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String useScientificNotationIfNeeded(Format format, Object object, BiFunction<Format, Object, String> biFunction) {
        double d;
        if (object instanceof Number && (d = Math.abs(((Number)object).doubleValue())) > 0.0 && (d >= 1.0E9 || d < 1.0E-4) && format instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)format;
            String string = decimalFormat.toPattern();
            decimalFormat.applyPattern("0.######E00");
            try {
                String string2 = biFunction.apply(format, object);
                return string2;
            }
            finally {
                decimalFormat.applyPattern(string);
            }
        }
        return biFunction.apply(format, object);
    }

    static {
        Numerics.cache(0.0);
        Numerics.cache(1.0);
        Numerics.cache(10.0);
        Numerics.cache(60.0);
        Numerics.cache(90.0);
        Numerics.cache(100.0);
        Numerics.cache(180.0);
        Numerics.cache(648000.0);
        Numerics.cache(360.0);
        Numerics.cache(1000.0);
        Numerics.cache(Double.POSITIVE_INFINITY);
    }
}

