/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.Fraction;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class Numbers
extends Static {
    public static final byte BIG_DECIMAL = 11;
    public static final byte BIG_INTEGER = 10;
    public static final byte FRACTION = 7;
    public static final byte DOUBLE = 9;
    public static final byte FLOAT = 8;
    public static final byte LONG = 6;
    public static final byte INTEGER = 5;
    public static final byte SHORT = 4;
    public static final byte BYTE = 3;
    public static final byte CHARACTER = 2;
    public static final byte BOOLEAN = 1;
    public static final byte OTHER = 0;
    private static final Map<Class<?>, Numbers> MAPPING = new IdentityHashMap(12);
    private final Class<?> primitive;
    private final Class<?> wrapper;
    private final boolean isFloat;
    private final boolean isInteger;
    private final byte size;
    private final byte ordinal;
    private final char internal;
    private final Object nullValue;

    private Numbers(Class<?> clazz, boolean bl, boolean bl2, byte by) {
        this.wrapper = clazz;
        this.primitive = this.wrapper;
        this.isFloat = bl;
        this.isInteger = bl2;
        this.size = (byte)-1;
        this.ordinal = by;
        this.internal = (char)76;
        this.nullValue = null;
        if (MAPPING.put(clazz, this) != null) {
            throw new AssertionError();
        }
    }

    private Numbers(Class<?> clazz, Class<?> clazz2, boolean bl, boolean bl2, byte by, byte by2, char c, Object object) {
        this.primitive = clazz;
        this.wrapper = clazz2;
        this.isFloat = bl;
        this.isInteger = bl2;
        this.size = by;
        this.ordinal = by2;
        this.internal = c;
        this.nullValue = object;
        if (MAPPING.put(clazz, this) != null || MAPPING.put(clazz2, this) != null) {
            throw new AssertionError();
        }
    }

    static char getInternal(Class<?> clazz) {
        return Numbers.MAPPING.get(clazz).internal;
    }

    public static boolean isFloat(Class<?> clazz) {
        Numbers numbers = MAPPING.get(clazz);
        return numbers != null && numbers.isFloat;
    }

    public static boolean isInteger(Class<?> clazz) {
        Numbers numbers = MAPPING.get(clazz);
        return numbers != null && numbers.isInteger;
    }

    public static int primitiveBitCount(Class<?> clazz) throws IllegalArgumentException {
        Numbers numbers = MAPPING.get(clazz);
        if (numbers != null) {
            byte by = numbers.size;
            if (by >= 0) {
                return by;
            }
        } else if (clazz == null) {
            return 0;
        }
        throw Numbers.unknownType(clazz);
    }

    public static Class<?> primitiveToWrapper(Class<?> clazz) {
        Numbers numbers = MAPPING.get(clazz);
        return numbers != null ? numbers.wrapper : clazz;
    }

    public static Class<?> wrapperToPrimitive(Class<?> clazz) {
        Numbers numbers = MAPPING.get(clazz);
        return numbers != null ? numbers.primitive : clazz;
    }

    public static Class<? extends Number> widestClass(Number number, Number number2) throws IllegalArgumentException {
        return Numbers.widestClass(number != null ? number.getClass() : null, number2 != null ? number2.getClass() : null);
    }

    public static Class<? extends Number> widestClass(Class<? extends Number> clazz, Class<? extends Number> clazz2) throws IllegalArgumentException {
        if (clazz == null) {
            return clazz2;
        }
        if (clazz2 == null) {
            return clazz;
        }
        Numbers numbers = MAPPING.get(clazz);
        if (numbers == null) {
            throw Numbers.unknownType(clazz);
        }
        Numbers numbers2 = MAPPING.get(clazz2);
        if (numbers2 == null) {
            throw Numbers.unknownType(clazz2);
        }
        return numbers.ordinal >= numbers2.ordinal ? clazz : clazz2;
    }

    public static Class<? extends Number> narrowestClass(Number number, Number number2) throws IllegalArgumentException {
        return Numbers.narrowestClass(number != null ? number.getClass() : null, number2 != null ? number2.getClass() : null);
    }

    public static Class<? extends Number> narrowestClass(Class<? extends Number> clazz, Class<? extends Number> clazz2) throws IllegalArgumentException {
        if (clazz == null) {
            return clazz2;
        }
        if (clazz2 == null) {
            return clazz;
        }
        Numbers numbers = MAPPING.get(clazz);
        if (numbers == null) {
            throw Numbers.unknownType(clazz);
        }
        Numbers numbers2 = MAPPING.get(clazz2);
        if (numbers2 == null) {
            throw Numbers.unknownType(clazz2);
        }
        return numbers.ordinal < numbers2.ordinal ? clazz : clazz2;
    }

    public static Class<? extends Number> narrowestClass(Number number) {
        if (number == null) {
            return null;
        }
        boolean bl = false;
        long l = number.longValue();
        switch (Numbers.getEnumConstant(number.getClass())) {
            default: {
                double d = number.doubleValue();
                float f = (float)d;
                boolean bl2 = bl = Double.doubleToLongBits(f) == Double.doubleToLongBits(d);
                if (d != (double)l) {
                    return bl ? Float.class : Double.class;
                }
            }
            case 6: {
                if ((long)((int)l) != l) {
                    return bl ? Float.class : Long.class;
                }
            }
            case 5: {
                if ((long)((short)l) != l) {
                    return Integer.class;
                }
            }
            case 4: {
                if ((long)((byte)l) == l) break;
                return Short.class;
            }
            case 3: 
        }
        return Byte.class;
    }

    public static Number narrowestNumber(Number number) {
        Number number2;
        if (number == null) {
            return null;
        }
        boolean bl = false;
        long l = number.longValue();
        switch (Numbers.getEnumConstant(number.getClass())) {
            default: {
                double d = number.doubleValue();
                float f = (float)d;
                boolean bl2 = bl = Double.doubleToLongBits(f) == Double.doubleToLongBits(d);
                if (d != (double)l) {
                    if (bl) {
                        number2 = Float.valueOf(f);
                        break;
                    }
                    number2 = Numerics.valueOf(d);
                    break;
                }
            }
            case 6: {
                if ((long)((int)l) != l) {
                    if (bl) {
                        number2 = Float.valueOf(l);
                        break;
                    }
                    number2 = l;
                    break;
                }
            }
            case 5: {
                if ((long)((short)l) != l) {
                    number2 = (int)l;
                    break;
                }
            }
            case 4: {
                if ((long)((byte)l) != l) {
                    number2 = (short)l;
                    break;
                }
            }
            case 3: {
                number2 = (byte)l;
            }
        }
        return number.equals(number2) ? (Number)number : (Number)number2;
    }

    public static Number narrowestNumber(String string) throws NumberFormatException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '.' && c != 'e' && c != 'E') continue;
            return Numbers.narrowestNumber(Double.parseDouble(string));
        }
        return Numbers.narrowestNumber(Long.parseLong(string));
    }

    public static <N extends Number> N cast(Number number, Class<N> clazz) throws IllegalArgumentException {
        if (number == null || number.getClass() == clazz) {
            return (N)number;
        }
        switch (Numbers.getEnumConstant(clazz)) {
            case 3: {
                return (N)Byte.valueOf(number.byteValue());
            }
            case 4: {
                return (N)Short.valueOf(number.shortValue());
            }
            case 5: {
                return (N)Integer.valueOf(number.intValue());
            }
            case 6: {
                return (N)Long.valueOf(number.longValue());
            }
            case 8: {
                return (N)Float.valueOf(number.floatValue());
            }
            case 9: {
                return (N)Numerics.valueOf(number.doubleValue());
            }
            case 7: {
                return (N)Fraction.valueOf(number.doubleValue());
            }
            case 10: {
                BigInteger bigInteger = number instanceof BigInteger ? (BigInteger)number : (number instanceof BigDecimal ? ((BigDecimal)number).toBigInteger() : BigInteger.valueOf(number.longValue()));
                return (N)bigInteger;
            }
            case 11: {
                BigDecimal bigDecimal = number instanceof BigDecimal ? (BigDecimal)number : (number instanceof BigInteger ? new BigDecimal((BigInteger)number) : (Numbers.isInteger(number.getClass()) ? BigDecimal.valueOf(number.longValue()) : new BigDecimal(number.toString())));
                return (N)bigDecimal;
            }
        }
        if (clazz.isInstance(number)) {
            return (N)number;
        }
        throw Numbers.unknownType(clazz);
    }

    public static <N extends Number> N wrap(double d, Class<N> clazz) throws IllegalArgumentException {
        Number number;
        switch (Numbers.getEnumConstant(clazz)) {
            case 3: {
                number = (byte)d;
                break;
            }
            case 4: {
                number = (short)d;
                break;
            }
            case 5: {
                number = (int)d;
                break;
            }
            case 6: {
                number = (long)d;
                break;
            }
            case 8: {
                number = Float.valueOf((float)d);
                break;
            }
            case 9: {
                return (N)Numerics.valueOf(d);
            }
            case 7: {
                return (N)Fraction.valueOf(d);
            }
            case 10: {
                number = BigInteger.valueOf((long)d);
                break;
            }
            case 11: {
                return (N)BigDecimal.valueOf(d);
            }
            default: {
                throw Numbers.unknownType(clazz);
            }
        }
        if (Double.doubleToLongBits(number.doubleValue()) != Double.doubleToLongBits(d)) {
            throw new IllegalArgumentException(Errors.format((short)8, d, clazz));
        }
        return (N)number;
    }

    public static <N extends Number> N wrap(long l, Class<N> clazz) throws IllegalArgumentException {
        Number number;
        switch (Numbers.getEnumConstant(clazz)) {
            case 3: {
                number = (byte)l;
                break;
            }
            case 4: {
                number = (short)l;
                break;
            }
            case 5: {
                number = (int)l;
                break;
            }
            case 6: {
                return (N)Long.valueOf(l);
            }
            case 8: {
                number = Float.valueOf(l);
                break;
            }
            case 9: {
                number = Numerics.valueOf(l);
                break;
            }
            case 7: {
                number = new Fraction((int)l, 1);
                break;
            }
            case 10: {
                return (N)BigInteger.valueOf(l);
            }
            case 11: {
                return (N)BigDecimal.valueOf(l);
            }
            default: {
                throw Numbers.unknownType(clazz);
            }
        }
        if (number.longValue() != l) {
            throw new IllegalArgumentException(Errors.format((short)8, l, clazz));
        }
        return (N)number;
    }

    public static <T> T valueOf(String string, Class<T> clazz) throws IllegalArgumentException, NumberFormatException {
        if (string == null || clazz == String.class) {
            return (T)string;
        }
        switch (Numbers.getEnumConstant(clazz)) {
            case 2: {
                return (T)Character.valueOf(string.isEmpty() ? (char)'\u0000' : string.charAt(0));
            }
            case 1: {
                return (T)Boolean.valueOf(string);
            }
            case 3: {
                return (T)Byte.valueOf(string);
            }
            case 4: {
                return (T)Short.valueOf(string);
            }
            case 5: {
                return (T)Integer.valueOf(string);
            }
            case 6: {
                return (T)Long.valueOf(string);
            }
            case 8: {
                return (T)Float.valueOf(string);
            }
            case 9: {
                return (T)Double.valueOf(string);
            }
            case 7: {
                return (T)new Fraction(string);
            }
            case 10: {
                return (T)new BigInteger(string);
            }
            case 11: {
                return (T)new BigDecimal(string);
            }
        }
        throw Numbers.unknownType(clazz);
    }

    public static <T> T valueOfNil(Class<T> clazz) {
        Numbers numbers = MAPPING.get(clazz);
        if (numbers != null) {
            if (clazz.isPrimitive()) {
                return (T)numbers.nullValue;
            }
        } else if (clazz != null && clazz != Object.class) {
            if (clazz == Map.class) {
                return (T)Collections.EMPTY_MAP;
            }
            if (clazz == List.class) {
                return (T)Collections.EMPTY_LIST;
            }
            if (clazz == Queue.class) {
                return (T)CollectionsExt.emptyQueue();
            }
            if (clazz == SortedSet.class) {
                return (T)Collections.emptySortedSet();
            }
            if (clazz == NavigableSet.class) {
                return (T)Collections.emptyNavigableSet();
            }
            if (clazz.isAssignableFrom(Set.class)) {
                return (T)Collections.EMPTY_SET;
            }
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2 != null) {
                return (T)Array.newInstance(clazz2, 0);
            }
        }
        return null;
    }

    public static byte getEnumConstant(Class<?> clazz) {
        Numbers numbers = MAPPING.get(clazz);
        return numbers != null ? numbers.ordinal : (byte)0;
    }

    private static IllegalArgumentException unknownType(Class<?> clazz) {
        return new IllegalArgumentException(Errors.format((short)111, clazz));
    }

    static {
        new Numbers(BigDecimal.class, true, false, 11);
        new Numbers(BigInteger.class, false, true, 10);
        new Numbers(Fraction.class, true, false, 7);
        new Numbers(Double.TYPE, Double.class, true, false, 64, 9, 'D', Numerics.valueOf(Double.NaN));
        new Numbers(Float.TYPE, Float.class, true, false, 32, 8, 'F', Float.valueOf(Float.NaN));
        new Numbers(Long.TYPE, Long.class, false, true, 64, 6, 'J', 0L);
        new Numbers(Integer.TYPE, Integer.class, false, true, 32, 5, 'I', 0);
        new Numbers(Short.TYPE, Short.class, false, true, 16, 4, 'S', (short)0);
        new Numbers(Byte.TYPE, Byte.class, false, true, 8, 3, 'B', (byte)0);
        new Numbers(Character.TYPE, Character.class, false, false, 16, 2, 'C', Character.valueOf('\u0000'));
        new Numbers(Boolean.TYPE, Boolean.class, false, false, 1, 1, 'Z', Boolean.FALSE);
        new Numbers(Void.TYPE, Void.class, false, false, 0, 0, 'V', null);
    }
}

