/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process.reflect;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontFactory;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.COSUtils;
import org.apache.pdfbox.preflight.utils.ContextHelper;

public class ExtGStateValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext context) throws ValidationException {
        PreflightPath vPath = context.getValidationPath();
        if (vPath.isEmpty()) {
            return;
        }
        if (!vPath.isExpectedType(COSDictionary.class)) {
            context.addValidationError(new ValidationResult.ValidationError("2.1.10", "ExtGState validation required at least a Resource dictionary"));
        } else {
            COSDictionary extGStatesDict = (COSDictionary)vPath.peek();
            List<COSDictionary> listOfExtGState = this.extractExtGStateDictionaries(context, extGStatesDict);
            this.validateTransparencyRules(context, listOfExtGState);
            this.validateFonts(context, listOfExtGState);
        }
    }

    public List<COSDictionary> extractExtGStateDictionaries(PreflightContext context, COSDictionary egsEntry) throws ValidationException {
        ArrayList<COSDictionary> listOfExtGState = new ArrayList<COSDictionary>(0);
        COSDocument cosDocument = context.getDocument().getDocument();
        COSDictionary extGStates = COSUtils.getAsDictionary((COSBase)egsEntry, cosDocument);
        if (extGStates != null) {
            for (Object object : extGStates.keySet()) {
                COSName key = (COSName)object;
                COSBase gsBase = extGStates.getItem(key);
                COSDictionary gsDict = COSUtils.getAsDictionary(gsBase, cosDocument);
                if (gsDict == null) {
                    throw new ValidationException("The Extended Graphics State dictionary is invalid");
                }
                listOfExtGState.add(gsDict);
            }
        }
        return listOfExtGState;
    }

    protected void validateTransparencyRules(PreflightContext context, List<COSDictionary> listOfExtGState) {
        for (COSDictionary egs : listOfExtGState) {
            this.checkSoftMask(context, egs);
            this.checkUpperCA(context, egs);
            this.checkLowerCA(context, egs);
            this.checkBlendMode(context, egs);
            this.checkTRKey(context, egs);
            this.checkTR2Key(context, egs);
        }
    }

    protected void validateFonts(PreflightContext context, List<COSDictionary> listOfExtGState) throws ValidationException {
        for (COSDictionary egs : listOfExtGState) {
            this.checkFont(context, egs);
        }
    }

    private void checkFont(PreflightContext context, COSDictionary egs) throws ValidationException {
        COSBase base = egs.getItem(COSName.FONT);
        if (base == null) {
            return;
        }
        if (!(base instanceof COSArray) || ((COSArray)base).size() != 2) {
            context.addValidationError(new ValidationResult.ValidationError("1.0", "/Font entry in /ExtGState must be an array with 2 elements"));
            return;
        }
        COSArray ar = (COSArray)base;
        COSBase base0 = ar.get(0);
        if (!(base0 instanceof COSObject)) {
            context.addValidationError(new ValidationResult.ValidationError("1.0", "1st element in /Font entry in /ExtGState must be an indirect object"));
            return;
        }
        COSBase base1 = ar.getObject(1);
        if (!(base1 instanceof COSNumber)) {
            context.addValidationError(new ValidationResult.ValidationError("1.0", "2nd element in /Font entry in /ExtGState must be a number"));
            return;
        }
        COSNumber fontSize = (COSNumber)ar.getObject(1);
        if (fontSize.floatValue() > 32767.0f || fontSize.floatValue() < -32767.0f) {
            context.addValidationError(new ValidationResult.ValidationError("1.0.6", "invalid float range in 2nd element in /Font entry in /ExtGState"));
        }
        if (ar.getObject(0) instanceof COSDictionary) {
            COSDictionary fontDict = (COSDictionary)ar.getObject(0);
            try {
                PDFont newFont = PDFontFactory.createFont((COSDictionary)fontDict);
                ContextHelper.validateElement(context, newFont, "font-process");
            }
            catch (IOException e) {
                this.addFontError(fontDict, context, e);
            }
        }
    }

    private void checkSoftMask(PreflightContext context, COSDictionary egs) {
        COSBase smVal = egs.getItem(COSName.SMASK);
        if (!(smVal == null || smVal instanceof COSName && "None".equals(((COSName)smVal).getName()))) {
            context.addValidationError(new ValidationResult.ValidationError("4.1.1", "SoftMask must be null or None"));
        }
    }

    private void checkBlendMode(PreflightContext context, COSDictionary egs) {
        COSBase bmVal = egs.getItem("BM");
        if (!(bmVal == null || bmVal instanceof COSName && ("Normal".equals(((COSName)bmVal).getName()) || "Compatible".equals(((COSName)bmVal).getName())))) {
            context.addValidationError(new ValidationResult.ValidationError("4.1.3", "BlendMode value isn't valid (only Normal and Compatible are authorized)"));
        }
    }

    private void checkUpperCA(PreflightContext context, COSDictionary egs) {
        COSBase uCA = egs.getItem("CA");
        if (uCA != null) {
            COSDocument cosDocument = context.getDocument().getDocument();
            Float fca = COSUtils.getAsFloat(uCA, cosDocument);
            Integer ica = COSUtils.getAsInteger(uCA, cosDocument);
            if (!(fca != null && fca.floatValue() == 1.0f || ica != null && ica == 1)) {
                context.addValidationError(new ValidationResult.ValidationError("4.1.2", "CA entry in a ExtGState is invalid"));
            }
        }
    }

    private void checkLowerCA(PreflightContext context, COSDictionary egs) {
        COSBase lCA = egs.getItem("ca");
        if (lCA != null) {
            COSDocument cosDocument = context.getDocument().getDocument();
            Float fca = COSUtils.getAsFloat(lCA, cosDocument);
            Integer ica = COSUtils.getAsInteger(lCA, cosDocument);
            if (!(fca != null && fca.floatValue() == 1.0f || ica != null && ica == 1)) {
                context.addValidationError(new ValidationResult.ValidationError("4.1.2", "ca entry in a ExtGState is invalid"));
            }
        }
    }

    protected void checkTRKey(PreflightContext context, COSDictionary egs) {
        if (egs.getItem(COSName.TR) != null) {
            context.addValidationError(new ValidationResult.ValidationError("2.3", "No TR key expected in Extended graphics state"));
        }
    }

    protected void checkTR2Key(PreflightContext context, COSDictionary egs) {
        String s;
        if (egs.getItem("TR2") != null && !"Default".equals(s = egs.getNameAsString("TR2"))) {
            context.addValidationError(new ValidationResult.ValidationError("2.3.2", "TR2 key only expect 'Default' value, not '" + s + "'"));
        }
    }
}

