/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.NamedElement;
import org.apache.sis.internal.netcdf.Node;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.GeodeticObjectBuilder;
import org.apache.sis.internal.referencing.ReferencingFactoryContainer;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.internal.referencing.provider.PseudoPlateCarree;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class GridMapping {
    final CoordinateReferenceSystem crs;
    private final MathTransform gridToCRS;
    private final boolean isEPSG;

    private GridMapping(CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, boolean bl) {
        this.crs = coordinateReferenceSystem;
        this.gridToCRS = mathTransform;
        this.isEPSG = bl;
    }

    static GridMapping forVariable(Variable variable) {
        Map<Object, GridMapping> map = variable.decoder.gridMapping;
        for (String string : variable.decoder.convention().nameOfMappingNode(variable)) {
            GridMapping gridMapping = map.get(string);
            if (gridMapping != null) {
                return gridMapping;
            }
            if (map.containsKey(string)) continue;
            Node node = variable.decoder.findNode(string);
            if (node != null) {
                gridMapping = GridMapping.parse(node);
            }
            map.put(string, gridMapping);
            if (gridMapping == null) continue;
            return gridMapping;
        }
        Object object = map.get(variable);
        if (object == null) {
            String string;
            string = variable.getName();
            object = map.get(string);
            if (object == null && !map.containsKey(string)) {
                object = GridMapping.parse(variable);
                map.put(string, (GridMapping)object);
            }
            if (object == null) {
                object = GridMapping.parseNonStandard(variable);
            }
            if (object != null) {
                map.put(variable, (GridMapping)object);
            }
        }
        return object;
    }

    private static GridMapping parse(Node node) {
        GridMapping gridMapping = GridMapping.parseProjectionParameters(node);
        if (gridMapping == null) {
            gridMapping = GridMapping.parseGeoTransform(node);
        }
        return gridMapping;
    }

    /*
     * WARNING - void declaration
     */
    private static GridMapping parseProjectionParameters(Node node) {
        Map<String, Object> map = node.decoder.convention().projection(node);
        if (map != null) {
            try {
                void var7_11;
                MathTransform mathTransform;
                String string;
                Object object = map.remove("longitude_of_prime_meridian");
                DefaultCoordinateOperationFactory defaultCoordinateOperationFactory = node.decoder.getCoordinateOperationFactory();
                OperationMethod operationMethod = defaultCoordinateOperationFactory.getOperationMethod((String)map.remove("grid_mapping_name"));
                ParameterValueGroup parameterValueGroup = operationMethod.getParameters().createValue();
                for (Map.Entry<String, Object> linearTransform2 : map.entrySet()) {
                    string = linearTransform2.getKey();
                    mathTransform = linearTransform2.getValue();
                    if (!(mathTransform instanceof Number) && !(mathTransform instanceof double[]) && !(mathTransform instanceof float[])) continue;
                    try {
                        parameterValueGroup.parameter(string).setValue(mathTransform);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        GridMapping.warning(node, illegalArgumentException, (short)20, node.decoder.getFilename(), node.getName(), string, mathTransform, illegalArgumentException.getLocalizedMessage());
                    }
                }
                GeographicCRS geographicCRS = GridMapping.createBaseCRS(node.decoder, parameterValueGroup, map, object);
                if (operationMethod instanceof PseudoPlateCarree) {
                    LinearTransform linearTransform = MathTransforms.linear((Matrix)new Matrix3(0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0));
                    string = geographicCRS;
                } else {
                    mathTransform = GridMapping.properties(map, "conversion_name", node.getName());
                    Conversion conversion = defaultCoordinateOperationFactory.createDefiningConversion(mathTransform, operationMethod, parameterValueGroup);
                    CartesianCS cartesianCS = node.decoder.getStandardProjectedCS();
                    mathTransform = GridMapping.properties(map, "projected_crs_name", conversion);
                    ProjectedCRS projectedCRS = node.decoder.getCRSFactory().createProjectedCRS((Map)mathTransform, geographicCRS, conversion, cartesianCS);
                    MathTransform mathTransform2 = projectedCRS.getConversionFromBase().getMathTransform();
                    string = projectedCRS;
                }
                mathTransform = node.decoder.convention().gridToCRS(node, (MathTransform)var7_11);
                return new GridMapping((CoordinateReferenceSystem)string, mathTransform, false);
            }
            catch (ClassCastException | IllegalArgumentException | TransformException | FactoryException throwable) {
                GridMapping.canNotCreate(node, (short)11, (Exception)throwable);
            }
        }
        return null;
    }

    private static GeographicCRS createBaseCRS(Decoder decoder, ParameterValueGroup parameterValueGroup, Map<String, Object> map, Object object) throws FactoryException {
        Ellipsoid ellipsoid;
        Map<String, Object> map2;
        PrimeMeridian primeMeridian;
        GeodeticDatum geodeticDatum;
        DatumFactory datumFactory = decoder.getDatumFactory();
        CommonCRS commonCRS = decoder.convention().defaultHorizontalCRS(false);
        boolean bl = false;
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            geodeticDatum = GridMapping.properties(map, "prime_meridian_name", null);
            primeMeridian = datumFactory.createPrimeMeridian(geodeticDatum, d, Units.DEGREE);
            bl = true;
        } else {
            primeMeridian = commonCRS.primeMeridian();
        }
        try {
            double d = parameterValueGroup.parameter("semi_major").doubleValue();
            map2 = GridMapping.properties(map, "reference_ellipsoid_name", null);
            if (parameterValueGroup.parameter("is_ivf_definitive").booleanValue()) {
                double d2 = parameterValueGroup.parameter("inverse_flattening").doubleValue();
                ellipsoid = datumFactory.createFlattenedSphere(map2, d, d2, Units.METRE);
            } else {
                double d3 = parameterValueGroup.parameter("semi_minor").doubleValue();
                ellipsoid = datumFactory.createEllipsoid(map2, d, d3, Units.METRE);
            }
            bl = true;
        }
        catch (IllegalStateException | ParameterNotFoundException throwable) {
            ellipsoid = commonCRS.ellipsoid();
        }
        Object object2 = map.remove("towgs84");
        if (bl | object2 != null) {
            map2 = GridMapping.properties(map, "horizontal_datum_name", ellipsoid);
            if (object2 instanceof BursaWolfParameters) {
                map2 = new HashMap<String, Object>(map2);
                map2.put("bursaWolf", object2);
                bl = true;
            }
            geodeticDatum = datumFactory.createGeodeticDatum(map2, ellipsoid, primeMeridian);
        } else {
            geodeticDatum = commonCRS.datum();
        }
        if (bl) {
            map2 = GridMapping.properties(map, "geographic_crs_name", geodeticDatum);
            return decoder.getCRSFactory().createGeographicCRS(map2, geodeticDatum, commonCRS.geographic().getCoordinateSystem());
        }
        return commonCRS.geographic();
    }

    private static Map<String, Object> properties(Map<String, Object> map, String string, Object object) {
        Object object2 = map.remove(string);
        if (object2 == null) {
            object2 = object instanceof IdentifiedObject ? ((IdentifiedObject)object).getName() : (object != null ? object : Vocabulary.formatInternational((short)108));
        }
        return Collections.singletonMap("name", object2);
    }

    private static GridMapping parseGeoTransform(Node node) {
        String string = node.getAttributeAsString("spatial_ref");
        String string2 = node.getAttributeAsString("GeoTransform");
        if (string == null && string2 == null) {
            return null;
        }
        short s = 11;
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        AffineTransform2D affineTransform2D = null;
        try {
            if (string != null) {
                coordinateReferenceSystem = GridMapping.createFromWKT(node, string);
            }
            if (string2 != null) {
                s = 12;
                double[] dArray = CharSequences.parseDoubles((CharSequence)string2, (char)' ');
                if (dArray.length == 6) {
                    affineTransform2D = new AffineTransform2D(dArray[1], dArray[4], dArray[2], dArray[5], dArray[0], dArray[3]);
                } else {
                    GridMapping.canNotCreate(node, s, new DataStoreContentException(Errors.getResources((Locale)node.getLocale()).getString((short)133, (Object)6, (Object)dArray.length)));
                }
            }
        }
        catch (NumberFormatException | ParseException exception) {
            GridMapping.canNotCreate(node, s, exception);
        }
        return new GridMapping(coordinateReferenceSystem, (MathTransform)affineTransform2D, false);
    }

    private static GridMapping parseNonStandard(Node node) {
        CoordinateReferenceSystem coordinateReferenceSystem;
        boolean bl = false;
        String string = node.getAttributeAsString("ESRI_pe_string");
        if (string == null) {
            string = node.getAttributeAsString("EPSG_code");
            if (string == null) {
                return null;
            }
            bl = true;
        }
        try {
            coordinateReferenceSystem = bl ? CRS.forCode((String)("EPSG:" + bl)) : GridMapping.createFromWKT(node, string);
        }
        catch (ClassCastException | ParseException | FactoryException throwable) {
            GridMapping.canNotCreate(node, (short)11, (Exception)throwable);
            coordinateReferenceSystem = null;
        }
        return new GridMapping(coordinateReferenceSystem, null, bl);
    }

    private static CoordinateReferenceSystem createFromWKT(Node node, String string) throws ParseException {
        WKTFormat wKTFormat = new WKTFormat(node.getLocale(), node.decoder.getTimeZone());
        wKTFormat.setConvention(Convention.WKT1_COMMON_UNITS);
        CoordinateReferenceSystem coordinateReferenceSystem = (CoordinateReferenceSystem)wKTFormat.parseObject(string);
        Warnings warnings = wKTFormat.getWarnings();
        if (warnings != null) {
            LogRecord logRecord = new LogRecord(Level.WARNING, warnings.toString());
            logRecord.setLoggerName("org.apache.sis.storage.netcdf");
            logRecord.setSourceClassName(Variable.class.getCanonicalName());
            logRecord.setSourceMethodName("getGridGeometry");
            node.decoder.listeners.warning(logRecord);
        }
        return coordinateReferenceSystem;
    }

    private static void canNotCreate(Node node, short s, Exception exception) {
        GridMapping.warning(node, exception, s, node.decoder.getFilename(), node.getName(), exception.getLocalizedMessage());
    }

    private static void warning(Node node, Exception exception, short s, Object ... objectArray) {
        NamedElement.warning(node.decoder.listeners, Variable.class, "getGridGeometry", exception, null, s, objectArray);
    }

    GridGeometry createGridCRS(Variable variable) {
        List<Dimension> list = variable.getGridDimensions();
        long[] lArray = new long[list.size()];
        for (int i = 0; i < lArray.length; ++i) {
            int n = lArray.length - 1 - i;
            lArray[i] = list.get(n).length();
        }
        return new GridGeometry(new GridExtent(null, null, lArray, false), PixelInCell.CELL_CENTER, this.gridToCRS, this.crs);
    }

    GridGeometry adaptGridCRS(Variable variable, GridGeometry gridGeometry, PixelInCell pixelInCell) {
        CoordinateSystem coordinateSystem;
        CoordinateReferenceSystem coordinateReferenceSystem;
        CoordinateReferenceSystem coordinateReferenceSystem2 = this.crs;
        int n = 0;
        boolean bl = true;
        if (gridGeometry.isDefined(1)) {
            coordinateReferenceSystem = gridGeometry.getCoordinateReferenceSystem();
            if (coordinateReferenceSystem2 == null) {
                coordinateReferenceSystem2 = coordinateReferenceSystem;
            } else {
                CoordinateSystem coordinateSystem2;
                coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
                n = AxisDirections.indexOfColinear((CoordinateSystem)coordinateSystem, (CoordinateSystem)(coordinateSystem2 = coordinateReferenceSystem2.getCoordinateSystem()));
                if (n < 0 && (n = AxisDirections.indexOfColinear((CoordinateSystem)coordinateSystem, (CoordinateSystem)(coordinateSystem2 = (coordinateReferenceSystem2 = AbstractCRS.castOrCopy((CoordinateReferenceSystem)coordinateReferenceSystem2).forConvention(AxesConvention.RIGHT_HANDED)).getCoordinateSystem()))) < 0) {
                    n = 0;
                    if (!this.isEPSG) {
                        coordinateReferenceSystem2 = this.crs;
                        coordinateSystem2 = coordinateReferenceSystem2.getCoordinateSystem();
                    }
                }
                try {
                    coordinateReferenceSystem2 = new GeodeticObjectBuilder((ReferencingFactoryContainer)variable.decoder, variable.decoder.listeners.getLocale()).replaceComponent(coordinateReferenceSystem, n, coordinateReferenceSystem2);
                }
                catch (FactoryException factoryException) {
                    GridMapping.canNotCreate(variable, (short)11, (Exception)((Object)factoryException));
                    return null;
                }
                bl = coordinateReferenceSystem.equals(coordinateReferenceSystem2);
                if (bl) {
                    coordinateReferenceSystem2 = coordinateReferenceSystem;
                }
            }
        }
        coordinateReferenceSystem = this.gridToCRS;
        if (gridGeometry.isDefined(8)) {
            coordinateSystem = gridGeometry.getGridToCRS(pixelInCell);
            if (coordinateReferenceSystem == null) {
                coordinateReferenceSystem = coordinateSystem;
            } else {
                try {
                    int n2;
                    int n3 = 0;
                    Object[] objectArray = new MathTransform[3];
                    TransformSeparator transformSeparator = new TransformSeparator((MathTransform)coordinateSystem, variable.decoder.getMathTransformFactory());
                    if (n != 0) {
                        transformSeparator.addTargetDimensionRange(0, n);
                        objectArray[n3++] = transformSeparator.separate();
                        transformSeparator.clear();
                    }
                    objectArray[n3++] = coordinateReferenceSystem;
                    int n4 = n + coordinateReferenceSystem.getTargetDimensions();
                    if (n4 != (n2 = coordinateSystem.getTargetDimensions())) {
                        transformSeparator.addTargetDimensionRange(n4, n2);
                        objectArray[n3++] = transformSeparator.separate();
                    }
                    if (coordinateSystem.equals(coordinateReferenceSystem = MathTransforms.compound((MathTransform[])(objectArray = (MathTransform[])ArraysExt.resize((Object[])objectArray, (int)n3))))) {
                        coordinateReferenceSystem = coordinateSystem;
                    } else {
                        bl = false;
                    }
                }
                catch (FactoryException factoryException) {
                    GridMapping.canNotCreate(variable, (short)12, (Exception)((Object)factoryException));
                    return null;
                }
            }
        }
        if (bl) {
            return gridGeometry;
        }
        return new GridGeometry(gridGeometry.getExtent(), pixelInCell, (MathTransform)coordinateReferenceSystem, coordinateReferenceSystem2);
    }
}

