/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf;

import java.io.IOException;
import java.net.URI;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.RasterResource;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.storage.netcdf.MetadataReader;
import org.apache.sis.storage.netcdf.NetcdfStoreProvider;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Version;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.opengis.metadata.Metadata;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;
import org.opengis.util.NameSpace;

public class NetcdfStore
extends DataStore
implements Aggregate {
    private final Decoder decoder;
    private final URI location;
    private Metadata metadata;
    private List<Resource> components;

    public NetcdfStore(NetcdfStoreProvider netcdfStoreProvider, StorageConnector storageConnector) throws DataStoreException {
        super(netcdfStoreProvider, storageConnector);
        this.location = storageConnector.getStorageAs(URI.class);
        Path path = storageConnector.getStorageAs(Path.class);
        try {
            this.decoder = NetcdfStoreProvider.decoder(this.listeners, storageConnector);
        }
        catch (IOException | ArithmeticException exception) {
            throw new DataStoreException(exception);
        }
        if (this.decoder == null) {
            throw new UnsupportedStorageException(super.getLocale(), "NetCDF", storageConnector.getStorage(), (OpenOption[])storageConnector.getOption(OptionKey.OPEN_OPTIONS));
        }
        this.decoder.location = path;
        String string = this.decoder.stringValue("id");
        if (string == null || (string = string.trim()).isEmpty()) {
            string = this.decoder.getFilename();
        }
        if (string != null) {
            DefaultNameFactory defaultNameFactory = this.decoder.nameFactory;
            this.decoder.namespace = defaultNameFactory.createNameSpace((GenericName)defaultNameFactory.createLocalName(null, string), null);
        }
    }

    @Override
    public Optional<ParameterValueGroup> getOpenParameters() {
        return Optional.ofNullable(URIDataStore.parameters(this.provider, this.location));
    }

    public synchronized Version getConventionVersion() throws DataStoreException {
        for (CharSequence charSequence : CharSequences.split((CharSequence)this.decoder.stringValue("Conventions"), (char)',')) {
            if (!CharSequences.regionMatches((CharSequence)charSequence, (int)0, (CharSequence)"CF-", (boolean)true)) continue;
            return new Version(charSequence.subSequence(3, charSequence.length()).toString());
        }
        return null;
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        NameSpace nameSpace = this.decoder.namespace;
        return nameSpace != null ? Optional.of(nameSpace.name()) : Optional.empty();
    }

    @Override
    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            try {
                MetadataReader metadataReader = new MetadataReader(this.decoder);
                this.metadata = metadataReader.read();
            }
            catch (IOException | ArithmeticException exception) {
                throw new DataStoreException(exception);
            }
        }
        return this.metadata;
    }

    public synchronized Collection<Resource> components() throws DataStoreException {
        if (this.components == null) {
            try {
                Object[] objectArray = this.decoder.getDiscreteSampling();
                List<Resource> list = RasterResource.create(this.decoder, this);
                if (!list.isEmpty()) {
                    list.addAll((Collection<Resource>)UnmodifiableArrayList.wrap((Object[])objectArray));
                    objectArray = list.toArray(new Resource[list.size()]);
                }
                this.components = UnmodifiableArrayList.wrap((Object[])objectArray);
            }
            catch (IOException iOException) {
                throw new DataStoreException(iOException);
            }
        }
        return this.components;
    }

    @Override
    public <T extends StoreEvent> void addListener(Class<T> clazz, StoreListener<? super T> storeListener) {
        if (storeListener == null || clazz == null || clazz.isAssignableFrom(WarningEvent.class)) {
            super.addListener(clazz, storeListener);
        }
    }

    @Override
    public synchronized void close() throws DataStoreException {
        this.metadata = null;
        try {
            this.decoder.close();
        }
        catch (IOException iOException) {
            throw new DataStoreException(iOException);
        }
    }

    @Override
    public String toString() {
        return Strings.bracket(this.getClass(), (Object)this.decoder);
    }
}

