/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.image.RenderedImage;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class GridCoverage {
    private final GridGeometry gridGeometry;
    private final SampleDimension[] sampleDimensions;

    protected GridCoverage(GridGeometry gridGeometry, Collection<? extends SampleDimension> collection) {
        ArgumentChecks.ensureNonNull("grid", gridGeometry);
        ArgumentChecks.ensureNonNull("bands", collection);
        this.gridGeometry = gridGeometry;
        this.sampleDimensions = collection.toArray(new SampleDimension[collection.size()]);
        for (int i = 0; i < this.sampleDimensions.length; ++i) {
            ArgumentChecks.ensureNonNullElement("bands", i, this.sampleDimensions[i]);
        }
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.gridGeometry.getCoordinateReferenceSystem();
    }

    public GridGeometry getGridGeometry() {
        return this.gridGeometry;
    }

    public List<SampleDimension> getSampleDimensions() {
        return UnmodifiableArrayList.wrap(this.sampleDimensions);
    }

    public abstract GridCoverage forConvertedValues(boolean var1);

    public abstract RenderedImage render(GridExtent var1);

    public String toString() {
        return this.toTree(Locale.getDefault(), GridGeometry.defaultFlags()).toString();
    }

    public TreeTable toTree(Locale locale, int n) {
        ArgumentChecks.ensureNonNull("locale", locale);
        Vocabulary vocabulary = Vocabulary.getResources(locale);
        TableColumn<CharSequence> tableColumn = TableColumn.VALUE_AS_TEXT;
        DefaultTreeTable defaultTreeTable = new DefaultTreeTable(tableColumn);
        TreeTable.Node node = defaultTreeTable.getRoot();
        node.setValue(tableColumn, Classes.getShortClassName(this));
        TreeTable.Node node2 = node.newChild();
        node2.setValue(tableColumn, vocabulary.getString((short)162));
        this.gridGeometry.formatTo(locale, vocabulary, n, node2);
        node2 = node.newChild();
        node2.setValue(tableColumn, vocabulary.getString((short)163));
        node2.newChild().setValue(tableColumn, SampleDimension.toString(locale, this.sampleDimensions));
        return defaultTreeTable;
    }
}

