/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontFactory;
import org.apache.pdfbox.pdmodel.font.PDType3CharProc;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.pdmodel.font.encoding.Encoding;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.content.ContentStreamException;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.font.FontValidator;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.apache.pdfbox.preflight.font.container.Type3Container;
import org.apache.pdfbox.preflight.font.util.GlyphException;
import org.apache.pdfbox.preflight.font.util.PreflightType3Stream;
import org.apache.pdfbox.preflight.utils.COSUtils;
import org.apache.pdfbox.preflight.utils.ContextHelper;

public class Type3FontValidator
extends FontValidator<Type3Container> {
    protected PDType3Font font;
    protected COSDictionary fontDictionary;
    protected COSDocument cosDocument;

    public Type3FontValidator(PreflightContext context, PDType3Font font) {
        super(context, font.getCOSObject(), new Type3Container(font));
        this.cosDocument = context.getDocument().getDocument();
        this.fontDictionary = font.getCOSObject();
        this.font = font;
    }

    @Override
    public void validate() throws ValidationException {
        this.checkMandatoryField();
        this.checkFontBBox();
        this.checkFontMatrix();
        this.checkEncoding();
        this.checkResources();
        this.checkCharProcsAndMetrics();
        this.checkToUnicode();
    }

    protected void checkMandatoryField() {
        boolean areFieldsPResent = this.fontDictionary.containsKey(COSName.FONT_BBOX);
        areFieldsPResent &= this.fontDictionary.containsKey(COSName.FONT_MATRIX);
        areFieldsPResent &= this.fontDictionary.containsKey(COSName.CHAR_PROCS);
        areFieldsPResent &= this.fontDictionary.containsKey(COSName.ENCODING);
        areFieldsPResent &= this.fontDictionary.containsKey(COSName.FIRST_CHAR);
        areFieldsPResent &= this.fontDictionary.containsKey(COSName.LAST_CHAR);
        if (!(areFieldsPResent &= this.fontDictionary.containsKey(COSName.WIDTHS))) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": Some required fields are missing from the Font dictionary."));
        }
    }

    private void checkFontBBox() {
        COSBase fontBBox = this.fontDictionary.getItem(COSName.FONT_BBOX);
        if (!COSUtils.isArray(fontBBox, this.cosDocument)) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": The FontBBox element isn't an array"));
            return;
        }
        COSArray bbox = COSUtils.getAsArray(fontBBox, this.cosDocument);
        if (bbox.size() != 4) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": The FontBBox element is invalid"));
            return;
        }
        for (int i = 0; i < 4; ++i) {
            COSBase elt = bbox.get(i);
            if (COSUtils.isFloat(elt, this.cosDocument) || COSUtils.isInteger(elt, this.cosDocument)) continue;
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": An element of FontBBox isn't a number"));
            return;
        }
    }

    private void checkFontMatrix() {
        COSBase fontMatrix = this.fontDictionary.getItem(COSName.FONT_MATRIX);
        if (!COSUtils.isArray(fontMatrix, this.cosDocument)) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": The FontMatrix element isn't an array"));
            return;
        }
        COSArray matrix = COSUtils.getAsArray(fontMatrix, this.cosDocument);
        if (matrix.size() != 6) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": The FontMatrix element is invalid"));
            return;
        }
        for (int i = 0; i < 6; ++i) {
            COSBase elt = matrix.get(i);
            if (COSUtils.isFloat(elt, this.cosDocument) || COSUtils.isInteger(elt, this.cosDocument)) continue;
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": An element of FontMatrix isn't a number"));
            return;
        }
    }

    @Override
    protected void checkEncoding() {
        COSBase fontEncoding = this.fontDictionary.getItem(COSName.ENCODING);
        if (COSUtils.isString(fontEncoding, this.cosDocument)) {
            String enc = COSUtils.getAsString(fontEncoding, this.cosDocument);
            this.checkEncodingAsString(enc);
        } else if (COSUtils.isDictionary(fontEncoding, this.cosDocument)) {
            COSDictionary encodingDictionary = COSUtils.getAsDictionary(fontEncoding, this.cosDocument);
            this.checkEncodingAsDictionary(encodingDictionary);
        } else {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.4", this.font.getName() + ": The Encoding entry doesn't have the right type"));
        }
    }

    private void checkEncodingAsString(String enc) {
        Encoding encodingInstance = Encoding.getInstance((COSName)COSName.getPDFName((String)enc));
        if (encodingInstance == null) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.4", "The encoding '" + enc + "' doesn't exist"));
        }
    }

    private void checkEncodingAsDictionary(COSDictionary encodingDictionary) {
        COSBase diff;
        if (encodingDictionary.containsKey(COSName.BASE_ENCODING)) {
            this.checkEncodingAsString(encodingDictionary.getString(COSName.BASE_ENCODING));
        }
        if ((diff = encodingDictionary.getItem(COSName.DIFFERENCES)) != null) {
            if (!COSUtils.isArray(diff, this.cosDocument)) {
                ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.4", "The differences element of the encoding dictionary isn't an array"));
                return;
            }
            COSArray diffArray = COSUtils.getAsArray(diff, this.cosDocument);
            for (int i = 0; i < diffArray.size(); ++i) {
                COSBase item = diffArray.get(i);
                if (item instanceof COSInteger || item instanceof COSName) continue;
                ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.4", "Differences Array should contain COSInt or COSName, no other type"));
                return;
            }
        }
    }

    private void checkCharProcsAndMetrics() throws ValidationException {
        List<Float> widths = this.getWidths((PDFont)this.font);
        if (widths == null || widths.isEmpty()) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": The Widths array is unreachable"));
            return;
        }
        COSDictionary charProcs = COSUtils.getAsDictionary(this.fontDictionary.getItem(COSName.CHAR_PROCS), this.cosDocument);
        if (charProcs == null) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": The CharProcs element isn't a dictionary"));
            return;
        }
        int fc = this.font.getCOSObject().getInt(COSName.FIRST_CHAR, -1);
        int lc = this.font.getCOSObject().getInt(COSName.LAST_CHAR, -1);
        int expectedLength = lc - fc + 1;
        if (widths.size() != expectedLength) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": The length of Widths array is invalid. Expected : \"" + expectedLength + "\" Current : \"" + widths.size() + "\""));
            return;
        }
        for (int i = 0; i < expectedLength; ++i) {
            int code = fc + i;
            float width = widths.get(i).floatValue();
            PDType3CharProc charProc = this.getCharProc(code);
            if (charProc == null) continue;
            try {
                float fontProgramWidth = this.getWidthFromCharProc(charProc);
                if (Math.abs(width - fontProgramWidth) < 0.001f) {
                    ((Type3Container)this.fontContainer).markAsValid(code);
                    continue;
                }
                GlyphException glyphEx = new GlyphException("3.1.6", code, this.font.getName() + ": The character with CID " + code + " should have a width equals to " + width + ", but has " + fontProgramWidth);
                ((Type3Container)this.fontContainer).markAsInvalid(code, glyphEx);
                continue;
            }
            catch (ContentStreamException e) {
                this.context.addValidationError(new ValidationResult.ValidationError(e.getErrorCode(), e.getMessage(), e));
                return;
            }
            catch (IOException e) {
                ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.4", this.font.getName() + ": The CharProcs references an element which can't be read", e));
                return;
            }
        }
    }

    public List<Float> getWidths(PDFont font) {
        COSArray array = (COSArray)font.getCOSObject().getDictionaryObject(COSName.WIDTHS);
        List widths = array != null ? COSArrayList.convertFloatCOSArrayToList((COSArray)array) : Collections.emptyList();
        return widths;
    }

    private PDType3CharProc getCharProc(int code) throws ValidationException {
        PDType3CharProc charProc = this.font.getCharProc(code);
        if (charProc == null) {
            GlyphException glyphEx = new GlyphException("3.1.6", code, this.font.getName() + ": The CharProcs \"" + this.font.getEncoding().getName(code) + "\" doesn't exist");
            ((Type3Container)this.fontContainer).markAsInvalid(code, glyphEx);
        }
        return charProc;
    }

    private float getWidthFromCharProc(PDType3CharProc charProc) throws IOException {
        PreflightPath vPath = this.context.getValidationPath();
        PreflightType3Stream parser = new PreflightType3Stream(this.context, vPath.getClosestPathElement(PDPage.class), charProc);
        parser.showType3Character(charProc);
        return parser.getWidth();
    }

    private void checkResources() throws ValidationException {
        COSBase resources = this.fontDictionary.getItem(COSName.RESOURCES);
        if (resources != null) {
            COSDictionary dictionary = COSUtils.getAsDictionary(resources, this.cosDocument);
            if (dictionary == null) {
                ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": The Resources element isn't a dictionary"));
                return;
            }
            ContextHelper.validateElement(this.context, new PDResources(dictionary), "resources-process");
            COSBase cbFont = dictionary.getItem(COSName.FONT);
            if (cbFont != null) {
                COSDictionary dicFonts = COSUtils.getAsDictionary(cbFont, this.cosDocument);
                Set keyList = dicFonts.keySet();
                for (Object key : keyList) {
                    COSBase item = dicFonts.getItem((COSName)key);
                    COSDictionary xObjFont = COSUtils.getAsDictionary(item, this.cosDocument);
                    try {
                        PDFont aFont = PDFontFactory.createFont((COSDictionary)xObjFont);
                        FontContainer<?> aContainer = this.context.getFontContainer((COSBase)aFont.getCOSObject());
                        if (aContainer.isValid()) continue;
                        ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.4", this.font.getName() + ": The Resources dictionary of type 3 font contains invalid font"));
                    }
                    catch (IOException e) {
                        this.context.addValidationError(new ValidationResult.ValidationError("3.2", this.font.getName() + ": Unable to valid the Type3 : " + e.getMessage(), e));
                    }
                }
            }
        }
    }
}

