/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata.sql;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.metadata.sql.Dialect;
import org.apache.sis.internal.metadata.sql.TypeMapper;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.FactoryException;

public class SQLBuilder {
    public final Dialect dialect;
    private final String quote;
    private final boolean quoteSchema;
    private final String escape;
    private final StringBuilder buffer = new StringBuilder();

    public SQLBuilder(DatabaseMetaData databaseMetaData, boolean bl) throws SQLException {
        this.dialect = Dialect.guess(databaseMetaData);
        this.quote = databaseMetaData.getIdentifierQuoteString();
        this.escape = databaseMetaData.getSearchStringEscape();
        this.quoteSchema = bl;
    }

    public SQLBuilder(SQLBuilder sQLBuilder) {
        this.dialect = sQLBuilder.dialect;
        this.escape = sQLBuilder.escape;
        this.quote = sQLBuilder.quote;
        this.quoteSchema = sQLBuilder.quoteSchema;
    }

    public final boolean isEmpty() {
        return this.buffer.length() == 0;
    }

    public final SQLBuilder clear() {
        this.buffer.setLength(0);
        return this;
    }

    public final SQLBuilder append(int n) {
        this.buffer.append(n);
        return this;
    }

    public final SQLBuilder append(char c) {
        this.buffer.append(c);
        return this;
    }

    public final SQLBuilder append(String string) {
        this.buffer.append(string);
        return this;
    }

    public final SQLBuilder appendIdentifier(String string) {
        this.buffer.append(this.quote).append(string).append(this.quote);
        return this;
    }

    public final SQLBuilder appendIdentifier(String string, String string2) {
        if (string != null) {
            if (this.quoteSchema) {
                this.appendIdentifier(string);
            } else {
                this.buffer.append(string);
            }
            this.buffer.append('.');
        }
        return this.appendIdentifier(string2);
    }

    public final SQLBuilder appendIdentifier(String string, String string2, String string3) {
        if (string != null && !string.isEmpty()) {
            this.appendIdentifier(string);
            this.buffer.append('.');
            if (string2 == null) {
                return this.appendIdentifier("").appendIdentifier(string3);
            }
        }
        return this.appendIdentifier(string2, string3);
    }

    public final SQLBuilder appendCondition(Object object) throws FactoryException {
        if (object == null) {
            this.buffer.append(" IS NULL");
            return this;
        }
        this.buffer.append('=');
        return this.appendValue(object);
    }

    public final SQLBuilder appendValue(Object object) throws FactoryException {
        if (object == null) {
            this.buffer.append("NULL");
        } else if (object instanceof Boolean) {
            this.buffer.append((Boolean)object != false ? "TRUE" : "FALSE");
        } else if (object instanceof Number) {
            this.buffer.append(object);
        } else {
            if (object instanceof IdentifiedObject) {
                object = ReferencingServices.getInstance().getPreferredIdentifier((IdentifiedObject)object);
            }
            this.buffer.append('\'').append(SQLBuilder.doubleQuotes(object)).append('\'');
        }
        return this;
    }

    public final SQLBuilder appendEscaped(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_%", true);
        while (stringTokenizer.hasMoreTokens()) {
            this.buffer.append(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) break;
            this.buffer.append(this.escape).append(stringTokenizer.nextToken());
        }
        return this;
    }

    public final String createColumn(String string, String string2, String string3, Class<?> clazz, int n) {
        this.clear().append("ALTER TABLE ").appendIdentifier(string, string2).append(" ADD COLUMN ").appendIdentifier(string3).append(' ');
        String string4 = TypeMapper.keywordFor(clazz);
        if (string4 != null) {
            this.append(string4);
        } else {
            this.append("VARCHAR(").append(n).append(')');
        }
        return this.toString();
    }

    public final String createForeignKey(String string, String string2, String string3, String string4, String string5, boolean bl) {
        if (this.dialect == Dialect.DERBY) {
            bl = false;
        }
        this.buffer.setLength(0);
        String string6 = this.buffer.append(string2).append('_').append(string3).append("_fkey").toString();
        return this.clear().append("ALTER TABLE ").appendIdentifier(string, string2).append(" ADD CONSTRAINT ").appendIdentifier(string6).append(" FOREIGN KEY(").appendIdentifier(string3).append(") REFERENCES ").appendIdentifier(string, string4).append(" (").appendIdentifier(string5).append(") ON UPDATE ").append(bl ? "CASCADE" : "RESTRICT").append(" ON DELETE RESTRICT").toString();
    }

    public static String doubleQuotes(Object object) {
        return object.toString().replace("'", "''");
    }

    public final String toString() {
        return this.buffer.toString();
    }
}

