/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import org.apache.sis.internal.util.StandardDateFormat;
import org.apache.sis.io.wkt.Element;
import org.apache.sis.io.wkt.Parser;
import org.apache.sis.io.wkt.Symbols;
import org.apache.sis.io.wkt.UnparsableObjectException;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.logging.Logging;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

abstract class AbstractParser
implements Parser {
    static final int FIRST = 0;
    static final int OPTIONAL = 1;
    static final int MANDATORY = 2;
    final Locale errorLocale;
    final Symbols symbols;
    private final String exponentSymbol;
    private final NumberFormat numberFormat;
    private DateFormat dateFormat;
    private UnitFormat unitFormat;
    final Map<String, Element> fragments;
    final Map<String, List<String>> ignoredElements;
    private Warnings warnings;

    AbstractParser(Symbols symbols, Map<String, Element> map, NumberFormat numberFormat, DateFormat dateFormat, UnitFormat unitFormat, Locale locale) {
        ArgumentChecks.ensureNonNull("symbols", symbols);
        if (numberFormat == null) {
            numberFormat = symbols.createNumberFormat();
        }
        this.symbols = symbols;
        this.fragments = map;
        this.dateFormat = dateFormat;
        this.unitFormat = unitFormat;
        this.errorLocale = locale;
        if (numberFormat instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)numberFormat.clone();
            this.exponentSymbol = decimalFormat.getDecimalFormatSymbols().getExponentSeparator();
            String string = decimalFormat.toPattern();
            if (!string.contains("E0")) {
                StringBuilder stringBuilder = new StringBuilder(string);
                int n = string.indexOf(59);
                if (n >= 0) {
                    stringBuilder.insert(n, "E0");
                }
                stringBuilder.append("E0");
                decimalFormat.applyPattern(stringBuilder.toString());
            }
            this.numberFormat = decimalFormat;
        } else {
            this.numberFormat = numberFormat;
            this.exponentSymbol = null;
        }
        this.ignoredElements = new LinkedHashMap<String, List<String>>();
    }

    abstract String getPublicFacade();

    String getFacadeMethod() {
        return "createFromWKT";
    }

    @Override
    public final Object createFromWKT(String string) throws FactoryException {
        Object object;
        try {
            object = this.parseObject(string, new ParsePosition(0));
        }
        catch (ParseException parseException) {
            Throwable throwable = parseException.getCause();
            if (throwable instanceof FactoryException) {
                throw (FactoryException)throwable;
            }
            throw new FactoryException(parseException.getLocalizedMessage(), (Throwable)parseException);
        }
        Warnings warnings = this.getAndClearWarnings(object);
        if (warnings != null) {
            this.log(new LogRecord(Level.WARNING, warnings.toString()));
        }
        return object;
    }

    final void log(LogRecord logRecord) {
        Logger logger = Logging.getLogger("org.apache.sis.io.wkt");
        logRecord.setSourceClassName(this.getPublicFacade());
        logRecord.setSourceMethodName(this.getFacadeMethod());
        logRecord.setLoggerName(logger.getName());
        logger.log(logRecord);
    }

    static int endOfFragmentName(String string, int n) {
        int n2;
        int n3 = string.length();
        while (n < n3 && Character.isUnicodeIdentifierPart(n2 = string.codePointAt(n))) {
            n += Character.charCount(n2);
        }
        return n;
    }

    public Object parseObject(String string, ParsePosition parsePosition) throws ParseException {
        Object object;
        Element element;
        this.warnings = null;
        this.ignoredElements.clear();
        ArgumentChecks.ensureNonEmpty("text", string);
        int n = CharSequences.skipLeadingWhitespaces(string, parsePosition.getIndex(), string.length());
        if (n < string.length() && string.charAt(n) == '$') {
            int n2;
            if ((element = this.fragments.get(object = string.substring(++n, n2 = AbstractParser.endOfFragmentName(string, n)))) == null) {
                parsePosition.setErrorIndex(n);
                throw new UnparsableObjectException(this.errorLocale, 95, new Object[]{object}, n);
            }
            parsePosition.setIndex(n2);
            element = new Element(element);
        } else {
            element = new Element(this, string, parsePosition, null);
        }
        Element element2 = new Element("<root>", element);
        object = this.parseObject(element2);
        element2.close(this.ignoredElements);
        return object;
    }

    abstract Object parseObject(Element var1) throws ParseException;

    final Number parseNumber(String string, ParsePosition parsePosition) {
        int n;
        int n2 = parsePosition.getIndex();
        Number number = this.numberFormat.parse(string, parsePosition);
        if (number != null && this.exponentSymbol != null && string.regionMatches(true, n = parsePosition.getIndex(), this.exponentSymbol, 0, this.exponentSymbol.length())) {
            string = new StringBuilder(string).replace(n, n + this.exponentSymbol.length(), this.exponentSymbol).toString();
            parsePosition.setIndex(n2);
            number = this.numberFormat.parse(string, parsePosition);
        }
        return number;
    }

    final Date parseDate(String string, ParsePosition parsePosition) {
        if (this.dateFormat == null) {
            this.dateFormat = new StandardDateFormat(this.symbols.getLocale());
        }
        return this.dateFormat.parse(string, parsePosition);
    }

    final Unit<?> parseUnit(String string) throws ParserException {
        if (this.unitFormat == null) {
            Locale locale = this.symbols.getLocale();
            if (locale == Locale.ROOT) {
                return Units.valueOf(string);
            }
            this.unitFormat = new UnitFormat(locale);
            this.unitFormat.setStyle(UnitFormat.Style.NAME);
        }
        return this.unitFormat.parse(string);
    }

    final void warning(Element element, Element element2, InternationalString internationalString, Exception exception) {
        this.warning(element, element2 != null ? element2.keyword : null, internationalString, exception);
    }

    final void warning(Element element, String string, InternationalString internationalString, Exception exception) {
        String[] stringArray;
        if (this.warnings == null) {
            this.warnings = new Warnings(this.errorLocale, true, this.ignoredElements);
        }
        if (element != null && string != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = element.keyword;
            stringArray = stringArray2;
            stringArray2[1] = string;
        } else {
            stringArray = null;
        }
        this.warnings.add(internationalString, exception, stringArray);
    }

    final Warnings getAndClearWarnings(Object object) {
        Warnings warnings = this.warnings;
        this.warnings = null;
        if (warnings == null) {
            if (this.ignoredElements.isEmpty()) {
                return null;
            }
            warnings = new Warnings(this.errorLocale, true, this.ignoredElements);
        }
        warnings.setRoot(object);
        return warnings;
    }
}

