/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.OptimisticLockRetryPolicyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.aggregate.AggregateController;
import org.apache.camel.processor.aggregate.AggregateProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.processor.aggregate.OptimisticLockRetryPolicy;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.AggregationRepository;
import org.apache.camel.spi.InternalProcessor;
import org.apache.camel.util.concurrent.SynchronousExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateReifier
extends ProcessorReifier<AggregateDefinition> {
    private static final Logger LOG = LoggerFactory.getLogger(AggregateReifier.class);

    public AggregateReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (ProcessorDefinition)AggregateDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        return this.createAggregator();
    }

    protected AggregateProcessor createAggregator() throws Exception {
        Long completionTimeoutCheckerInterval;
        Boolean completeAllOnStop;
        Boolean forceCompletionOnStop;
        Boolean discardOnAggregationFailure;
        Boolean discardOnCompletionTimeout;
        Integer closeCorrelationKeyOnCompletion;
        Boolean ignoreInvalidCorrelationKeys;
        Boolean eagerCheckCompletion;
        Boolean completionOnNewCorrelationGroup;
        Boolean completionFromBatchConsumer;
        Integer completionSize;
        Long completionInterval;
        Long completionTimeout;
        Processor childProcessor = this.createChildProcessor(true);
        InternalProcessor target = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getInternalProcessorFactory().addUnitOfWorkProcessorAdvice(this.camelContext, childProcessor, this.route);
        Expression correlation = this.createExpression(((AggregateDefinition)this.definition).getExpression());
        AggregationStrategy strategy = this.createAggregationStrategy();
        boolean parallel = this.parseBoolean(((AggregateDefinition)this.definition).getParallelProcessing(), false);
        boolean shutdownThreadPool = this.willCreateNewThreadPool((ExecutorServiceAwareDefinition)this.definition, parallel);
        ExecutorService threadPool = this.getConfiguredExecutorService("Aggregator", (ExecutorServiceAwareDefinition)this.definition, parallel);
        if (threadPool == null && !parallel) {
            threadPool = new SynchronousExecutorService();
            shutdownThreadPool = true;
        }
        AggregateProcessor answer = new AggregateProcessor(this.camelContext, (AsyncProcessor)target, correlation, strategy, threadPool, shutdownThreadPool);
        AggregationRepository repository = this.createAggregationRepository();
        if (repository != null) {
            answer.setAggregationRepository(repository);
        }
        if (((AggregateDefinition)this.definition).getAggregateController() == null && ((AggregateDefinition)this.definition).getAggregateControllerRef() != null) {
            ((AggregateDefinition)this.definition).setAggregateController(this.mandatoryLookup(((AggregateDefinition)this.definition).getAggregateControllerRef(), AggregateController.class));
        }
        boolean shutdownTimeoutThreadPool = false;
        ScheduledExecutorService timeoutThreadPool = ((AggregateDefinition)this.definition).getTimeoutCheckerExecutorService();
        if (timeoutThreadPool == null && ((AggregateDefinition)this.definition).getTimeoutCheckerExecutorServiceRef() != null && (timeoutThreadPool = this.lookup(((AggregateDefinition)this.definition).getTimeoutCheckerExecutorServiceRef(), ScheduledExecutorService.class)) == null) {
            timeoutThreadPool = this.camelContext.getExecutorServiceManager().newScheduledThreadPool((Object)this, "AggregateTimeoutChecker", ((AggregateDefinition)this.definition).getTimeoutCheckerExecutorServiceRef());
            if (timeoutThreadPool == null) {
                throw new IllegalArgumentException("ExecutorServiceRef " + ((AggregateDefinition)this.definition).getTimeoutCheckerExecutorServiceRef() + " not found in registry (as an ScheduledExecutorService instance) or as a thread pool profile.");
            }
            shutdownTimeoutThreadPool = true;
        }
        answer.setTimeoutCheckerExecutorService(timeoutThreadPool);
        answer.setShutdownTimeoutCheckerExecutorService(shutdownTimeoutThreadPool);
        if (this.parseBoolean(((AggregateDefinition)this.definition).getCompletionFromBatchConsumer(), false) && this.parseBoolean(((AggregateDefinition)this.definition).getDiscardOnAggregationFailure(), false)) {
            throw new IllegalArgumentException("Cannot use both completionFromBatchConsumer and discardOnAggregationFailure on: " + this.definition);
        }
        answer.setParallelProcessing(parallel);
        Boolean optimisticLocking = this.parseBoolean(((AggregateDefinition)this.definition).getOptimisticLocking());
        if (optimisticLocking != null) {
            answer.setOptimisticLocking(optimisticLocking.booleanValue());
        }
        if (((AggregateDefinition)this.definition).getCompletionPredicate() != null) {
            Predicate predicate = this.createPredicate(((AggregateDefinition)this.definition).getCompletionPredicate());
            answer.setCompletionPredicate(predicate);
        } else if (strategy instanceof Predicate) {
            LOG.debug("Using AggregationStrategy as completion predicate: {}", (Object)strategy);
            answer.setCompletionPredicate((Predicate)strategy);
        }
        if (((AggregateDefinition)this.definition).getCompletionTimeoutExpression() != null) {
            Expression expression = this.createExpression(((AggregateDefinition)this.definition).getCompletionTimeoutExpression());
            answer.setCompletionTimeoutExpression(expression);
        }
        if ((completionTimeout = this.parseDuration(((AggregateDefinition)this.definition).getCompletionTimeout())) != null) {
            answer.setCompletionTimeout(completionTimeout.longValue());
        }
        if ((completionInterval = this.parseDuration(((AggregateDefinition)this.definition).getCompletionInterval())) != null) {
            answer.setCompletionInterval(completionInterval.longValue());
        }
        if (((AggregateDefinition)this.definition).getCompletionSizeExpression() != null) {
            Expression expression = this.createExpression(((AggregateDefinition)this.definition).getCompletionSizeExpression());
            answer.setCompletionSizeExpression(expression);
        }
        if ((completionSize = this.parseInt(((AggregateDefinition)this.definition).getCompletionSize())) != null) {
            answer.setCompletionSize(completionSize.intValue());
        }
        if ((completionFromBatchConsumer = this.parseBoolean(((AggregateDefinition)this.definition).getCompletionFromBatchConsumer())) != null) {
            answer.setCompletionFromBatchConsumer(completionFromBatchConsumer.booleanValue());
        }
        if ((completionOnNewCorrelationGroup = this.parseBoolean(((AggregateDefinition)this.definition).getCompletionOnNewCorrelationGroup())) != null) {
            answer.setCompletionOnNewCorrelationGroup(completionOnNewCorrelationGroup.booleanValue());
        }
        if ((eagerCheckCompletion = this.parseBoolean(((AggregateDefinition)this.definition).getEagerCheckCompletion())) != null) {
            answer.setEagerCheckCompletion(eagerCheckCompletion.booleanValue());
        }
        if ((ignoreInvalidCorrelationKeys = this.parseBoolean(((AggregateDefinition)this.definition).getIgnoreInvalidCorrelationKeys())) != null) {
            answer.setIgnoreInvalidCorrelationKeys(ignoreInvalidCorrelationKeys.booleanValue());
        }
        if ((closeCorrelationKeyOnCompletion = this.parseInt(((AggregateDefinition)this.definition).getCloseCorrelationKeyOnCompletion())) != null) {
            answer.setCloseCorrelationKeyOnCompletion(closeCorrelationKeyOnCompletion);
        }
        if ((discardOnCompletionTimeout = this.parseBoolean(((AggregateDefinition)this.definition).getDiscardOnCompletionTimeout())) != null) {
            answer.setDiscardOnCompletionTimeout(discardOnCompletionTimeout.booleanValue());
        }
        if ((discardOnAggregationFailure = this.parseBoolean(((AggregateDefinition)this.definition).getDiscardOnAggregationFailure())) != null) {
            answer.setDiscardOnAggregationFailure(discardOnAggregationFailure.booleanValue());
        }
        if ((forceCompletionOnStop = this.parseBoolean(((AggregateDefinition)this.definition).getForceCompletionOnStop())) != null) {
            answer.setForceCompletionOnStop(forceCompletionOnStop.booleanValue());
        }
        if ((completeAllOnStop = this.parseBoolean(((AggregateDefinition)this.definition).getCompleteAllOnStop())) != null) {
            answer.setCompleteAllOnStop(completeAllOnStop.booleanValue());
        }
        if (((AggregateDefinition)this.definition).getOptimisticLockRetryPolicy() == null) {
            if (((AggregateDefinition)this.definition).getOptimisticLockRetryPolicyDefinition() != null) {
                answer.setOptimisticLockRetryPolicy(this.createOptimisticLockRetryPolicy(((AggregateDefinition)this.definition).getOptimisticLockRetryPolicyDefinition()));
            }
        } else {
            answer.setOptimisticLockRetryPolicy(((AggregateDefinition)this.definition).getOptimisticLockRetryPolicy());
        }
        if (((AggregateDefinition)this.definition).getAggregateController() != null) {
            answer.setAggregateController(((AggregateDefinition)this.definition).getAggregateController());
        }
        if ((completionTimeoutCheckerInterval = this.parseDuration(((AggregateDefinition)this.definition).getCompletionTimeoutCheckerInterval())) != null) {
            answer.setCompletionTimeoutCheckerInterval(completionTimeoutCheckerInterval.longValue());
        }
        return answer;
    }

    public OptimisticLockRetryPolicy createOptimisticLockRetryPolicy(OptimisticLockRetryPolicyDefinition definition) {
        Long dur;
        OptimisticLockRetryPolicy policy = new OptimisticLockRetryPolicy();
        Integer num = this.parseInt(definition.getMaximumRetries());
        if (num != null) {
            policy.setMaximumRetries(num.intValue());
        }
        if ((dur = this.parseDuration(definition.getRetryDelay())) != null) {
            policy.setRetryDelay(dur.longValue());
        }
        if ((dur = this.parseDuration(definition.getMaximumRetryDelay())) != null) {
            policy.setMaximumRetryDelay(dur.longValue());
        }
        if (definition.getExponentialBackOff() != null) {
            policy.setExponentialBackOff(this.parseBoolean(definition.getExponentialBackOff(), true));
        }
        if (definition.getRandomBackOff() != null) {
            policy.setRandomBackOff(this.parseBoolean(definition.getRandomBackOff(), false));
        }
        return policy;
    }

    private AggregationStrategy createAggregationStrategy() {
        AggregationStrategy strategy = ((AggregateDefinition)this.definition).getAggregationStrategy();
        if (strategy == null && ((AggregateDefinition)this.definition).getStrategyRef() != null) {
            Object aggStrategy = this.lookup(((AggregateDefinition)this.definition).getStrategyRef(), Object.class);
            if (aggStrategy instanceof AggregationStrategy) {
                strategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy != null) {
                AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(aggStrategy, ((AggregateDefinition)this.definition).getAggregationStrategyMethodName());
                if (((AggregateDefinition)this.definition).getStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(this.parseBoolean(((AggregateDefinition)this.definition).getStrategyMethodAllowNull(), false));
                    adapter.setAllowNullOldExchange(this.parseBoolean(((AggregateDefinition)this.definition).getStrategyMethodAllowNull(), false));
                }
                strategy = adapter;
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + ((AggregateDefinition)this.definition).getStrategyRef());
            }
        }
        if (strategy == null) {
            throw new IllegalArgumentException("AggregationStrategy or AggregationStrategyRef must be set on " + this);
        }
        if (strategy instanceof CamelContextAware) {
            ((CamelContextAware)strategy).setCamelContext(this.camelContext);
        }
        return strategy;
    }

    private AggregationRepository createAggregationRepository() {
        AggregationRepository repository = ((AggregateDefinition)this.definition).getAggregationRepository();
        if (repository == null && ((AggregateDefinition)this.definition).getAggregationRepositoryRef() != null) {
            repository = this.mandatoryLookup(((AggregateDefinition)this.definition).getAggregationRepositoryRef(), AggregationRepository.class);
        }
        return repository;
    }
}

