/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.processor.idempotent.IdempotentOnCompletion;
import org.apache.camel.processor.idempotent.NoMessageIdException;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdempotentConsumer
extends AsyncProcessorSupport
implements CamelContextAware,
Navigate<Processor>,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(IdempotentConsumer.class);
    private CamelContext camelContext;
    private String id;
    private String routeId;
    private final Expression messageIdExpression;
    private final AsyncProcessor processor;
    private final IdempotentRepository idempotentRepository;
    private final boolean eager;
    private final boolean completionEager;
    private final boolean skipDuplicate;
    private final boolean removeOnFailure;
    private final AtomicLong duplicateMessageCount = new AtomicLong();

    public IdempotentConsumer(Expression messageIdExpression, IdempotentRepository idempotentRepository, boolean eager, boolean completionEager, boolean skipDuplicate, boolean removeOnFailure, Processor processor) {
        this.messageIdExpression = messageIdExpression;
        this.idempotentRepository = idempotentRepository;
        this.eager = eager;
        this.completionEager = completionEager;
        this.skipDuplicate = skipDuplicate;
        this.removeOnFailure = removeOnFailure;
        this.processor = AsyncProcessorConverterHelper.convert((Processor)processor);
    }

    public String toString() {
        return this.id;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        AsyncCallback target;
        String messageId;
        try {
            messageId = (String)this.messageIdExpression.evaluate(exchange, String.class);
            if (messageId == null) {
                exchange.setException((Throwable)((Object)new NoMessageIdException(exchange, this.messageIdExpression)));
                callback.done(true);
                return true;
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        try {
            boolean newKey;
            if (this.eager) {
                newKey = this.idempotentRepository.add(exchange, messageId);
            } else {
                boolean bl = newKey = !this.idempotentRepository.contains(exchange, messageId);
            }
            if (!newKey) {
                exchange.setProperty(ExchangePropertyKey.DUPLICATE_MESSAGE, (Object)Boolean.TRUE);
                this.onDuplicate(exchange, messageId);
                if (this.skipDuplicate) {
                    LOG.debug("Ignoring duplicate message with id: {} for exchange: {}", (Object)messageId, (Object)exchange);
                    callback.done(true);
                    return true;
                }
            }
            IdempotentOnCompletion onCompletion = new IdempotentOnCompletion(this.idempotentRepository, messageId, this.eager, this.removeOnFailure);
            if (this.completionEager) {
                target = new IdempotentConsumerCallback(exchange, onCompletion, callback);
            } else {
                target = callback;
                ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion((Synchronization)onCompletion);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        return this.processor.process(exchange, target);
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add((Processor)this.processor);
        return answer;
    }

    public boolean hasNext() {
        return this.processor != null;
    }

    public Expression getMessageIdExpression() {
        return this.messageIdExpression;
    }

    public IdempotentRepository getIdempotentRepository() {
        return this.idempotentRepository;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public long getDuplicateMessageCount() {
        return this.duplicateMessageCount.get();
    }

    protected void doStart() throws Exception {
        if (!this.camelContext.hasService((Object)this.idempotentRepository)) {
            this.camelContext.addService((Object)this.idempotentRepository);
        }
        ServiceHelper.startService((Object[])new Object[]{this.processor, this.idempotentRepository});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.processor, this.idempotentRepository});
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.processor, this.idempotentRepository});
        this.camelContext.removeService((Object)this.idempotentRepository);
    }

    public boolean isEager() {
        return this.eager;
    }

    public boolean isCompletionEager() {
        return this.completionEager;
    }

    public boolean isSkipDuplicate() {
        return this.skipDuplicate;
    }

    public boolean isRemoveOnFailure() {
        return this.removeOnFailure;
    }

    public void resetDuplicateMessageCount() {
        this.duplicateMessageCount.set(0L);
    }

    private void onDuplicate(Exchange exchange, String messageId) {
        this.duplicateMessageCount.incrementAndGet();
        this.onDuplicateMessage(exchange, messageId);
    }

    public void clear() {
        this.idempotentRepository.clear();
    }

    protected void onDuplicateMessage(Exchange exchange, String messageId) {
    }

    private static class IdempotentConsumerCallback
    implements AsyncCallback {
        private final Exchange exchange;
        private final Synchronization onCompletion;
        private final AsyncCallback callback;

        IdempotentConsumerCallback(Exchange exchange, Synchronization onCompletion, AsyncCallback callback) {
            this.exchange = exchange;
            this.onCompletion = onCompletion;
            this.callback = callback;
        }

        public void done(boolean doneSync) {
            try {
                if (this.exchange.isFailed()) {
                    this.onCompletion.onFailure(this.exchange);
                } else {
                    this.onCompletion.onComplete(this.exchange);
                }
            }
            finally {
                this.callback.done(doneSync);
            }
        }

        public String toString() {
            return "IdempotentConsumerCallback";
        }
    }
}

