/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.parity.methods.response;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import java.util.stream.Collectors;

public class StateDiff {
    private State balance;
    private State code;
    private State nonce;
    private Map<String, State> storage;

    public StateDiff() {
    }

    public StateDiff(State balance, State code, State nonce, Map<String, State> storage) {
        this.balance = balance;
        this.code = code;
        this.nonce = nonce;
        this.storage = storage;
    }

    public State getBalance() {
        return this.balance;
    }

    public void setBalance(JsonNode balance) {
        this.balance = this.deserializeState(balance);
    }

    public State getCode() {
        return this.code;
    }

    public void setCode(JsonNode code) {
        this.code = this.deserializeState(code);
    }

    public State getNonce() {
        return this.nonce;
    }

    public void setNonce(JsonNode nonce) {
        this.nonce = this.deserializeState(nonce);
    }

    public Map<String, State> getStorage() {
        return this.storage;
    }

    public void setStorage(Map<String, JsonNode> storage) {
        this.storage = storage.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.deserializeState((JsonNode)entry.getValue())));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof StateDiff)) {
            return false;
        }
        StateDiff that = (StateDiff)o;
        if (this.getBalance() != null ? !this.getBalance().equals(that.getBalance()) : that.getBalance() != null) {
            return false;
        }
        if (this.getCode() != null ? !this.getCode().equals(that.getCode()) : that.getCode() != null) {
            return false;
        }
        if (this.getNonce() != null ? !this.getNonce().equals(that.getNonce()) : that.getNonce() != null) {
            return false;
        }
        return this.getStorage() != null ? this.getStorage().equals(that.getStorage()) : that.getStorage() == null;
    }

    public int hashCode() {
        int result = this.getBalance() != null ? this.getBalance().hashCode() : 0;
        result = 31 * result + (this.getCode() != null ? this.getCode().hashCode() : 0);
        result = 31 * result + (this.getNonce() != null ? this.getNonce().hashCode() : 0);
        result = 31 * result + (this.getStorage() != null ? this.getStorage().hashCode() : 0);
        return result;
    }

    private State deserializeState(JsonNode node) {
        JsonNode subNode;
        State state = null;
        if (node.isTextual() && node.asText().equals("=")) {
            state = new UnchangedState();
        } else if (node.isObject() && node.has("*")) {
            JsonNode subNode2 = node.get("*");
            if (subNode2.isObject() && subNode2.has("from") && subNode2.has("to")) {
                state = new ChangedState(subNode2.get("from").asText(), subNode2.get("to").asText());
            }
        } else if (node.isObject() && node.has("+") && (subNode = node.get("+")).isTextual()) {
            state = new AddedState(subNode.asText());
        }
        return state;
    }

    public String toString() {
        return "StateDiff{balance=" + this.getBalance() + ", code=" + this.getCode() + ", nonce=" + this.getNonce() + ", storage=" + this.getStorage() + '}';
    }

    public static class AddedState
    implements State {
        private String value;

        public AddedState() {
        }

        public AddedState(String value) {
            this.value = value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public String getFrom() {
            return null;
        }

        @Override
        public String getTo() {
            return this.value;
        }

        @Override
        public boolean isChanged() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof AddedState)) {
                return false;
            }
            AddedState that = (AddedState)o;
            return this.value != null ? this.value.equals(that.value) : that.value == null;
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        public String toString() {
            return "AddedState{value='" + this.value + '\'' + '}';
        }
    }

    public static class UnchangedState
    implements State {
        public UnchangedState(String jsonString) {
        }

        public UnchangedState() {
        }

        @Override
        public boolean isChanged() {
            return false;
        }

        @Override
        public String getFrom() {
            return null;
        }

        @Override
        public String getTo() {
            return null;
        }

        public boolean equals(Object o) {
            return o != null && (this == o || o instanceof UnchangedState);
        }

        public int hashCode() {
            return 0;
        }
    }

    public static class ChangedState
    implements State {
        private String from;
        private String to;

        public ChangedState() {
        }

        public ChangedState(String from, String to) {
            this.from = from;
            this.to = to;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public void setTo(String to) {
            this.to = to;
        }

        @Override
        public boolean isChanged() {
            return true;
        }

        @Override
        public String getFrom() {
            return this.from;
        }

        @Override
        public String getTo() {
            return this.to;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof ChangedState)) {
                return false;
            }
            ChangedState that = (ChangedState)o;
            if (this.getFrom() != null ? !this.getFrom().equals(that.getFrom()) : that.getFrom() != null) {
                return false;
            }
            return this.getTo() != null ? this.getTo().equals(that.getTo()) : that.getTo() == null;
        }

        public int hashCode() {
            int result = this.getFrom() != null ? this.getFrom().hashCode() : 0;
            result = 31 * result + (this.getTo() != null ? this.getTo().hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ChangedState{from='" + this.from + '\'' + ", to='" + this.to + '\'' + '}';
        }
    }

    public static interface State {
        public boolean isChanged();

        public String getFrom();

        public String getTo();
    }
}

