/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.time.Duration;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.converter.DurationConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public final class DurationConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        DurationConverterLoader.addTypeConverter(registry, String.class, Duration.class, false, (type, exchange, value) -> DurationConverter.toString((Duration)value));
        DurationConverterLoader.addTypeConverter(registry, Duration.class, String.class, false, (type, exchange, value) -> DurationConverter.toDuration((String)value));
        DurationConverterLoader.addTypeConverter(registry, Long.TYPE, Duration.class, false, (type, exchange, value) -> DurationConverter.toMilliSeconds((Duration)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

